(function() {
  var UIWatcher;

  UIWatcher = require('./ui-watcher');

  module.exports = {
    commandDisposable: null,
    activate: function(state) {
      var activatedDisposable, uiWatcher;
      if (!(atom.inDevMode() && !atom.inSpecMode())) {
        return;
      }
      uiWatcher = null;
      activatedDisposable = atom.packages.onDidActivateInitialPackages(function() {
        uiWatcher = new UIWatcher({
          themeManager: atom.themes
        });
        return activatedDisposable.dispose();
      });
      return this.commandDisposable = atom.commands.add('atom-workspace', 'dev-live-reload:reload-all', function() {
        return uiWatcher != null ? uiWatcher.reloadAll() : void 0;
      });
    },
    deactivate: function() {
      var ref;
      return (ref = this.commandDisposable) != null ? ref.dispose() : void 0;
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiL2hvbWUvdHJhdmlzL2J1aWxkL2F0b20vYXRvbS9vdXQvYXBwL25vZGVfbW9kdWxlcy9kZXYtbGl2ZS1yZWxvYWQvbGliL21haW4uY29mZmVlIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0FBQUEsTUFBQTs7RUFBQSxTQUFBLEdBQVksT0FBQSxDQUFRLGNBQVI7O0VBRVosTUFBTSxDQUFDLE9BQVAsR0FDRTtJQUFBLGlCQUFBLEVBQW1CLElBQW5CO0lBQ0EsUUFBQSxFQUFVLFNBQUMsS0FBRDtBQUNSLFVBQUE7TUFBQSxJQUFBLENBQUEsQ0FBYyxJQUFJLENBQUMsU0FBTCxDQUFBLENBQUEsSUFBcUIsQ0FBSSxJQUFJLENBQUMsVUFBTCxDQUFBLENBQXZDLENBQUE7QUFBQSxlQUFBOztNQUVBLFNBQUEsR0FBWTtNQUNaLG1CQUFBLEdBQXNCLElBQUksQ0FBQyxRQUFRLENBQUMsNEJBQWQsQ0FBMkMsU0FBQTtRQUMvRCxTQUFBLEdBQWdCLElBQUEsU0FBQSxDQUFVO1VBQUEsWUFBQSxFQUFjLElBQUksQ0FBQyxNQUFuQjtTQUFWO2VBQ2hCLG1CQUFtQixDQUFDLE9BQXBCLENBQUE7TUFGK0QsQ0FBM0M7YUFJdEIsSUFBQyxDQUFBLGlCQUFELEdBQXFCLElBQUksQ0FBQyxRQUFRLENBQUMsR0FBZCxDQUFrQixnQkFBbEIsRUFBb0MsNEJBQXBDLEVBQWtFLFNBQUE7bUNBQ3JGLFNBQVMsQ0FBRSxTQUFYLENBQUE7TUFEcUYsQ0FBbEU7SUFSYixDQURWO0lBWUEsVUFBQSxFQUFZLFNBQUE7QUFDVixVQUFBO3lEQUFrQixDQUFFLE9BQXBCLENBQUE7SUFEVSxDQVpaOztBQUhGIiwic291cmNlc0NvbnRlbnQiOlsiVUlXYXRjaGVyID0gcmVxdWlyZSAnLi91aS13YXRjaGVyJ1xuXG5tb2R1bGUuZXhwb3J0cyA9XG4gIGNvbW1hbmREaXNwb3NhYmxlOiBudWxsXG4gIGFjdGl2YXRlOiAoc3RhdGUpIC0+XG4gICAgcmV0dXJuIHVubGVzcyBhdG9tLmluRGV2TW9kZSgpIGFuZCBub3QgYXRvbS5pblNwZWNNb2RlKClcblxuICAgIHVpV2F0Y2hlciA9IG51bGxcbiAgICBhY3RpdmF0ZWREaXNwb3NhYmxlID0gYXRvbS5wYWNrYWdlcy5vbkRpZEFjdGl2YXRlSW5pdGlhbFBhY2thZ2VzIC0+XG4gICAgICB1aVdhdGNoZXIgPSBuZXcgVUlXYXRjaGVyKHRoZW1lTWFuYWdlcjogYXRvbS50aGVtZXMpXG4gICAgICBhY3RpdmF0ZWREaXNwb3NhYmxlLmRpc3Bvc2UoKVxuXG4gICAgQGNvbW1hbmREaXNwb3NhYmxlID0gYXRvbS5jb21tYW5kcy5hZGQgJ2F0b20td29ya3NwYWNlJywgJ2Rldi1saXZlLXJlbG9hZDpyZWxvYWQtYWxsJywgLT5cbiAgICAgIHVpV2F0Y2hlcj8ucmVsb2FkQWxsKClcblxuICBkZWFjdGl2YXRlOiAtPlxuICAgIEBjb21tYW5kRGlzcG9zYWJsZT8uZGlzcG9zZSgpXG4iXX0=
