Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _grim = require('grim');

var _grim2 = _interopRequireDefault(_grim);

var _marked = require('marked');

var _marked2 = _interopRequireDefault(_marked);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _shell = require('shell');

var _shell2 = _interopRequireDefault(_shell);

var DeprecationCopView = (function () {
  function DeprecationCopView(_ref) {
    var _this = this;

    var uri = _ref.uri;

    _classCallCheck(this, DeprecationCopView);

    this.uri = uri;
    this.subscriptions = new _atom.CompositeDisposable();
    this.subscriptions.add(_grim2['default'].on('updated', function () {
      _etch2['default'].update(_this);
    }));
    // TODO: Remove conditional when the new StyleManager deprecation APIs reach stable.
    if (atom.styles.onDidUpdateDeprecations) {
      this.subscriptions.add(atom.styles.onDidUpdateDeprecations(function () {
        _etch2['default'].update(_this);
      }));
    }
    _etch2['default'].initialize(this);
    this.subscriptions.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));
  }

  _createClass(DeprecationCopView, [{
    key: 'serialize',
    value: function serialize() {
      return {
        deserializer: this.constructor.name,
        uri: this.getURI(),
        version: 1
      };
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.subscriptions.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {
      return _etch2['default'].update(this);
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      return _etch2['default'].dom(
        'div',
        { className: 'deprecation-cop pane-item native-key-bindings', tabIndex: '-1' },
        _etch2['default'].dom(
          'div',
          { className: 'panel' },
          _etch2['default'].dom(
            'div',
            { className: 'padded deprecation-overview' },
            _etch2['default'].dom(
              'div',
              { className: 'pull-right btn-group' },
              _etch2['default'].dom(
                'button',
                {
                  className: 'btn btn-primary check-for-update',
                  onclick: function (event) {
                    event.preventDefault();
                    _this2.checkForUpdates();
                  } },
                'Check for Updates'
              )
            )
          ),
          _etch2['default'].dom(
            'div',
            { className: 'panel-heading' },
            _etch2['default'].dom(
              'span',
              null,
              'Deprecated calls'
            )
          ),
          _etch2['default'].dom(
            'ul',
            { className: 'list-tree has-collapsable-children' },
            this.renderDeprecatedCalls()
          ),
          _etch2['default'].dom(
            'div',
            { className: 'panel-heading' },
            _etch2['default'].dom(
              'span',
              null,
              'Deprecated selectors'
            )
          ),
          _etch2['default'].dom(
            'ul',
            { className: 'selectors list-tree has-collapsable-children' },
            this.renderDeprecatedSelectors()
          )
        )
      );
    }
  }, {
    key: 'renderDeprecatedCalls',
    value: function renderDeprecatedCalls() {
      var _this3 = this;

      var deprecationsByPackageName = this.getDeprecatedCallsByPackageName();
      var packageNames = Object.keys(deprecationsByPackageName);
      if (packageNames.length === 0) {
        return _etch2['default'].dom(
          'li',
          { className: 'list-item' },
          'No deprecated calls'
        );
      } else {
        return packageNames.sort().map(function (packageName) {
          return _etch2['default'].dom(
            'li',
            { className: 'deprecation list-nested-item collapsed' },
            _etch2['default'].dom(
              'div',
              { className: 'deprecation-info list-item', onclick: function (event) {
                  return event.target.parentElement.classList.toggle('collapsed');
                } },
              _etch2['default'].dom(
                'span',
                { className: 'text-highlight' },
                packageName || 'atom core'
              ),
              _etch2['default'].dom(
                'span',
                null,
                ' (' + _underscorePlus2['default'].pluralize(deprecationsByPackageName[packageName].length, 'deprecation') + ')'
              )
            ),
            _etch2['default'].dom(
              'ul',
              { className: 'list' },
              _this3.renderPackageActionsIfNeeded(packageName),
              deprecationsByPackageName[packageName].map(function (_ref2) {
                var deprecation = _ref2.deprecation;
                var stack = _ref2.stack;
                return _etch2['default'].dom(
                  'li',
                  { className: 'list-item deprecation-detail' },
                  _etch2['default'].dom('span', { className: 'text-warning icon icon-alert' }),
                  _etch2['default'].dom('div', { className: 'list-item deprecation-message', innerHTML: (0, _marked2['default'])(deprecation.getMessage()) }),
                  _this3.renderIssueURLIfNeeded(packageName, deprecation, _this3.buildIssueURL(packageName, deprecation, stack)),
                  _etch2['default'].dom(
                    'div',
                    { className: 'stack-trace' },
                    stack.map(function (_ref3) {
                      var functionName = _ref3.functionName;
                      var location = _ref3.location;
                      return _etch2['default'].dom(
                        'div',
                        { className: 'stack-line' },
                        _etch2['default'].dom(
                          'span',
                          null,
                          functionName
                        ),
                        _etch2['default'].dom(
                          'span',
                          null,
                          ' - '
                        ),
                        _etch2['default'].dom(
                          'a',
                          {
                            className: 'stack-line-location',
                            href: location,
                            onclick: function (event) {
                              event.preventDefault();
                              _this3.openLocation(location);
                            } },
                          location
                        )
                      );
                    })
                  )
                );
              })
            )
          );
        });
      }
    }
  }, {
    key: 'renderDeprecatedSelectors',
    value: function renderDeprecatedSelectors() {
      var _this4 = this;

      var deprecationsByPackageName = this.getDeprecatedSelectorsByPackageName();
      var packageNames = Object.keys(deprecationsByPackageName);
      if (packageNames.length === 0) {
        return _etch2['default'].dom(
          'li',
          { className: 'list-item' },
          'No deprecated selectors'
        );
      } else {
        return packageNames.map(function (packageName) {
          return _etch2['default'].dom(
            'li',
            { className: 'deprecation list-nested-item collapsed' },
            _etch2['default'].dom(
              'div',
              { className: 'deprecation-info list-item', onclick: function (event) {
                  return event.target.parentElement.classList.toggle('collapsed');
                } },
              _etch2['default'].dom(
                'span',
                { className: 'text-highlight' },
                packageName
              )
            ),
            _etch2['default'].dom(
              'ul',
              { className: 'list' },
              _this4.renderPackageActionsIfNeeded(packageName),
              deprecationsByPackageName[packageName].map(function (_ref4) {
                var packagePath = _ref4.packagePath;
                var sourcePath = _ref4.sourcePath;
                var deprecation = _ref4.deprecation;

                var relativeSourcePath = _path2['default'].relative(packagePath, sourcePath);
                var issueTitle = 'Deprecated selector in `' + relativeSourcePath + '`';
                var issueBody = 'In `' + relativeSourcePath + '`: \n\n' + deprecation.message;
                return _etch2['default'].dom(
                  'li',
                  { className: 'list-item source-file' },
                  _etch2['default'].dom(
                    'a',
                    {
                      className: 'source-url',
                      href: sourcePath,
                      onclick: function (event) {
                        event.preventDefault();
                        _this4.openLocation(sourcePath);
                      } },
                    relativeSourcePath
                  ),
                  _etch2['default'].dom(
                    'ul',
                    { className: 'list' },
                    _etch2['default'].dom(
                      'li',
                      { className: 'list-item deprecation-detail' },
                      _etch2['default'].dom('span', { className: 'text-warning icon icon-alert' }),
                      _etch2['default'].dom('div', { className: 'list-item deprecation-message', innerHTML: (0, _marked2['default'])(deprecation.message) }),
                      _this4.renderSelectorIssueURLIfNeeded(packageName, issueTitle, issueBody)
                    )
                  )
                );
              })
            )
          );
        });
      }
    }
  }, {
    key: 'renderPackageActionsIfNeeded',
    value: function renderPackageActionsIfNeeded(packageName) {
      var _this5 = this;

      if (packageName && atom.packages.getLoadedPackage(packageName)) {
        return _etch2['default'].dom(
          'div',
          { className: 'padded' },
          _etch2['default'].dom(
            'div',
            { className: 'btn-group' },
            _etch2['default'].dom(
              'button',
              {
                className: 'btn check-for-update',
                onclick: function (event) {
                  event.preventDefault();
                  _this5.checkForUpdates();
                } },
              'Check for Update'
            ),
            _etch2['default'].dom(
              'button',
              {
                className: 'btn disable-package',
                'data-package-name': packageName,
                onclick: function (event) {
                  event.preventDefault();
                  _this5.disablePackage(packageName);
                } },
              'Disable Package'
            )
          )
        );
      } else {
        return '';
      }
    }
  }, {
    key: 'encodeURI',
    value: (function (_encodeURI) {
      function encodeURI(_x) {
        return _encodeURI.apply(this, arguments);
      }

      encodeURI.toString = function () {
        return _encodeURI.toString();
      };

      return encodeURI;
    })(function (str) {
      return encodeURI(str).replace(/#/g, '%23').replace(/;/g, '%3B').replace(/%20/g, '+');
    })
  }, {
    key: 'renderSelectorIssueURLIfNeeded',
    value: function renderSelectorIssueURLIfNeeded(packageName, issueTitle, issueBody) {
      var _this6 = this;

      var repoURL = this.getRepoURL(packageName);
      if (repoURL) {
        var _ret = (function () {
          var issueURL = repoURL + '/issues/new?title=' + _this6.encodeURI(issueTitle) + '&body=' + _this6.encodeURI(issueBody);
          return {
            v: _etch2['default'].dom(
              'div',
              { className: 'btn-toolbar' },
              _etch2['default'].dom(
                'button',
                {
                  className: 'btn issue-url',
                  'data-issue-title': issueTitle,
                  'data-repo-url': repoURL,
                  'data-issue-url': issueURL,
                  onclick: function (event) {
                    event.preventDefault();
                    _this6.openIssueURL(repoURL, issueURL, issueTitle);
                  } },
                'Report Issue'
              )
            )
          };
        })();

        if (typeof _ret === 'object') return _ret.v;
      } else {
        return '';
      }
    }
  }, {
    key: 'renderIssueURLIfNeeded',
    value: function renderIssueURLIfNeeded(packageName, deprecation, issueURL) {
      var _this7 = this;

      if (packageName && issueURL) {
        var _ret2 = (function () {
          var repoURL = _this7.getRepoURL(packageName);
          var issueTitle = deprecation.getOriginName() + ' is deprecated.';
          return {
            v: _etch2['default'].dom(
              'div',
              { className: 'btn-toolbar' },
              _etch2['default'].dom(
                'button',
                {
                  className: 'btn issue-url',
                  'data-issue-title': issueTitle,
                  'data-repo-url': repoURL,
                  'data-issue-url': issueURL,
                  onclick: function (event) {
                    event.preventDefault();
                    _this7.openIssueURL(repoURL, issueURL, issueTitle);
                  } },
                'Report Issue'
              )
            )
          };
        })();

        if (typeof _ret2 === 'object') return _ret2.v;
      } else {
        return '';
      }
    }
  }, {
    key: 'buildIssueURL',
    value: function buildIssueURL(packageName, deprecation, stack) {
      var repoURL = this.getRepoURL(packageName);
      if (repoURL) {
        var title = deprecation.getOriginName() + ' is deprecated.';
        var stacktrace = stack.map(function (_ref5) {
          var functionName = _ref5.functionName;
          var location = _ref5.location;
          return functionName + ' (' + location + ')';
        }).join("\n");
        var body = deprecation.getMessage() + '\n```\n' + stacktrace + '\n```';
        return repoURL + '/issues/new?title=' + encodeURI(title) + '&body=' + encodeURI(body);
      } else {
        return null;
      }
    }
  }, {
    key: 'openIssueURL',
    value: _asyncToGenerator(function* (repoURL, issueURL, issueTitle) {
      var issue = yield this.findSimilarIssue(repoURL, issueTitle);
      if (issue) {
        _shell2['default'].openExternal(issue.html_url);
      } else if (process.platform === 'win32') {
        // Windows will not launch URLs greater than ~2000 bytes so we need to shrink it
        _shell2['default'].openExternal((yield this.shortenURL(issueURL)) || issueURL);
      } else {
        _shell2['default'].openExternal(issueURL);
      }
    })
  }, {
    key: 'findSimilarIssue',
    value: _asyncToGenerator(function* (repoURL, issueTitle) {
      var url = 'https://api.github.com/search/issues';
      var repo = repoURL.replace(/http(s)?:\/\/(\d+\.)?github.com\//gi, '');
      var query = issueTitle + ' repo:' + repo;
      var response = yield window.fetch(url + '?q=' + encodeURI(query) + '&sort=created', {
        method: 'GET',
        headers: {
          'Accept': 'application/vnd.github.v3+json',
          'Content-Type': 'application/json'
        }
      });

      if (response.ok) {
        var data = yield response.json();
        if (data.items) {
          var issues = {};
          for (var issue of data.items) {
            if (issue.title.includes(issueTitle) && !issues[issue.state]) {
              issues[issue.state] = issue;
            }
          }

          return issues.open || issues.closed;
        }
      }
    })
  }, {
    key: 'shortenURL',
    value: _asyncToGenerator(function* (url) {
      var encodedUrl = encodeURIComponent(url).substr(0, 5000); // is.gd has 5000 char limit
      var incompletePercentEncoding = encodedUrl.indexOf('%', encodedUrl.length - 2);
      if (incompletePercentEncoding >= 0) {
        // Handle an incomplete % encoding cut-off
        encodedUrl = encodedUrl.substr(0, incompletePercentEncoding);
      }

      var result = yield fetch('https://is.gd/create.php?format=simple', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: 'url=' + encodedUrl
      });

      return result.text();
    })
  }, {
    key: 'getRepoURL',
    value: function getRepoURL(packageName) {
      var loadedPackage = atom.packages.getLoadedPackage(packageName);
      if (loadedPackage && loadedPackage.metadata && loadedPackage.metadata.repository) {
        var url = loadedPackage.metadata.repository.url || loadedPackage.metadata.repository;
        return url.replace(/\.git$/, '');
      } else {
        return null;
      }
    }
  }, {
    key: 'getDeprecatedCallsByPackageName',
    value: function getDeprecatedCallsByPackageName() {
      var deprecatedCalls = _grim2['default'].getDeprecations();
      deprecatedCalls.sort(function (a, b) {
        return b.getCallCount() - a.getCallCount();
      });
      var deprecatedCallsByPackageName = {};
      for (var deprecation of deprecatedCalls) {
        var stacks = deprecation.getStacks();
        stacks.sort(function (a, b) {
          return b.callCount - a.callCount;
        });
        for (var stack of stacks) {
          var packageName = null;
          if (stack.metadata && stack.metadata.packageName) {
            packageName = stack.metadata.packageName;
          } else {
            packageName = (this.getPackageName(stack) || '').toLowerCase();
          }

          deprecatedCallsByPackageName[packageName] = deprecatedCallsByPackageName[packageName] || [];
          deprecatedCallsByPackageName[packageName].push({ deprecation: deprecation, stack: stack });
        }
      }
      return deprecatedCallsByPackageName;
    }
  }, {
    key: 'getDeprecatedSelectorsByPackageName',
    value: function getDeprecatedSelectorsByPackageName() {
      var deprecatedSelectorsByPackageName = {};
      if (atom.styles.getDeprecations) {
        var deprecatedSelectorsBySourcePath = atom.styles.getDeprecations();
        for (var sourcePath of Object.keys(deprecatedSelectorsBySourcePath)) {
          var deprecation = deprecatedSelectorsBySourcePath[sourcePath];
          var components = sourcePath.split(_path2['default'].sep);
          var packagesComponentIndex = components.indexOf('packages');
          var packageName = null;
          var packagePath = null;
          if (packagesComponentIndex === -1) {
            packageName = 'Other'; // could be Atom Core or the personal style sheet
            packagePath = '';
          } else {
            packageName = components[packagesComponentIndex + 1];
            packagePath = components.slice(0, packagesComponentIndex + 1).join(_path2['default'].sep);
          }

          deprecatedSelectorsByPackageName[packageName] = deprecatedSelectorsByPackageName[packageName] || [];
          deprecatedSelectorsByPackageName[packageName].push({ packagePath: packagePath, sourcePath: sourcePath, deprecation: deprecation });
        }
      }

      return deprecatedSelectorsByPackageName;
    }
  }, {
    key: 'getPackageName',
    value: function getPackageName(stack) {
      var packagePaths = this.getPackagePathsByPackageName();
      for (var _ref63 of packagePaths) {
        var _ref62 = _slicedToArray(_ref63, 2);

        var packageName = _ref62[0];
        var packagePath = _ref62[1];

        if (packagePath.includes('.atom/dev/packages') || packagePath.includes('.atom/packages')) {
          packagePaths.set(packageName, _fsPlus2['default'].absolute(packagePath));
        }
      }

      for (var i = 1; i < stack.length; i++) {
        var fileName = stack[i].fileName;

        // Empty when it was run from the dev console
        if (!fileName) {
          return null;
        }

        // Continue to next stack entry if call is in node_modules
        if (fileName.includes(_path2['default'].sep + 'node_modules' + _path2['default'].sep)) {
          continue;
        }

        for (var _ref73 of packagePaths) {
          var _ref72 = _slicedToArray(_ref73, 2);

          var packageName = _ref72[0];
          var packagePath = _ref72[1];

          var relativePath = _path2['default'].relative(packagePath, fileName);
          if (!/^\.\./.test(relativePath)) {
            return packageName;
          }
        }

        if (atom.getUserInitScriptPath() === fileName) {
          return 'Your local ' + _path2['default'].basename(fileName) + ' file';
        }
      }

      return null;
    }
  }, {
    key: 'getPackagePathsByPackageName',
    value: function getPackagePathsByPackageName() {
      if (this.packagePathsByPackageName) {
        return this.packagePathsByPackageName;
      } else {
        this.packagePathsByPackageName = new Map();
        for (var pack of atom.packages.getLoadedPackages()) {
          this.packagePathsByPackageName.set(pack.name, pack.path);
        }
        return this.packagePathsByPackageName;
      }
    }
  }, {
    key: 'checkForUpdates',
    value: function checkForUpdates() {
      atom.workspace.open('atom://config/updates');
    }
  }, {
    key: 'disablePackage',
    value: function disablePackage(packageName) {
      if (packageName) {
        atom.packages.disablePackage(packageName);
      }
    }
  }, {
    key: 'openLocation',
    value: function openLocation(location) {
      var pathToOpen = location.replace('file://', '');
      if (process.platform === 'win32') {
        pathToOpen = pathToOpen.replace(/^\//, '');
      }
      atom.open({ pathsToOpen: [pathToOpen] });
    }
  }, {
    key: 'getURI',
    value: function getURI() {
      return this.uri;
    }
  }, {
    key: 'getTitle',
    value: function getTitle() {
      return 'Deprecation Cop';
    }
  }, {
    key: 'getIconName',
    value: function getIconName() {
      return 'alert';
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return DeprecationCopView;
})();

exports['default'] = DeprecationCopView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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