Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var _underscorePlus = require('underscore-plus');

var _fuzzaldrin = require('fuzzaldrin');

var _fuzzaldrin2 = _interopRequireDefault(_fuzzaldrin);

var _fuzzaldrinPlus = require('fuzzaldrin-plus');

var _fuzzaldrinPlus2 = _interopRequireDefault(_fuzzaldrinPlus);

var CommandPaletteView = (function () {
  function CommandPaletteView() {
    var _this = this;

    _classCallCheck(this, CommandPaletteView);

    this.keyBindingsForActiveElement = [];
    this.commandsForActiveElement = [];
    this.selectListView = new _atomSelectList2['default']({
      items: this.commandsForActiveElement,
      emptyMessage: 'No matches found',
      filterKeyForItem: function filterKeyForItem(item) {
        return item.displayName;
      },
      elementForItem: function elementForItem(_ref) {
        var name = _ref.name;
        var displayName = _ref.displayName;

        var li = document.createElement('li');
        li.classList.add('event');
        li.dataset.eventName = name;

        var div = document.createElement('div');
        div.classList.add('pull-right');
        for (var keyBinding of _this.keyBindingsForActiveElement) {
          if (keyBinding.command === name) {
            var kbd = document.createElement('kbd');
            kbd.classList.add('key-binding');
            kbd.textContent = (0, _underscorePlus.humanizeKeystroke)(keyBinding.keystrokes);
            div.appendChild(kbd);
          }
        }
        li.appendChild(div);

        var span = document.createElement('span');
        span.title = name;

        var query = _this.selectListView.getQuery();
        var matches = _this.useAlternateScoring ? _fuzzaldrinPlus2['default'].match(displayName, query) : _fuzzaldrin2['default'].match(displayName, query);
        var matchedChars = [];
        var lastIndex = 0;
        for (var matchIndex of matches) {
          var _unmatched = displayName.substring(lastIndex, matchIndex);
          if (_unmatched) {
            if (matchedChars.length > 0) {
              var matchSpan = document.createElement('span');
              matchSpan.classList.add('character-match');
              matchSpan.textContent = matchedChars.join('');
              span.appendChild(matchSpan);
              matchedChars = [];
            }

            span.appendChild(document.createTextNode(_unmatched));
          }

          matchedChars.push(displayName[matchIndex]);
          lastIndex = matchIndex + 1;
        }

        if (matchedChars.length > 0) {
          var matchSpan = document.createElement('span');
          matchSpan.classList.add('character-match');
          matchSpan.textContent = matchedChars.join('');
          span.appendChild(matchSpan);
        }

        var unmatched = displayName.substring(lastIndex);
        if (unmatched) {
          span.appendChild(document.createTextNode(unmatched));
        }

        li.appendChild(span);
        return li;
      },
      didConfirmSelection: function didConfirmSelection(keyBinding) {
        _this.hide();
        var event = new CustomEvent(keyBinding.name, { bubbles: true, cancelable: true });
        _this.activeElement.dispatchEvent(event);
      },
      didCancelSelection: function didCancelSelection() {
        _this.hide();
      }
    });
    this.selectListView.element.classList.add('command-palette');
  }

  _createClass(CommandPaletteView, [{
    key: 'destroy',
    value: _asyncToGenerator(function* () {
      yield this.selectListView.destroy();
    })
  }, {
    key: 'toggle',
    value: function toggle() {
      if (this.panel && this.panel.isVisible()) {
        this.hide();
        return Promise.resolve();
      } else {
        return this.show();
      }
    }
  }, {
    key: 'show',
    value: _asyncToGenerator(function* () {
      if (!this.panel) {
        this.panel = atom.workspace.addModalPanel({ item: this.selectListView });
      }

      if (!this.preserveLastSearch) {
        this.selectListView.reset();
      } else {
        this.selectListView.refs.queryEditor.selectAll();
      }

      this.activeElement = document.activeElement === document.body ? atom.views.getView(atom.workspace) : document.activeElement;
      this.keyBindingsForActiveElement = atom.keymaps.findKeyBindings({ target: this.activeElement });
      this.commandsForActiveElement = atom.commands.findCommands({ target: this.activeElement });
      this.commandsForActiveElement.sort(function (a, b) {
        return a.displayName.localeCompare(b.displayName);
      });
      yield this.selectListView.update({ items: this.commandsForActiveElement });

      this.previouslyFocusedElement = document.activeElement;
      this.panel.show();
      this.selectListView.focus();
    })
  }, {
    key: 'hide',
    value: function hide() {
      this.panel.hide();
      if (this.previouslyFocusedElement) {
        this.previouslyFocusedElement.focus();
        this.previouslyFocusedElement = null;
      }
    }
  }, {
    key: 'update',
    value: _asyncToGenerator(function* (props) {
      if (props.hasOwnProperty('preserveLastSearch')) {
        this.preserveLastSearch = props.preserveLastSearch;
      }

      if (props.hasOwnProperty('useAlternateScoring')) {
        this.useAlternateScoring = props.useAlternateScoring;
        if (this.useAlternateScoring) {
          yield this.selectListView.update({
            filter: function filter(items, query) {
              return query ? _fuzzaldrinPlus2['default'].filter(items, query, { key: 'displayName' }) : items;
            }
          });
        } else {
          yield this.selectListView.update({ filter: null });
        }
      }
    })
  }]);

  return CommandPaletteView;
})();

exports['default'] = CommandPaletteView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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