(function() {
  var CompositeDisposable, MatchManager, _,
    bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  _ = require('underscore-plus');

  CompositeDisposable = require('atom').CompositeDisposable;

  module.exports = MatchManager = (function() {
    MatchManager.prototype.appendPair = function(pairList, arg) {
      var itemLeft, itemRight, newPair;
      itemLeft = arg[0], itemRight = arg[1];
      newPair = {};
      newPair[itemLeft] = itemRight;
      return pairList = _.extend(pairList, newPair);
    };

    MatchManager.prototype.processAutoPairs = function(autocompletePairs, pairedList, dataFun) {
      var autocompletePair, i, len, pairArray, results;
      if (autocompletePairs.length) {
        results = [];
        for (i = 0, len = autocompletePairs.length; i < len; i++) {
          autocompletePair = autocompletePairs[i];
          pairArray = autocompletePair.split('');
          results.push(this.appendPair(pairedList, dataFun(pairArray)));
        }
        return results;
      }
    };

    MatchManager.prototype.updateConfig = function() {
      var endPair, ref, results, startPair;
      this.pairedCharacters = {};
      this.pairedCharactersInverse = {};
      this.pairRegexes = {};
      this.pairsWithExtraNewline = {};
      this.processAutoPairs(this.getScopedSetting('bracket-matcher.autocompleteCharacters'), this.pairedCharacters, (function(x) {
        return [x[0], x[1]];
      }));
      this.processAutoPairs(this.getScopedSetting('bracket-matcher.autocompleteCharacters'), this.pairedCharactersInverse, (function(x) {
        return [x[1], x[0]];
      }));
      this.processAutoPairs(this.getScopedSetting('bracket-matcher.pairsWithExtraNewline'), this.pairsWithExtraNewline, (function(x) {
        return [x[0], x[1]];
      }));
      ref = this.pairedCharacters;
      results = [];
      for (startPair in ref) {
        endPair = ref[startPair];
        results.push(this.pairRegexes[startPair] = new RegExp("[" + (_.escapeRegExp(startPair + endPair)) + "]", 'g'));
      }
      return results;
    };

    MatchManager.prototype.getScopedSetting = function(key) {
      return atom.config.get(key, {
        scope: this.editor.getRootScopeDescriptor()
      });
    };

    function MatchManager(editor, editorElement) {
      this.editor = editor;
      this.destroy = bind(this.destroy, this);
      this.subscriptions = new CompositeDisposable;
      this.updateConfig();
      this.subscriptions.add(atom.config.observe('bracket-matcher.autocompleteCharacters', {
        scope: this.editor.getRootScopeDescriptor()
      }, (function(_this) {
        return function(newConfig) {
          return _this.updateConfig();
        };
      })(this)));
      this.subscriptions.add(atom.config.observe('bracket-matcher.pairsWithExtraNewline', {
        scope: this.editor.getRootScopeDescriptor()
      }, (function(_this) {
        return function(newConfig) {
          return _this.updateConfig();
        };
      })(this)));
      this.subscriptions.add(this.editor.onDidDestroy(this.destroy));
    }

    MatchManager.prototype.destroy = function() {
      return this.subscriptions.dispose();
    };

    return MatchManager;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
