(function() {
  var BracketMatcher, BracketMatcherView, MatchManager;

  MatchManager = require('./match-manager');

  BracketMatcherView = require('./bracket-matcher-view');

  BracketMatcher = require('./bracket-matcher');

  module.exports = {
    activate: function() {
      return atom.workspace.observeTextEditors(function(editor) {
        var editorElement, matchManager;
        editorElement = atom.views.getView(editor);
        matchManager = new MatchManager(editor, editorElement);
        new BracketMatcherView(editor, editorElement, matchManager);
        return new BracketMatcher(editor, editorElement, matchManager);
      });
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiL2hvbWUvdHJhdmlzL2J1aWxkL2F0b20vYXRvbS9vdXQvYXBwL25vZGVfbW9kdWxlcy9icmFja2V0LW1hdGNoZXIvbGliL21haW4uY29mZmVlIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0FBQUEsTUFBQTs7RUFBQSxZQUFBLEdBQWUsT0FBQSxDQUFRLGlCQUFSOztFQUNmLGtCQUFBLEdBQXFCLE9BQUEsQ0FBUSx3QkFBUjs7RUFDckIsY0FBQSxHQUFpQixPQUFBLENBQVEsbUJBQVI7O0VBRWpCLE1BQU0sQ0FBQyxPQUFQLEdBQ0U7SUFBQSxRQUFBLEVBQVUsU0FBQTthQUNSLElBQUksQ0FBQyxTQUFTLENBQUMsa0JBQWYsQ0FBa0MsU0FBQyxNQUFEO0FBQ2hDLFlBQUE7UUFBQSxhQUFBLEdBQWdCLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBWCxDQUFtQixNQUFuQjtRQUNoQixZQUFBLEdBQW1CLElBQUEsWUFBQSxDQUFhLE1BQWIsRUFBcUIsYUFBckI7UUFDZixJQUFBLGtCQUFBLENBQW1CLE1BQW5CLEVBQTJCLGFBQTNCLEVBQTBDLFlBQTFDO2VBQ0EsSUFBQSxjQUFBLENBQWUsTUFBZixFQUF1QixhQUF2QixFQUFzQyxZQUF0QztNQUo0QixDQUFsQztJQURRLENBQVY7O0FBTEYiLCJzb3VyY2VzQ29udGVudCI6WyJNYXRjaE1hbmFnZXIgPSByZXF1aXJlICcuL21hdGNoLW1hbmFnZXInXG5CcmFja2V0TWF0Y2hlclZpZXcgPSByZXF1aXJlICcuL2JyYWNrZXQtbWF0Y2hlci12aWV3J1xuQnJhY2tldE1hdGNoZXIgPSByZXF1aXJlICcuL2JyYWNrZXQtbWF0Y2hlcidcblxubW9kdWxlLmV4cG9ydHMgPVxuICBhY3RpdmF0ZTogLT5cbiAgICBhdG9tLndvcmtzcGFjZS5vYnNlcnZlVGV4dEVkaXRvcnMgKGVkaXRvcikgLT5cbiAgICAgIGVkaXRvckVsZW1lbnQgPSBhdG9tLnZpZXdzLmdldFZpZXcoZWRpdG9yKVxuICAgICAgbWF0Y2hNYW5hZ2VyID0gbmV3IE1hdGNoTWFuYWdlcihlZGl0b3IsIGVkaXRvckVsZW1lbnQpXG4gICAgICBuZXcgQnJhY2tldE1hdGNoZXJWaWV3KGVkaXRvciwgZWRpdG9yRWxlbWVudCwgbWF0Y2hNYW5hZ2VyKVxuICAgICAgbmV3IEJyYWNrZXRNYXRjaGVyKGVkaXRvciwgZWRpdG9yRWxlbWVudCwgbWF0Y2hNYW5hZ2VyKVxuIl19
