(function() {
  var Bookmarks, BookmarksView, CompositeDisposable, ReactBookmarks, disposables, editorsBookmarks;

  CompositeDisposable = require('atom').CompositeDisposable;

  Bookmarks = null;

  ReactBookmarks = null;

  BookmarksView = require('./bookmarks-view');

  editorsBookmarks = null;

  disposables = null;

  module.exports = {
    activate: function(bookmarksByEditorId) {
      var bookmarksView;
      editorsBookmarks = [];
      bookmarksView = null;
      disposables = new CompositeDisposable;
      atom.commands.add('atom-workspace', 'bookmarks:view-all', function() {
        if (bookmarksView == null) {
          bookmarksView = new BookmarksView(editorsBookmarks);
        }
        return bookmarksView.show();
      });
      return atom.workspace.observeTextEditors(function(textEditor) {
        var bookmarks, state;
        if (Bookmarks == null) {
          Bookmarks = require('./bookmarks');
        }
        if (state = bookmarksByEditorId[textEditor.id]) {
          bookmarks = Bookmarks.deserialize(textEditor, state);
        } else {
          bookmarks = new Bookmarks(textEditor);
        }
        editorsBookmarks.push(bookmarks);
        return disposables.add(textEditor.onDidDestroy(function() {
          var index;
          index = editorsBookmarks.indexOf(bookmarks);
          if (index !== -1) {
            editorsBookmarks.splice(index, 1);
          }
          return bookmarks.destroy();
        }));
      });
    },
    deactivate: function() {
      var bookmarks, i, len;
      if (typeof bookmarksView !== "undefined" && bookmarksView !== null) {
        bookmarksView.destroy();
      }
      for (i = 0, len = editorsBookmarks.length; i < len; i++) {
        bookmarks = editorsBookmarks[i];
        bookmarks.deactivate();
      }
      return disposables.dispose();
    },
    serialize: function() {
      var bookmarks, bookmarksByEditorId, i, len;
      bookmarksByEditorId = {};
      for (i = 0, len = editorsBookmarks.length; i < len; i++) {
        bookmarks = editorsBookmarks[i];
        bookmarksByEditorId[bookmarks.editor.id] = bookmarks.serialize();
      }
      return bookmarksByEditorId;
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
