Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var BookmarksView = (function () {
  function BookmarksView(editorsBookmarks) {
    var _this = this;

    _classCallCheck(this, BookmarksView);

    this.editorsBookmarks = editorsBookmarks;
    this.selectList = new _atomSelectList2['default']({
      emptyMessage: 'No bookmarks found',
      items: [],
      filterKeyForItem: function filterKeyForItem(bookmark) {
        return bookmark.filterText;
      },
      didConfirmSelection: function didConfirmSelection(_ref) {
        var editor = _ref.editor;
        var marker = _ref.marker;

        _this.hide();
        editor.setSelectedBufferRange(marker.getBufferRange(), { autoscroll: true });
        atom.workspace.paneForItem(editor).activate();
        atom.workspace.paneForItem(editor).activateItem(editor);
      },
      didCancelSelection: function didCancelSelection() {
        _this.hide();
      },
      elementForItem: function elementForItem(_ref2) {
        var marker = _ref2.marker;
        var editor = _ref2.editor;

        var bookmarkStartRow = marker.getStartBufferPosition().row;
        var bookmarkEndRow = marker.getEndBufferPosition().row;
        var bookmarkPath = editor.getPath() ? _path2['default'].basename(editor.getPath()) : 'untitled';
        var bookmarkLocation = bookmarkPath + ':' + (bookmarkStartRow + 1);
        if (bookmarkStartRow !== bookmarkEndRow) {
          bookmarkLocation += '-' + (bookmarkEndRow + 1);
        }

        var lineText = editor.lineTextForBufferRow(bookmarkStartRow);
        var li = document.createElement('li');
        li.classList.add('bookmark');
        var primaryLine = document.createElement('div');
        primaryLine.classList.add('primary-line');
        primaryLine.textContent = bookmarkLocation;
        li.appendChild(primaryLine);
        if (lineText) {
          var secondaryLine = document.createElement('div');
          secondaryLine.classList.add('secondary-line', 'line-text');
          secondaryLine.textContent = lineText.trim();
          li.appendChild(secondaryLine);
          li.classList.add('two-lines');
        }
        return li;
      }
    });
    this.selectList.element.classList.add('bookmarks-view');
  }

  _createClass(BookmarksView, [{
    key: 'destroy',
    value: function destroy() {
      this.selectList.destroy();
      this.getModalPanel().destroy();
      if (this.previouslyFocusedElement) {
        this.previouslyFocusedElement.focus();
        this.previouslyFocusedElement = null;
      }
    }
  }, {
    key: 'show',
    value: _asyncToGenerator(function* () {
      var bookmarks = [];
      for (var _ref32 of this.editorsBookmarks) {
        var editor = _ref32.editor;
        var markerLayer = _ref32.markerLayer;

        for (var marker of markerLayer.getMarkers()) {
          var filterText = '' + marker.getStartBufferPosition().row;

          if (editor.getPath()) {
            filterText += ' ' + editor.getPath();
          }

          var bookmarkedLineText = editor.lineTextForBufferRow(marker.getStartBufferPosition().row);
          if (bookmarkedLineText) {
            filterText += ' ' + bookmarkedLineText.trim();
          }

          bookmarks.push({ marker: marker, editor: editor, filterText: filterText });
        }
      }

      this.previouslyFocusedElement = document.activeElement;
      this.selectList.reset();
      yield this.selectList.update({ items: bookmarks });
      this.getModalPanel().show();
      this.selectList.focus();
    })
  }, {
    key: 'hide',
    value: function hide() {
      this.getModalPanel().hide();
      if (this.previouslyFocusedElement) {
        this.previouslyFocusedElement.focus();
        this.previouslyFocusedElement = null;
      }
    }
  }, {
    key: 'getModalPanel',
    value: function getModalPanel() {
      if (!this.modalPanel) {
        this.modalPanel = atom.workspace.addModalPanel({ item: this.selectList });
      }
      return this.modalPanel;
    }
  }]);

  return BookmarksView;
})();

exports['default'] = BookmarksView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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