(function() {
  var BackgroundTipsElement, CompositeDisposable, Template, Tips, _;

  _ = require('underscore-plus');

  CompositeDisposable = require('event-kit').CompositeDisposable;

  Tips = require('./tips');

  Template = "<ul class=\"centered background-message\">\n  <li class=\"message\"></li>\n</ul>";

  module.exports = BackgroundTipsElement = (function() {
    BackgroundTipsElement.prototype.StartDelay = 1000;

    BackgroundTipsElement.prototype.DisplayDuration = 10000;

    BackgroundTipsElement.prototype.FadeDuration = 300;

    function BackgroundTipsElement() {
      var base, ref;
      this.element = document.createElement('background-tips');
      this.index = -1;
      this.disposables = new CompositeDisposable;
      this.workspaceCenter = (ref = typeof (base = atom.workspace).getCenter === "function" ? base.getCenter() : void 0) != null ? ref : atom.workspace;
      this.disposables.add(this.workspaceCenter.onDidAddPane((function(_this) {
        return function() {
          return _this.updateVisibility();
        };
      })(this)));
      this.disposables.add(this.workspaceCenter.onDidDestroyPane((function(_this) {
        return function() {
          return _this.updateVisibility();
        };
      })(this)));
      this.disposables.add(this.workspaceCenter.onDidChangeActivePaneItem((function(_this) {
        return function() {
          return _this.updateVisibility();
        };
      })(this)));
      this.startTimeout = setTimeout(((function(_this) {
        return function() {
          return _this.start();
        };
      })(this)), this.StartDelay);
    }

    BackgroundTipsElement.prototype.destroy = function() {
      this.stop();
      this.disposables.dispose();
      return this.destroyed = true;
    };

    BackgroundTipsElement.prototype.attach = function() {
      var paneView, ref, ref1, top;
      this.element.innerHTML = Template;
      this.message = this.element.querySelector('.message');
      paneView = atom.views.getView(this.workspaceCenter.getActivePane());
      top = (ref = (ref1 = paneView.querySelector('.item-views')) != null ? ref1.offsetTop : void 0) != null ? ref : 0;
      this.element.style.top = top + 'px';
      return paneView.appendChild(this.element);
    };

    BackgroundTipsElement.prototype.detach = function() {
      return this.element.remove();
    };

    BackgroundTipsElement.prototype.updateVisibility = function() {
      if (this.shouldBeAttached()) {
        return this.start();
      } else {
        return this.stop();
      }
    };

    BackgroundTipsElement.prototype.shouldBeAttached = function() {
      return this.workspaceCenter.getPanes().length === 1 && (this.workspaceCenter.getActivePaneItem() == null);
    };

    BackgroundTipsElement.prototype.start = function() {
      if (!this.shouldBeAttached() || (this.interval != null)) {
        return;
      }
      this.renderTips();
      this.randomizeIndex();
      this.attach();
      this.showNextTip();
      return this.interval = setInterval(((function(_this) {
        return function() {
          return _this.showNextTip();
        };
      })(this)), this.DisplayDuration);
    };

    BackgroundTipsElement.prototype.stop = function() {
      this.element.remove();
      if (this.interval != null) {
        clearInterval(this.interval);
      }
      clearTimeout(this.startTimeout);
      clearTimeout(this.nextTipTimeout);
      return this.interval = null;
    };

    BackgroundTipsElement.prototype.randomizeIndex = function() {
      var len;
      len = Tips.length;
      return this.index = Math.round(Math.random() * len) % len;
    };

    BackgroundTipsElement.prototype.showNextTip = function() {
      this.index = ++this.index % Tips.length;
      this.message.classList.remove('fade-in');
      return this.nextTipTimeout = setTimeout((function(_this) {
        return function() {
          _this.message.innerHTML = Tips[_this.index];
          return _this.message.classList.add('fade-in');
        };
      })(this), this.FadeDuration);
    };

    BackgroundTipsElement.prototype.renderTips = function() {
      var i, j, len1, tip;
      if (this.tipsRendered) {
        return;
      }
      for (i = j = 0, len1 = Tips.length; j < len1; i = ++j) {
        tip = Tips[i];
        Tips[i] = this.renderTip(tip);
      }
      return this.tipsRendered = true;
    };

    BackgroundTipsElement.prototype.renderTip = function(str) {
      str = str.replace(/\{(.+)\}/g, (function(_this) {
        return function(match, command) {
          var binding, bindings, j, keystrokeLabel, len1, scope, scopeAndCommand;
          scopeAndCommand = command.split('>');
          if (scopeAndCommand.length > 1) {
            scope = scopeAndCommand[0], command = scopeAndCommand[1];
          }
          bindings = atom.keymaps.findKeyBindings({
            command: command.trim()
          });
          if (scope) {
            for (j = 0, len1 = bindings.length; j < len1; j++) {
              binding = bindings[j];
              if (binding.selector === scope) {
                break;
              }
            }
          } else {
            binding = _this.getKeyBindingForCurrentPlatform(bindings);
          }
          if (binding != null ? binding.keystrokes : void 0) {
            keystrokeLabel = _.humanizeKeystroke(binding.keystrokes).replace(/\s+/g, '&nbsp;');
            return "<span class=\"keystroke\">" + keystrokeLabel + "</span>";
          } else {
            return command;
          }
        };
      })(this));
      return str;
    };

    BackgroundTipsElement.prototype.getKeyBindingForCurrentPlatform = function(bindings) {
      var binding, j, len1;
      if (!(bindings != null ? bindings.length : void 0)) {
        return;
      }
      for (j = 0, len1 = bindings.length; j < len1; j++) {
        binding = bindings[j];
        if (binding.selector.indexOf(process.platform) !== -1) {
          return binding;
        }
      }
      return bindings[0];
    };

    return BackgroundTipsElement;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
