(function() {
  var AttributesURL, TagsURL, attributesPromise, fetchGlobalAttributeDescriptions, fetchTagDescriptions, fs, globalAttributeDescriptionsPromise, path, request, tagDescriptionsPromise, tagsPromise;

  path = require('path');

  fs = require('fs');

  request = require('request');

  fetchTagDescriptions = require('./fetch-tag-docs');

  fetchGlobalAttributeDescriptions = require('./fetch-global-attribute-docs');

  TagsURL = 'https://raw.githubusercontent.com/adobe/brackets/master/src/extensions/default/HTMLCodeHints/HtmlTags.json';

  AttributesURL = 'https://raw.githubusercontent.com/adobe/brackets/master/src/extensions/default/HTMLCodeHints/HtmlAttributes.json';

  tagsPromise = new Promise(function(resolve) {
    return request({
      json: true,
      url: TagsURL
    }, function(error, response, tags) {
      var options, ref, tag;
      if (error != null) {
        console.error(error.message);
        resolve(null);
      }
      if (response.statusCode !== 200) {
        console.error("Request for HtmlTags.json failed: " + response.statusCode);
        resolve(null);
      }
      for (tag in tags) {
        options = tags[tag];
        if (((ref = options.attributes) != null ? ref.length : void 0) === 0) {
          delete options.attributes;
        }
      }
      return resolve(tags);
    });
  });

  tagDescriptionsPromise = fetchTagDescriptions();

  attributesPromise = new Promise(function(resolve) {
    return request({
      json: true,
      url: AttributesURL
    }, function(error, response, attributes) {
      var attribute, options, ref;
      if (error != null) {
        console.error(error.message);
        resolve(null);
      }
      if (response.statusCode !== 200) {
        console.error("Request for HtmlAttributes.json failed: " + response.statusCode);
        resolve(null);
      }
      for (attribute in attributes) {
        options = attributes[attribute];
        if (((ref = options.attribOption) != null ? ref.length : void 0) === 0) {
          delete options.attribOption;
        }
      }
      return resolve(attributes);
    });
  });

  globalAttributeDescriptionsPromise = fetchGlobalAttributeDescriptions();

  Promise.all([tagsPromise, tagDescriptionsPromise, attributesPromise, globalAttributeDescriptionsPromise]).then(function(values) {
    var attribute, attributeDescriptions, attributes, completions, options, tag, tagDescriptions, tags;
    tags = values[0];
    tagDescriptions = values[1];
    attributes = values[2];
    attributeDescriptions = values[3];
    for (tag in tags) {
      tags[tag].description = tagDescriptions[tag];
    }
    for (attribute in attributes) {
      options = attributes[attribute];
      if (options.global) {
        attributes[attribute].description = attributeDescriptions[attribute];
      }
    }
    completions = {
      tags: tags,
      attributes: attributes
    };
    return fs.writeFileSync(path.join(__dirname, 'completions.json'), (JSON.stringify(completions, null, '  ')) + "\n");
  });

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
