(function() {
  var AttributesURL, fetch, filterExcerpt, fs, mdnHTMLURL, mdnJSONAPI, path, request;

  path = require('path');

  fs = require('fs');

  request = require('request');

  mdnHTMLURL = 'https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes';

  mdnJSONAPI = 'https://developer.mozilla.org/en-US/search.json?topic=html&highlight=false';

  AttributesURL = 'https://raw.githubusercontent.com/adobe/brackets/master/src/extensions/default/HTMLCodeHints/HtmlAttributes.json';

  fetch = function() {
    var attributesPromise;
    attributesPromise = new Promise(function(resolve) {
      return request({
        json: true,
        url: AttributesURL
      }, function(error, response, attributes) {
        if (error != null) {
          console.error(error.message);
          resolve(null);
        }
        if (response.statusCode !== 200) {
          console.error("Request for HtmlAttributes.json failed: " + response.statusCode);
          resolve(null);
        }
        return resolve(attributes);
      });
    });
    return attributesPromise.then(function(attributes) {
      var MAX, attribute, docs, options, queue, running;
      if (attributes == null) {
        return;
      }
      MAX = 10;
      queue = [];
      for (attribute in attributes) {
        options = attributes[attribute];
        if (options.global && !attribute.startsWith('aria') && !attribute.startsWith('on') && attribute !== 'role') {
          queue.push(attribute);
        }
      }
      running = [];
      docs = {};
      return new Promise(function(resolve) {
        var checkEnd, handleRequest, i, ref, removeRunning, run, runNext;
        checkEnd = function() {
          if (queue.length === 0 && running.length === 0) {
            return resolve(docs);
          }
        };
        removeRunning = function(attributeName) {
          var index;
          index = running.indexOf(attributeName);
          if (index > -1) {
            return running.splice(index, 1);
          }
        };
        runNext = function() {
          var attributeName;
          checkEnd();
          if (queue.length !== 0) {
            attributeName = queue.pop();
            running.push(attributeName);
            return run(attributeName);
          }
        };
        run = function(attributeName) {
          var url;
          url = mdnJSONAPI + "&q=" + attributeName;
          return request({
            json: true,
            url: url
          }, function(error, response, searchResults) {
            if ((error == null) && response.statusCode === 200) {
              handleRequest(attributeName, searchResults);
            } else {
              console.error("Req failed " + url + "; " + response.statusCode + ", " + error);
            }
            removeRunning(attributeName);
            return runNext();
          });
        };
        handleRequest = function(attributeName, searchResults) {
          var doc, i, len, ref;
          if (searchResults.documents != null) {
            ref = searchResults.documents;
            for (i = 0, len = ref.length; i < len; i++) {
              doc = ref[i];
              if (doc.url === (mdnHTMLURL + "/" + attributeName)) {
                docs[attributeName] = filterExcerpt(attributeName, doc.excerpt);
                return;
              }
            }
          }
          return console.log("Could not find documentation for " + attributeName);
        };
        for (i = 0, ref = MAX; 0 <= ref ? i <= ref : i >= ref; 0 <= ref ? i++ : i--) {
          runNext();
        }
      });
    });
  };

  filterExcerpt = function(attributeName, excerpt) {
    var beginningPattern, periodIndex;
    beginningPattern = /^the [a-z-]+ global attribute (is )?(\w+)/i;
    excerpt = excerpt.replace(beginningPattern, function(match) {
      var firstWord, matches;
      matches = beginningPattern.exec(match);
      firstWord = matches[2];
      return firstWord[0].toUpperCase() + firstWord.slice(1);
    });
    periodIndex = excerpt.indexOf('.');
    if (periodIndex > -1) {
      excerpt = excerpt.slice(0, periodIndex + 1);
    }
    return excerpt;
  };

  if (require.main === module) {
    fetch().then(function(docs) {
      if (docs != null) {
        return fs.writeFileSync(path.join(__dirname, 'global-attribute-docs.json'), (JSON.stringify(docs, null, '  ')) + "\n");
      } else {
        return console.error('No docs');
      }
    });
  }

  module.exports = fetch;

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
