(function() {
  var PropertiesURL, fetch, filterExcerpt, fs, mdnCSSURL, mdnJSONAPI, path, request;

  path = require('path');

  fs = require('fs');

  request = require('request');

  mdnCSSURL = 'https://developer.mozilla.org/en-US/docs/Web/CSS';

  mdnJSONAPI = 'https://developer.mozilla.org/en-US/search.json?topic=css&highlight=false';

  PropertiesURL = 'https://raw.githubusercontent.com/adobe/brackets/master/src/extensions/default/CSSCodeHints/CSSProperties.json';

  fetch = function() {
    var propertiesPromise;
    propertiesPromise = new Promise(function(resolve) {
      return request({
        json: true,
        url: PropertiesURL
      }, function(error, response, properties) {
        if (error != null) {
          console.error(error.message);
          resolve(null);
        }
        if (response.statusCode !== 200) {
          console.error("Request for CSSProperties.json failed: " + response.statusCode);
          resolve(null);
        }
        return resolve(properties);
      });
    });
    return propertiesPromise.then(function(properties) {
      var MAX, docs, queue, running;
      if (properties == null) {
        return;
      }
      MAX = 10;
      queue = Object.keys(properties);
      running = [];
      docs = {};
      return new Promise(function(resolve) {
        var checkEnd, handleRequest, i, ref, removeRunning, run, runNext;
        checkEnd = function() {
          if (queue.length === 0 && running.length === 0) {
            return resolve(docs);
          }
        };
        removeRunning = function(propertyName) {
          var index;
          index = running.indexOf(propertyName);
          if (index > -1) {
            return running.splice(index, 1);
          }
        };
        runNext = function() {
          var propertyName;
          checkEnd();
          if (queue.length !== 0) {
            propertyName = queue.pop();
            running.push(propertyName);
            return run(propertyName);
          }
        };
        run = function(propertyName) {
          var url;
          url = mdnJSONAPI + "&q=" + propertyName;
          return request({
            json: true,
            url: url
          }, function(error, response, searchResults) {
            if ((error == null) && response.statusCode === 200) {
              handleRequest(propertyName, searchResults);
            } else {
              console.error("Req failed " + url + "; " + response.statusCode + ", " + error);
            }
            removeRunning(propertyName);
            checkEnd();
            return runNext();
          });
        };
        handleRequest = function(propertyName, searchResults) {
          var doc, i, len, ref;
          if (searchResults.documents != null) {
            ref = searchResults.documents;
            for (i = 0, len = ref.length; i < len; i++) {
              doc = ref[i];
              if (doc.url === (mdnCSSURL + "/" + propertyName)) {
                docs[propertyName] = filterExcerpt(propertyName, doc.excerpt);
                break;
              }
            }
          }
        };
        for (i = 0, ref = MAX; 0 <= ref ? i <= ref : i >= ref; 0 <= ref ? i++ : i--) {
          runNext();
        }
      });
    });
  };

  filterExcerpt = function(propertyName, excerpt) {
    var beginningPattern, periodIndex;
    beginningPattern = /^the (css )?[a-z-]+ (css )?property (is )?(\w+)/i;
    excerpt = excerpt.replace(beginningPattern, function(match) {
      var firstWord, matches;
      matches = beginningPattern.exec(match);
      firstWord = matches[4];
      return firstWord[0].toUpperCase() + firstWord.slice(1);
    });
    periodIndex = excerpt.indexOf('.');
    if (periodIndex > -1) {
      excerpt = excerpt.slice(0, periodIndex + 1);
    }
    return excerpt;
  };

  if (require.main === module) {
    fetch().then(function(docs) {
      if (docs != null) {
        return fs.writeFileSync(path.join(__dirname, 'property-docs.json'), (JSON.stringify(docs, null, '  ')) + "\n");
      } else {
        return console.error('No docs');
      }
    });
  }

  module.exports = fetch;

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
