Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i]; return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atom = require('atom');

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _temp = require('temp');

var _temp2 = _interopRequireDefault(_temp);

var _lsArchive = require('ls-archive');

var _lsArchive2 = _interopRequireDefault(_lsArchive);

var _fileIcons = require('./file-icons');

var _fileIcons2 = _interopRequireDefault(_fileIcons);

var FileView = (function () {
  function FileView(parentView, indexInParentView, archivePath, entry) {
    var _name$classList,
        _this = this;

    _classCallCheck(this, FileView);

    this.disposables = new _atom.CompositeDisposable();
    this.parentView = parentView;
    this.indexInParentView = indexInParentView;
    this.archivePath = archivePath;
    this.entry = entry;
    var typeClass = _fileIcons2['default'].getService().iconClassForPath(this.entry.path, 'archive-view') || [];
    if (!Array.isArray(typeClass)) {
      if (typeClass) {
        typeClass = typeClass.toString().split(/\s+/g);
      }
    }

    this.element = document.createElement('li');
    this.element.classList.add('list-item', 'entry');
    this.element.tabIndex = -1;

    this.name = document.createElement('span');
    (_name$classList = this.name.classList).add.apply(_name$classList, ['file', 'icon'].concat(_toConsumableArray(typeClass)));
    this.name.textContent = this.entry.getName();
    this.element.appendChild(this.name);

    var clickHandler = function clickHandler() {
      _this.select();
      _this.openFile();
    };
    this.element.addEventListener('click', clickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.element.removeEventListener('click', clickHandler);
    }));

    this.disposables.add(atom.commands.add(this.element, {
      'core:confirm': function coreConfirm() {
        if (_this.isSelected()) {
          _this.openFile();
        }
      },

      'core:move-down': function coreMoveDown() {
        if (_this.isSelected()) {
          _this.parentView.selectFileAfterIndex(_this.indexInParentView);
        }
      },

      'core:move-up': function coreMoveUp() {
        if (_this.isSelected()) {
          _this.parentView.selectFileBeforeIndex(_this.indexInParentView);
        }
      }
    }));
  }

  _createClass(FileView, [{
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      this.element.remove();
    }
  }, {
    key: 'isSelected',
    value: function isSelected() {
      return this.element.classList.contains('selected');
    }
  }, {
    key: 'logError',
    value: function logError(message, error) {
      console.error(message, error.stack != null ? error.stack : error);
    }
  }, {
    key: 'openFile',
    value: function openFile() {
      var _this2 = this;

      _lsArchive2['default'].readFile(this.archivePath, this.entry.getPath(), function (error, contents) {
        if (error != null) {
          _this2.logError('Error reading: ' + _this2.entry.getPath() + ' from ' + _this2.archivePath, error);
        } else {
          _temp2['default'].mkdir('atom-', function (error, tempDirPath) {
            if (error != null) {
              _this2.logError('Error creating temp directory: ' + tempDirPath, error);
            } else {
              (function () {
                var tempFilePath = _path2['default'].join(tempDirPath, _path2['default'].basename(_this2.archivePath), _this2.entry.getName());
                _fsPlus2['default'].writeFile(tempFilePath, contents, function (error) {
                  if (error != null) {
                    return _this2.logError('Error writing to ' + tempFilePath, error);
                  } else {
                    return atom.workspace.open(tempFilePath);
                  }
                });
              })();
            }
          });
        }
      });
    }
  }, {
    key: 'select',
    value: function select() {
      for (var selected of this.element.closest('.archive-editor').querySelectorAll('.selected')) {
        selected.classList.remove('selected');
      }
      this.element.classList.add('selected');
      this.element.focus();
    }
  }]);

  return FileView;
})();

exports['default'] = FileView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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