Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _fileView = require('./file-view');

var _fileView2 = _interopRequireDefault(_fileView);

var DirectoryView = (function () {
  function DirectoryView(parentView, indexInParentView, archivePath, entry) {
    _classCallCheck(this, DirectoryView);

    this.entries = [];
    this.parentView = parentView;
    this.indexInParentView = indexInParentView;
    this.element = document.createElement('li');
    this.element.classList.add('list-nested-item', 'entry');

    var listItem = document.createElement('span');
    listItem.classList.add('list-item');

    var entrySpan = document.createElement('span');
    entrySpan.classList.add('directory', 'icon', 'icon-file-directory');
    entrySpan.textContent = entry.getName();
    listItem.appendChild(entrySpan);
    this.element.appendChild(listItem);

    this.entriesTree = document.createElement('ol');
    this.entriesTree.classList.add('list-tree');
    var index = 0;
    for (var child of entry.children) {
      if (child.isDirectory()) {
        var entryView = new DirectoryView(this, index, archivePath, child);
        this.entries.push(entryView);
        this.entriesTree.appendChild(entryView.element);
      } else {
        var entryView = new _fileView2['default'](this, index, archivePath, child);
        this.entries.push(entryView);
        this.entriesTree.appendChild(entryView.element);
      }

      index++;
    }
    this.element.appendChild(this.entriesTree);
  }

  _createClass(DirectoryView, [{
    key: 'destroy',
    value: function destroy() {
      while (this.entries.length > 0) {
        this.entries.pop().destroy();
      }

      this.element.remove();
    }
  }, {
    key: 'selectFileBeforeIndex',
    value: function selectFileBeforeIndex(index) {
      for (var i = index - 1; i >= 0; i--) {
        var previousEntry = this.entries[i];
        if (previousEntry instanceof _fileView2['default']) {
          previousEntry.select();
          return;
        } else {
          if (previousEntry.selectLastFile()) {
            return;
          }
        }
      }

      this.parentView.selectFileBeforeIndex(this.indexInParentView);
    }
  }, {
    key: 'selectFileAfterIndex',
    value: function selectFileAfterIndex(index) {
      for (var i = index + 1; i < this.entries.length; i++) {
        var nextEntry = this.entries[i];
        if (nextEntry instanceof _fileView2['default']) {
          nextEntry.select();
          return;
        } else {
          if (nextEntry.selectFirstFile()) {
            return;
          }
        }
      }

      this.parentView.selectFileAfterIndex(this.indexInParentView);
    }
  }, {
    key: 'selectFirstFile',
    value: function selectFirstFile() {
      for (var entry of this.entries) {
        if (entry instanceof _fileView2['default']) {
          entry.select();
          return true;
        } else {
          if (entry.selectFirstFile()) {
            return true;
          }
        }
      }

      return false;
    }
  }, {
    key: 'selectLastFile',
    value: function selectLastFile() {
      for (var i = this.entries.length - 1; i >= 0; i--) {
        var entry = this.entries[i];
        if (entry instanceof _fileView2['default']) {
          entry.select();
          return true;
        } else {
          if (entry.selectLastFile()) {
            return true;
          }
        }
      }

      return false;
    }
  }]);

  return DirectoryView;
})();

exports['default'] = DirectoryView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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