Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _humanizePlus = require('humanize-plus');

var _humanizePlus2 = _interopRequireDefault(_humanizePlus);

var _lsArchive = require('ls-archive');

var _lsArchive2 = _interopRequireDefault(_lsArchive);

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _fileView = require('./file-view');

var _fileView2 = _interopRequireDefault(_fileView);

var _directoryView = require('./directory-view');

var _directoryView2 = _interopRequireDefault(_directoryView);

var ArchiveEditorView = (function () {
  function ArchiveEditorView(editor) {
    var _this = this;

    _classCallCheck(this, ArchiveEditorView);

    this.disposables = new _atom.CompositeDisposable();
    this.entries = [];
    _etch2['default'].initialize(this);
    this.setModel(editor);

    var focusHandler = function focusHandler() {
      _this.focusSelectedFile();
    };
    this.element.addEventListener('focus', focusHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.element.removeEventListener('focus', focusHandler);
    }));
  }

  _createClass(ArchiveEditorView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {
      while (this.entries.length > 0) {
        this.entries.pop().destroy();
      }
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'archive-editor', tabIndex: '-1' },
        _etch2['default'].dom(
          'div',
          { className: 'archive-container' },
          _etch2['default'].dom(
            'div',
            { ref: 'loadingMessage', className: 'padded icon icon-hourglass text-info' },
            'Loading archive…'
          ),
          _etch2['default'].dom('div', { ref: 'errorMessage', className: 'padded icon icon-alert text-error' }),
          _etch2['default'].dom(
            'div',
            { className: 'inset-panel' },
            _etch2['default'].dom('div', { ref: 'summary', className: 'panel-heading' }),
            _etch2['default'].dom('ol', { ref: 'tree', className: 'archive-tree padded list-tree has-collapsable-children' })
          )
        )
      );
    }
  }, {
    key: 'setPath',
    value: function setPath(path) {
      if (path && this.path !== path) {
        this.path = path;
        this.refresh();
      }
    }
  }, {
    key: 'refresh',
    value: function refresh() {
      var _this2 = this;

      this.refs.summary.style.display = 'none';
      this.refs.tree.style.display = 'none';
      this.refs.loadingMessage.style.display = '';
      this.refs.errorMessage.style.display = 'none';

      var originalPath = this.path;
      _lsArchive2['default'].list(this.path, { tree: true }, function (error, entries) {
        if (originalPath !== _this2.path) {
          return;
        }

        _this2.refs.loadingMessage.style.display = 'none';
        if (error != null) {
          var message = 'Reading the archive file failed';
          if (error.message) {
            message += ': ' + error.message;
          }
          _this2.refs.errorMessage.style.display = '';
          _this2.refs.errorMessage.textContent = message;
        } else {
          _this2.createTreeEntries(entries);
          _this2.updateSummary();
        }
      });
    }
  }, {
    key: 'createTreeEntries',
    value: function createTreeEntries(entries) {
      while (this.entries.length > 0) {
        this.entries.pop().destroy();
      }

      var index = 0;
      for (var entry of entries) {
        if (entry.isDirectory()) {
          var entryView = new _directoryView2['default'](this, index, this.path, entry);
          this.entries.push(entryView);
          this.refs.tree.appendChild(entryView.element);
        } else {
          var entryView = new _fileView2['default'](this, index, this.path, entry);
          this.entries.push(entryView);
          this.refs.tree.appendChild(entryView.element);
        }
        index++;
      }

      this.refs.tree.style.display = '';
      this.selectFileAfterIndex(-1);
    }
  }, {
    key: 'updateSummary',
    value: function updateSummary() {
      var fileCount = this.entries.filter(function (entry) {
        return entry instanceof _fileView2['default'];
      }).length;
      var fileLabel = fileCount === 1 ? '1 file' : _humanizePlus2['default'].intComma(fileCount) + ' files';

      var directoryCount = this.entries.filter(function (entry) {
        return entry instanceof _directoryView2['default'];
      }).length;
      var directoryLabel = directoryCount === 1 ? '1 folder' : _humanizePlus2['default'].intComma(directoryCount) + ' folders';

      this.refs.summary.style.display = '';
      this.refs.summary.textContent = _humanizePlus2['default'].fileSize(_fsPlus2['default'].getSizeSync(this.path)) + ' with ' + fileLabel + ' and ' + directoryLabel;
    }
  }, {
    key: 'focusSelectedFile',
    value: function focusSelectedFile() {
      var selectedFile = this.refs.tree.querySelector('.selected');
      if (selectedFile) {
        selectedFile.focus();
      }
    }
  }, {
    key: 'selectFileBeforeIndex',
    value: function selectFileBeforeIndex(index) {
      for (var i = index - 1; i >= 0; i--) {
        var previousEntry = this.entries[i];
        if (previousEntry instanceof _fileView2['default']) {
          previousEntry.select();
          break;
        } else {
          if (previousEntry.selectLastFile()) {
            break;
          }
        }
      }
    }
  }, {
    key: 'selectFileAfterIndex',
    value: function selectFileAfterIndex(index) {
      for (var i = index + 1; i < this.entries.length; i++) {
        var nextEntry = this.entries[i];
        if (nextEntry instanceof _fileView2['default']) {
          nextEntry.select();
          break;
        } else {
          if (nextEntry.selectFirstFile()) {
            break;
          }
        }
      }
    }
  }, {
    key: 'focus',
    value: function focus() {
      this.focusSelectedFile();
    }
  }, {
    key: 'setModel',
    value: function setModel(editor) {
      var _this3 = this;

      if (!editor) {
        return;
      }

      this.editor = editor;
      this.setPath(this.editor.getPath());
      this.disposables.add(this.editor.file.onDidChange(function () {
        _this3.refresh();
      }));
      this.disposables.add(this.editor.file.onDidDelete(function () {
        var pane = atom.workspace.paneForItem(_this3.editor);
        if (pane) {
          pane.destroyItem(_this3.editor);
        }
      }));
    }
  }]);

  return ArchiveEditorView;
})();

exports['default'] = ArchiveEditorView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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