(function() {
  var CompositeDisposable, FileIcons, FileView;

  CompositeDisposable = require('event-kit').CompositeDisposable;

  FileIcons = require('./file-icons');

  module.exports = FileView = (function() {
    function FileView(file) {
      var iconClass, ref;
      this.file = file;
      this.subscriptions = new CompositeDisposable();
      this.subscriptions.add(this.file.onDidDestroy((function(_this) {
        return function() {
          return _this.subscriptions.dispose();
        };
      })(this)));
      this.element = document.createElement('li');
      this.element.setAttribute('is', 'tree-view-file');
      this.element.draggable = true;
      this.element.classList.add('file', 'entry', 'list-item');
      this.fileName = document.createElement('span');
      this.fileName.classList.add('name', 'icon');
      this.element.appendChild(this.fileName);
      this.fileName.textContent = this.file.name;
      this.fileName.title = this.file.name;
      this.fileName.dataset.name = this.file.name;
      this.fileName.dataset.path = this.file.path;
      iconClass = FileIcons.getService().iconClassForPath(this.file.path, "tree-view");
      if (iconClass) {
        if (!Array.isArray(iconClass)) {
          iconClass = iconClass.toString().split(/\s+/g);
        }
        (ref = this.fileName.classList).add.apply(ref, iconClass);
      }
      this.subscriptions.add(this.file.onDidStatusChange((function(_this) {
        return function() {
          return _this.updateStatus();
        };
      })(this)));
      this.updateStatus();
      this.element.getPath = this.getPath.bind(this);
      this.element.isPathEqual = this.isPathEqual.bind(this);
      this.element.file = this.file;
      this.element.fileName = this.fileName;
      this.element.updateStatus = this.updateStatus.bind(this);
    }

    FileView.prototype.updateStatus = function() {
      this.element.classList.remove('status-ignored', 'status-modified', 'status-added');
      if (this.file.status != null) {
        return this.element.classList.add("status-" + this.file.status);
      }
    };

    FileView.prototype.getPath = function() {
      return this.fileName.dataset.path;
    };

    FileView.prototype.isPathEqual = function(pathToCompare) {
      return this.file.isPathEqual(pathToCompare);
    };

    return FileView;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
