Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var WindowPanelView = (function () {
  function WindowPanelView() {
    _classCallCheck(this, WindowPanelView);

    _etch2['default'].initialize(this);

    this.disposables = new _atom.CompositeDisposable();
    this.disposables.add(atom.tooltips.add(this.refs.windowTiming, { title: 'The time taken to load this window' }));
    this.disposables.add(atom.tooltips.add(this.refs.shellTiming, { title: 'The time taken to launch the app' }));
    this.disposables.add(atom.tooltips.add(this.refs.workspaceTiming, { title: 'The time taken to rebuild the previously opened editors' }));
    this.disposables.add(atom.tooltips.add(this.refs.projectTiming, { title: 'The time taken to rebuild the previously opened buffers' }));
    this.disposables.add(atom.tooltips.add(this.refs.atomTiming, { title: 'The time taken to read and parse the stored window state' }));
  }

  _createClass(WindowPanelView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'tool-panel padded package-panel' },
        _etch2['default'].dom(
          'div',
          { className: 'inset-panel' },
          _etch2['default'].dom(
            'div',
            { className: 'panel-heading' },
            'Startup Time'
          ),
          _etch2['default'].dom(
            'div',
            { className: 'panel-body padded' },
            _etch2['default'].dom(
              'div',
              { className: 'timing', ref: 'windowTiming' },
              _etch2['default'].dom(
                'span',
                { className: 'inline-block' },
                'Window load time'
              ),
              _etch2['default'].dom('span', { className: 'inline-block', ref: 'windowLoadTime' })
            ),
            _etch2['default'].dom(
              'div',
              { className: 'timing', ref: 'shellTiming' },
              _etch2['default'].dom(
                'span',
                { className: 'inline-block' },
                'Shell load time'
              ),
              _etch2['default'].dom('span', { className: 'inline-block', ref: 'shellLoadTime' })
            ),
            _etch2['default'].dom(
              'div',
              { ref: 'deserializeTimings' },
              _etch2['default'].dom(
                'div',
                { className: 'timing', ref: 'workspaceTiming' },
                _etch2['default'].dom(
                  'span',
                  { className: 'inline-block' },
                  'Workspace load time'
                ),
                _etch2['default'].dom('span', { className: 'inline-block', ref: 'workspaceLoadTime' })
              ),
              _etch2['default'].dom(
                'div',
                { className: 'timing', ref: 'projectTiming' },
                _etch2['default'].dom(
                  'span',
                  { className: 'inline-block' },
                  'Project load time'
                ),
                _etch2['default'].dom('span', { className: 'inline-block', ref: 'projectLoadTime' })
              ),
              _etch2['default'].dom(
                'div',
                { className: 'timing', ref: 'atomTiming' },
                _etch2['default'].dom(
                  'span',
                  { className: 'inline-block' },
                  'Window state load time'
                ),
                _etch2['default'].dom('span', { className: 'inline-block', ref: 'atomLoadTime' })
              )
            )
          )
        )
      );
    }
  }, {
    key: 'populate',
    value: function populate() {
      var time = atom.getWindowLoadTime();
      this.refs.windowLoadTime.classList.add(this.getHighlightClass(time));
      this.refs.windowLoadTime.textContent = time + 'ms';

      var _atom$getLoadSettings = atom.getLoadSettings();

      var shellLoadTime = _atom$getLoadSettings.shellLoadTime;

      if (shellLoadTime != null) {
        this.refs.shellLoadTime.classList.add(this.getHighlightClass(shellLoadTime));
        this.refs.shellLoadTime.textContent = shellLoadTime + 'ms';
      } else {
        this.refs.shellTiming.style.display = 'none';
      }

      if (atom.deserializeTimings != null) {
        this.refs.workspaceLoadTime.classList.add(this.getHighlightClass(atom.deserializeTimings.workspace));
        this.refs.workspaceLoadTime.textContent = atom.deserializeTimings.workspace + 'ms';
        this.refs.projectLoadTime.classList.add(this.getHighlightClass(atom.deserializeTimings.project));
        this.refs.projectLoadTime.textContent = atom.deserializeTimings.project + 'ms';
        this.refs.atomLoadTime.classList.add(this.getHighlightClass(atom.deserializeTimings.atom));
        this.refs.atomLoadTime.textContent = atom.deserializeTimings.atom + 'ms';
      } else {
        this.refs.deserializeTimings.style.display = 'none';
      }
    }
  }, {
    key: 'getHighlightClass',
    value: function getHighlightClass(time) {
      if (time > 1000) {
        return 'highlight-error';
      } else if (time > 800) {
        return 'highlight-warning';
      } else {
        return 'highlight-info';
      }
    }
  }]);

  return WindowPanelView;
})();

exports['default'] = WindowPanelView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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