Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var PackagePanelView = (function () {
  function PackagePanelView(_ref) {
    var _this = this;

    var title = _ref.title;

    _classCallCheck(this, PackagePanelView);

    this.title = title;
    _etch2['default'].initialize(this);

    var clickHandler = function clickHandler(event) {
      var target = event.target.closest('a.package');
      if (target) {
        atom.workspace.open('atom://config/packages/' + target.dataset['package']);
      }
    };
    this.element.addEventListener('click', clickHandler);
    this.disposable = new _atom.Disposable(function () {
      _this.element.removeEventListener('click', clickHandler);
    });
  }

  _createClass(PackagePanelView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposable.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'tool-panel padded package-panel' },
        _etch2['default'].dom(
          'div',
          { className: 'inset-panel' },
          _etch2['default'].dom(
            'div',
            { className: 'panel-heading' },
            this.title
          ),
          _etch2['default'].dom(
            'div',
            { className: 'panel-body padded' },
            _etch2['default'].dom('div', { className: 'text-info', ref: 'summary' }),
            _etch2['default'].dom('ul', { className: 'list-group', ref: 'list' })
          )
        )
      );
    }
  }, {
    key: 'addPackages',
    value: function addPackages(packages, timeKey) {
      for (var pack of packages) {
        this.addPackage(pack, timeKey);
      }
    }
  }, {
    key: 'addPackage',
    value: function addPackage(pack, timeKey) {
      var li = document.createElement('div');
      li.classList.add('list-item');

      var a = document.createElement('a');
      a.classList.add('inline-block', 'package');
      a.dataset['package'] = pack.name;
      a.textContent = pack.name;
      li.appendChild(a);

      var line = document.createElement('span');
      line.classList.add('timecop-line');
      li.appendChild(line);

      var timeSpan = document.createElement('span');
      timeSpan.classList.add('inline-block', pack[timeKey] > 25 ? 'highlight-error' : 'highlight-warning');
      timeSpan.textContent = pack[timeKey] + 'ms';
      li.appendChild(timeSpan);

      this.refs.list.appendChild(li);
    }
  }]);

  return PackagePanelView;
})();

exports['default'] = PackagePanelView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9ob21lL2FuZHJlaS9hdG9tLTEuMTkuMi9vdXQvYXBwL25vZGVfbW9kdWxlcy90aW1lY29wL2xpYi9wYWNrYWdlLXBhbmVsLXZpZXcuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7OztvQkFHeUIsTUFBTTs7b0JBQ2QsTUFBTTs7OztJQUVGLGdCQUFnQjtBQUN2QixXQURPLGdCQUFnQixDQUN0QixJQUFPLEVBQUU7OztRQUFSLEtBQUssR0FBTixJQUFPLENBQU4sS0FBSzs7MEJBREEsZ0JBQWdCOztBQUVqQyxRQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQTtBQUNsQixzQkFBSyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUE7O0FBRXJCLFFBQU0sWUFBWSxHQUFHLFNBQWYsWUFBWSxDQUFJLEtBQUssRUFBSztBQUM5QixVQUFNLE1BQU0sR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUMsQ0FBQTtBQUNoRCxVQUFJLE1BQU0sRUFBRTtBQUNWLFlBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSw2QkFBMkIsTUFBTSxDQUFDLE9BQU8sV0FBUSxDQUFHLENBQUE7T0FDeEU7S0FDRixDQUFBO0FBQ0QsUUFBSSxDQUFDLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLEVBQUUsWUFBWSxDQUFDLENBQUE7QUFDcEQsUUFBSSxDQUFDLFVBQVUsR0FBRyxxQkFBZSxZQUFNO0FBQUUsWUFBSyxPQUFPLENBQUMsbUJBQW1CLENBQUMsT0FBTyxFQUFFLFlBQVksQ0FBQyxDQUFBO0tBQUUsQ0FBQyxDQUFBO0dBQ3BHOztlQWJrQixnQkFBZ0I7O1dBZTVCLGtCQUFHLEVBQUU7OztXQUVKLG1CQUFHO0FBQ1QsVUFBSSxDQUFDLFVBQVUsQ0FBQyxPQUFPLEVBQUUsQ0FBQTtBQUN6QixhQUFPLGtCQUFLLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQTtLQUMxQjs7O1dBRU0sa0JBQUc7QUFDUixhQUNFOztVQUFLLFNBQVMsRUFBQyxpQ0FBaUM7UUFDOUM7O1lBQUssU0FBUyxFQUFDLGFBQWE7VUFDMUI7O2NBQUssU0FBUyxFQUFDLGVBQWU7WUFBRSxJQUFJLENBQUMsS0FBSztXQUFPO1VBQ2pEOztjQUFLLFNBQVMsRUFBQyxtQkFBbUI7WUFDaEMsK0JBQUssU0FBUyxFQUFDLFdBQVcsRUFBQyxHQUFHLEVBQUMsU0FBUyxHQUFPO1lBQy9DLDhCQUFJLFNBQVMsRUFBQyxZQUFZLEVBQUMsR0FBRyxFQUFDLE1BQU0sR0FBTTtXQUN2QztTQUNGO09BQ0YsQ0FDUDtLQUNGOzs7V0FFVyxxQkFBQyxRQUFRLEVBQUUsT0FBTyxFQUFFO0FBQzlCLFdBQUssSUFBTSxJQUFJLElBQUksUUFBUSxFQUFFO0FBQzNCLFlBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxFQUFFLE9BQU8sQ0FBQyxDQUFBO09BQy9CO0tBQ0Y7OztXQUVVLG9CQUFDLElBQUksRUFBRSxPQUFPLEVBQUU7QUFDekIsVUFBTSxFQUFFLEdBQUcsUUFBUSxDQUFDLGFBQWEsQ0FBQyxLQUFLLENBQUMsQ0FBQTtBQUN4QyxRQUFFLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxXQUFXLENBQUMsQ0FBQTs7QUFFN0IsVUFBTSxDQUFDLEdBQUcsUUFBUSxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsQ0FBQTtBQUNyQyxPQUFDLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxjQUFjLEVBQUUsU0FBUyxDQUFDLENBQUE7QUFDMUMsT0FBQyxDQUFDLE9BQU8sV0FBUSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUE7QUFDN0IsT0FBQyxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFBO0FBQ3pCLFFBQUUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDLENBQUE7O0FBRWpCLFVBQU0sSUFBSSxHQUFHLFFBQVEsQ0FBQyxhQUFhLENBQUMsTUFBTSxDQUFDLENBQUE7QUFDM0MsVUFBSSxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUE7QUFDbEMsUUFBRSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsQ0FBQTs7QUFFcEIsVUFBTSxRQUFRLEdBQUcsUUFBUSxDQUFDLGFBQWEsQ0FBQyxNQUFNLENBQUMsQ0FBQTtBQUMvQyxjQUFRLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxjQUFjLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxHQUFHLEVBQUUsR0FBRyxpQkFBaUIsR0FBRyxtQkFBbUIsQ0FBQyxDQUFBO0FBQ3BHLGNBQVEsQ0FBQyxXQUFXLEdBQU0sSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFJLENBQUE7QUFDM0MsUUFBRSxDQUFDLFdBQVcsQ0FBQyxRQUFRLENBQUMsQ0FBQTs7QUFFeEIsVUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLEVBQUUsQ0FBQyxDQUFBO0tBQy9COzs7U0E5RGtCLGdCQUFnQjs7O3FCQUFoQixnQkFBZ0IiLCJmaWxlIjoiL2hvbWUvYW5kcmVpL2F0b20tMS4xOS4yL291dC9hcHAvbm9kZV9tb2R1bGVzL3RpbWVjb3AvbGliL3BhY2thZ2UtcGFuZWwtdmlldy5qcyIsInNvdXJjZXNDb250ZW50IjpbIi8qKiBAYmFiZWwgKi9cbi8qKiBAanN4IGV0Y2guZG9tICovXG5cbmltcG9ydCB7RGlzcG9zYWJsZX0gZnJvbSAnYXRvbSdcbmltcG9ydCBldGNoIGZyb20gJ2V0Y2gnXG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIFBhY2thZ2VQYW5lbFZpZXcge1xuICBjb25zdHJ1Y3RvciAoe3RpdGxlfSkge1xuICAgIHRoaXMudGl0bGUgPSB0aXRsZVxuICAgIGV0Y2guaW5pdGlhbGl6ZSh0aGlzKVxuXG4gICAgY29uc3QgY2xpY2tIYW5kbGVyID0gKGV2ZW50KSA9PiB7XG4gICAgICBjb25zdCB0YXJnZXQgPSBldmVudC50YXJnZXQuY2xvc2VzdCgnYS5wYWNrYWdlJylcbiAgICAgIGlmICh0YXJnZXQpIHtcbiAgICAgICAgYXRvbS53b3Jrc3BhY2Uub3BlbihgYXRvbTovL2NvbmZpZy9wYWNrYWdlcy8ke3RhcmdldC5kYXRhc2V0LnBhY2thZ2V9YClcbiAgICAgIH1cbiAgICB9XG4gICAgdGhpcy5lbGVtZW50LmFkZEV2ZW50TGlzdGVuZXIoJ2NsaWNrJywgY2xpY2tIYW5kbGVyKVxuICAgIHRoaXMuZGlzcG9zYWJsZSA9IG5ldyBEaXNwb3NhYmxlKCgpID0+IHsgdGhpcy5lbGVtZW50LnJlbW92ZUV2ZW50TGlzdGVuZXIoJ2NsaWNrJywgY2xpY2tIYW5kbGVyKSB9KVxuICB9XG5cbiAgdXBkYXRlICgpIHt9XG5cbiAgZGVzdHJveSAoKSB7XG4gICAgdGhpcy5kaXNwb3NhYmxlLmRpc3Bvc2UoKVxuICAgIHJldHVybiBldGNoLmRlc3Ryb3kodGhpcylcbiAgfVxuXG4gIHJlbmRlciAoKSB7XG4gICAgcmV0dXJuIChcbiAgICAgIDxkaXYgY2xhc3NOYW1lPSd0b29sLXBhbmVsIHBhZGRlZCBwYWNrYWdlLXBhbmVsJz5cbiAgICAgICAgPGRpdiBjbGFzc05hbWU9J2luc2V0LXBhbmVsJz5cbiAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0ncGFuZWwtaGVhZGluZyc+e3RoaXMudGl0bGV9PC9kaXY+XG4gICAgICAgICAgPGRpdiBjbGFzc05hbWU9J3BhbmVsLWJvZHkgcGFkZGVkJz5cbiAgICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPSd0ZXh0LWluZm8nIHJlZj0nc3VtbWFyeSc+PC9kaXY+XG4gICAgICAgICAgICA8dWwgY2xhc3NOYW1lPSdsaXN0LWdyb3VwJyByZWY9J2xpc3QnPjwvdWw+XG4gICAgICAgICAgPC9kaXY+XG4gICAgICAgIDwvZGl2PlxuICAgICAgPC9kaXY+XG4gICAgKVxuICB9XG5cbiAgYWRkUGFja2FnZXMgKHBhY2thZ2VzLCB0aW1lS2V5KSB7XG4gICAgZm9yIChjb25zdCBwYWNrIG9mIHBhY2thZ2VzKSB7XG4gICAgICB0aGlzLmFkZFBhY2thZ2UocGFjaywgdGltZUtleSlcbiAgICB9XG4gIH1cblxuICBhZGRQYWNrYWdlIChwYWNrLCB0aW1lS2V5KSB7XG4gICAgY29uc3QgbGkgPSBkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKVxuICAgIGxpLmNsYXNzTGlzdC5hZGQoJ2xpc3QtaXRlbScpXG5cbiAgICBjb25zdCBhID0gZG9jdW1lbnQuY3JlYXRlRWxlbWVudCgnYScpXG4gICAgYS5jbGFzc0xpc3QuYWRkKCdpbmxpbmUtYmxvY2snLCAncGFja2FnZScpXG4gICAgYS5kYXRhc2V0LnBhY2thZ2UgPSBwYWNrLm5hbWVcbiAgICBhLnRleHRDb250ZW50ID0gcGFjay5uYW1lXG4gICAgbGkuYXBwZW5kQ2hpbGQoYSlcblxuICAgIGNvbnN0IGxpbmUgPSBkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdzcGFuJylcbiAgICBsaW5lLmNsYXNzTGlzdC5hZGQoJ3RpbWVjb3AtbGluZScpXG4gICAgbGkuYXBwZW5kQ2hpbGQobGluZSlcblxuICAgIGNvbnN0IHRpbWVTcGFuID0gZG9jdW1lbnQuY3JlYXRlRWxlbWVudCgnc3BhbicpXG4gICAgdGltZVNwYW4uY2xhc3NMaXN0LmFkZCgnaW5saW5lLWJsb2NrJywgcGFja1t0aW1lS2V5XSA+IDI1ID8gJ2hpZ2hsaWdodC1lcnJvcicgOiAnaGlnaGxpZ2h0LXdhcm5pbmcnKVxuICAgIHRpbWVTcGFuLnRleHRDb250ZW50ID0gYCR7cGFja1t0aW1lS2V5XX1tc2BcbiAgICBsaS5hcHBlbmRDaGlsZCh0aW1lU3BhbilcblxuICAgIHRoaXMucmVmcy5saXN0LmFwcGVuZENoaWxkKGxpKVxuICB9XG59XG4iXX0=