Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var CachePanelView = (function () {
  function CachePanelView() {
    _classCallCheck(this, CachePanelView);

    _etch2['default'].initialize(this);
  }

  _createClass(CachePanelView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'tool-panel padded package-panel' },
        _etch2['default'].dom(
          'div',
          { className: 'inset-panel' },
          _etch2['default'].dom(
            'div',
            { className: 'panel-heading' },
            'Compile Cache'
          ),
          _etch2['default'].dom(
            'div',
            { className: 'panel-body padded' },
            _etch2['default'].dom(
              'div',
              { className: 'timing' },
              _etch2['default'].dom(
                'span',
                { className: 'inline-block' },
                'CoffeeScript files compiled'
              ),
              _etch2['default'].dom(
                'span',
                { className: 'inline-block highlight-info', ref: 'coffeeCompileCount' },
                '0'
              )
            ),
            _etch2['default'].dom(
              'div',
              { className: 'timing' },
              _etch2['default'].dom(
                'span',
                { className: 'inline-block' },
                'Babel files compiled'
              ),
              _etch2['default'].dom('span', { className: 'inline-block highlight-info', ref: 'babelCompileCount' })
            ),
            _etch2['default'].dom(
              'div',
              { className: 'timing' },
              _etch2['default'].dom(
                'span',
                { className: 'inline-block' },
                'Typescript files compiled'
              ),
              _etch2['default'].dom('span', { className: 'inline-block highlight-info', ref: 'typescriptCompileCount' })
            ),
            _etch2['default'].dom(
              'div',
              { className: 'timing' },
              _etch2['default'].dom(
                'span',
                { className: 'inline-block' },
                'CSON files compiled'
              ),
              _etch2['default'].dom('span', { className: 'inline-block highlight-info', ref: 'csonCompileCount' })
            ),
            _etch2['default'].dom(
              'div',
              { className: 'timing' },
              _etch2['default'].dom(
                'span',
                { className: 'inline-block' },
                'Less files compiled'
              ),
              _etch2['default'].dom('span', { className: 'inline-block highlight-info', ref: 'lessCompileCount' })
            )
          )
        )
      );
    }
  }, {
    key: 'populate',
    value: function populate() {
      var compileCacheStats = this.getCompileCacheStats();
      if (compileCacheStats) {
        this.refs.coffeeCompileCount.textContent = compileCacheStats['.coffee'].misses;
        this.refs.babelCompileCount.textContent = compileCacheStats['.js'].misses;
        this.refs.typescriptCompileCount.textContent = compileCacheStats['.ts'].misses;
      }

      this.refs.csonCompileCount.textContent = this.getCsonCompiles();
      this.refs.lessCompileCount.textContent = this.getLessCompiles();
    }
  }, {
    key: 'getCompileCacheStats',
    value: function getCompileCacheStats() {
      try {
        return require(_path2['default'].join(atom.getLoadSettings().resourcePath, 'src', 'compile-cache')).getCacheStats();
      } catch (error) {
        return null;
      }
    }
  }, {
    key: 'getCsonCompiles',
    value: function getCsonCompiles() {
      try {
        var CSON = require(_path2['default'].join(atom.getLoadSettings().resourcePath, 'node_modules', 'season'));
        if (CSON.getCacheMisses) {
          return CSON.getCacheMisses() || 0;
        } else {
          return 0;
        }
      } catch (error) {
        return 0;
      }
    }
  }, {
    key: 'getLessCompiles',
    value: function getLessCompiles() {
      var lessCache = atom.themes.lessCache;
      if (lessCache && lessCache.cache && lessCache.cache.stats && lessCache.cache.stats.misses) {
        return lessCache.cache.stats.misses || 0;
      } else {
        return 0;
      }
    }
  }]);

  return CachePanelView;
})();

exports['default'] = CachePanelView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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