(function() {
  var CompositeDisposable, StyleguideUri;

  CompositeDisposable = require('atom').CompositeDisposable;

  StyleguideUri = 'atom://styleguide';

  module.exports = {
    activate: function() {
      this.subscriptions = new CompositeDisposable;
      this.subscriptions.add(atom.workspace.addOpener((function(_this) {
        return function(filePath) {
          if (filePath === StyleguideUri) {
            return _this.createStyleguideView({
              uri: StyleguideUri
            });
          }
        };
      })(this)));
      return this.subscriptions.add(atom.commands.add('atom-workspace', 'styleguide:show', function() {
        return atom.workspace.open(StyleguideUri);
      }));
    },
    deactivate: function() {
      return this.subscriptions.dispose();
    },
    createStyleguideView: function(state) {
      var StyleguideView;
      StyleguideView = require('./styleguide-view');
      return new StyleguideView(state);
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiL2hvbWUvYW5kcmVpL2F0b20tMS4xOS4yL291dC9hcHAvbm9kZV9tb2R1bGVzL3N0eWxlZ3VpZGUvbGliL3N0eWxlZ3VpZGUuY29mZmVlIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0FBQUEsTUFBQTs7RUFBQyxzQkFBdUIsT0FBQSxDQUFRLE1BQVI7O0VBQ3hCLGFBQUEsR0FBZ0I7O0VBRWhCLE1BQU0sQ0FBQyxPQUFQLEdBQ0U7SUFBQSxRQUFBLEVBQVUsU0FBQTtNQUNSLElBQUMsQ0FBQSxhQUFELEdBQWlCLElBQUk7TUFDckIsSUFBQyxDQUFBLGFBQWEsQ0FBQyxHQUFmLENBQW1CLElBQUksQ0FBQyxTQUFTLENBQUMsU0FBZixDQUF5QixDQUFBLFNBQUEsS0FBQTtlQUFBLFNBQUMsUUFBRDtVQUMxQyxJQUE2QyxRQUFBLEtBQVksYUFBekQ7bUJBQUEsS0FBQyxDQUFBLG9CQUFELENBQXNCO2NBQUEsR0FBQSxFQUFLLGFBQUw7YUFBdEIsRUFBQTs7UUFEMEM7TUFBQSxDQUFBLENBQUEsQ0FBQSxJQUFBLENBQXpCLENBQW5CO2FBRUEsSUFBQyxDQUFBLGFBQWEsQ0FBQyxHQUFmLENBQW1CLElBQUksQ0FBQyxRQUFRLENBQUMsR0FBZCxDQUFrQixnQkFBbEIsRUFBb0MsaUJBQXBDLEVBQXVELFNBQUE7ZUFDeEUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFmLENBQW9CLGFBQXBCO01BRHdFLENBQXZELENBQW5CO0lBSlEsQ0FBVjtJQU9BLFVBQUEsRUFBWSxTQUFBO2FBQ1YsSUFBQyxDQUFBLGFBQWEsQ0FBQyxPQUFmLENBQUE7SUFEVSxDQVBaO0lBVUEsb0JBQUEsRUFBc0IsU0FBQyxLQUFEO0FBQ3BCLFVBQUE7TUFBQSxjQUFBLEdBQWlCLE9BQUEsQ0FBUSxtQkFBUjthQUNiLElBQUEsY0FBQSxDQUFlLEtBQWY7SUFGZ0IsQ0FWdEI7O0FBSkYiLCJzb3VyY2VzQ29udGVudCI6WyJ7Q29tcG9zaXRlRGlzcG9zYWJsZX0gPSByZXF1aXJlICdhdG9tJ1xuU3R5bGVndWlkZVVyaSA9ICdhdG9tOi8vc3R5bGVndWlkZSdcblxubW9kdWxlLmV4cG9ydHMgPVxuICBhY3RpdmF0ZTogLT5cbiAgICBAc3Vic2NyaXB0aW9ucyA9IG5ldyBDb21wb3NpdGVEaXNwb3NhYmxlXG4gICAgQHN1YnNjcmlwdGlvbnMuYWRkIGF0b20ud29ya3NwYWNlLmFkZE9wZW5lciAoZmlsZVBhdGgpID0+XG4gICAgICBAY3JlYXRlU3R5bGVndWlkZVZpZXcodXJpOiBTdHlsZWd1aWRlVXJpKSBpZiBmaWxlUGF0aCBpcyBTdHlsZWd1aWRlVXJpXG4gICAgQHN1YnNjcmlwdGlvbnMuYWRkIGF0b20uY29tbWFuZHMuYWRkICdhdG9tLXdvcmtzcGFjZScsICdzdHlsZWd1aWRlOnNob3cnLCAtPlxuICAgICAgYXRvbS53b3Jrc3BhY2Uub3BlbihTdHlsZWd1aWRlVXJpKVxuXG4gIGRlYWN0aXZhdGU6IC0+XG4gICAgQHN1YnNjcmlwdGlvbnMuZGlzcG9zZSgpXG5cbiAgY3JlYXRlU3R5bGVndWlkZVZpZXc6IChzdGF0ZSkgLT5cbiAgICBTdHlsZWd1aWRlVmlldyA9IHJlcXVpcmUgJy4vc3R5bGVndWlkZS12aWV3J1xuICAgIG5ldyBTdHlsZWd1aWRlVmlldyhzdGF0ZSlcbiJdfQ==
