(function() {
  var $, $$, $$$, ExampleSelectListView, Highlights, View, _, beautifyHtml, coffee, highlighter, ref;

  _ = require('underscore-plus');

  ref = require('atom-space-pen-views'), $ = ref.$, $$ = ref.$$, $$$ = ref.$$$, View = ref.View;

  coffee = require('coffee-script');

  beautifyHtml = require('js-beautify').html;

  Highlights = require('highlights');

  ExampleSelectListView = require('./example-select-list-view');

  highlighter = null;

  _.extend(View, {
    exampleHtml: function(html) {
      return this.div({
        "class": 'example'
      }, (function(_this) {
        return function() {
          _this.div({
            "class": 'example-rendered'
          }, function() {
            return _this.raw(html);
          });
          return _this.div({
            "class": 'example-code show-example-html'
          }, function() {
            return _this.colorizedCodeBlock('example-html', 'text.xml', beautifyHtml(html));
          });
        };
      })(this));
    },
    exampleOverlaySelectList: function() {
      var coffeeScript, selectList;
      selectList = new ExampleSelectListView(['one', 'two', 'three']);
      coffeeScript = "{SelectListView, $$} = require 'atom-space-pen-views'\n\nmodule.exports =\nclass ExampleSelectListView extends SelectListView\n  initialize: (@listOfItems) ->\n    super\n    @setItems(@listOfItems)\n\n  viewForItem: (item) ->\n    $$ -> @li(item)\n\n  cancel: ->\n    console.log(\"cancelled\")\n\n  confirmed: (item) ->\n    console.log(\"confirmed\", item)";
      return this.div({
        "class": 'example'
      }, (function(_this) {
        return function() {
          _this.div({
            "class": 'example-rendered'
          }, function() {
            return _this.tag('atom-panel', {
              "class": 'modal'
            }, function() {
              return _this.subview('__', selectList);
            });
          });
          return _this.div({
            "class": 'example-code show-example-space-pen'
          }, function() {
            return _this.colorizedCodeBlock('example-space-pen', 'source.coffee', coffeeScript);
          });
        };
      })(this));
    },
    colorizedCodeBlock: function(cssClass, grammarScopeName, code) {
      var fontFamily, highlightedBlock, highlightedHtml;
      if (highlighter == null) {
        highlighter = new Highlights({
          registry: atom.grammars
        });
      }
      highlightedHtml = highlighter.highlightSync({
        fileContents: code,
        scopeName: grammarScopeName
      });
      highlightedBlock = $(highlightedHtml);
      highlightedBlock.removeClass('editor');
      highlightedBlock.addClass(cssClass);
      if (fontFamily = atom.config.get('editor.fontFamily')) {
        highlightedBlock.css('font-family', fontFamily);
      }
      return this.subview('__', highlightedBlock);
    }
  });

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
