(function() {
  var SystemChecker, spellchecker;

  spellchecker = require('spellchecker');

  SystemChecker = (function() {
    SystemChecker.prototype.spellchecker = null;

    SystemChecker.prototype.locale = null;

    SystemChecker.prototype.enabled = true;

    SystemChecker.prototype.reason = null;

    SystemChecker.prototype.paths = null;

    function SystemChecker(locale, paths) {
      this.locale = locale;
      this.paths = paths;
    }

    SystemChecker.prototype.deactivate = function() {};

    SystemChecker.prototype.getId = function() {
      return "spell-check:" + this.locale.toLowerCase().replace("_", "-");
    };

    SystemChecker.prototype.getName = function() {
      return "System Dictionary (" + this.locale + ")";
    };

    SystemChecker.prototype.getPriority = function() {
      return 100;
    };

    SystemChecker.prototype.isEnabled = function() {
      return this.enabled;
    };

    SystemChecker.prototype.getStatus = function() {
      if (this.enabled) {
        return "Working correctly.";
      } else {
        return this.reason;
      }
    };

    SystemChecker.prototype.providesSpelling = function(args) {
      return true;
    };

    SystemChecker.prototype.providesSuggestions = function(args) {
      return true;
    };

    SystemChecker.prototype.providesAdding = function(args) {
      return false;
    };

    SystemChecker.prototype.check = function(args, text) {
      this.deferredInit();
      return {
        invertIncorrectAsCorrect: true,
        incorrect: this.spellchecker.checkSpelling(text)
      };
    };

    SystemChecker.prototype.suggest = function(args, word) {
      this.deferredInit();
      return this.spellchecker.getCorrectionsForMisspelling(word);
    };

    SystemChecker.prototype.deferredInit = function() {
      var i, len, path, ref, vendor;
      if (this.spellchecker) {
        return;
      }
      this.spellchecker = new spellchecker.Spellchecker;
      if (/win32/.test(process.platform)) {
        if (this.spellchecker.setDictionary(this.locale, "C:\\")) {
          return;
        }
      }
      ref = this.paths;
      for (i = 0, len = ref.length; i < len; i++) {
        path = ref[i];
        if (this.spellchecker.setDictionary(this.locale, path)) {
          return;
        }
      }
      if (/linux/.test(process.platform)) {
        if (this.spellchecker.setDictionary(this.locale, "/usr/share/hunspell")) {
          return;
        }
        if (this.spellchecker.setDictionary(this.locale, "/usr/share/myspell")) {
          return;
        }
        if (this.spellchecker.setDictionary(this.locale, "/usr/share/myspell/dicts")) {
          return;
        }
      }
      if (/darwin/.test(process.platform)) {
        if (this.spellchecker.setDictionary(this.locale, "/")) {
          return;
        }
        if (this.spellchecker.setDictionary(this.locale, "/System/Library/Spelling")) {
          return;
        }
      }
      path = require('path');
      vendor = path.join(__dirname, "..", "node_modules", "spellchecker", "vendor", "hunspell_dictionaries");
      if (this.spellchecker.setDictionary(this.locale, vendor)) {
        return;
      }
      this.enabled = false;
      this.reason = "Cannot find dictionary for " + this.locale + ".";
      return console.log(this.getId(), "Can't load " + this.locale + ": " + this.reason);
    };

    return SystemChecker;

  })();

  module.exports = SystemChecker;

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
