(function() {
  var SpellCheckerManager, backgroundCheck, instance, loadGlobalSettings;

  SpellCheckerManager = require('./spell-check-manager');

  instance = SpellCheckerManager;

  instance.isTask = true;

  process.on("message", function(message) {
    switch (false) {
      case message.type !== "global":
        return loadGlobalSettings(message.global);
      case message.type !== "checker":
        return instance.addCheckerPath(message.checkerPath);
    }
  });

  loadGlobalSettings = function(data) {
    return instance.setGlobalArgs(data);
  };

  backgroundCheck = function(data) {
    var misspellings;
    misspellings = instance.check(data, data.text);
    return {
      id: data.id,
      misspellings: misspellings.misspellings
    };
  };

  module.exports = backgroundCheck;

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
