Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var SnippetsAvailable = (function () {
  function SnippetsAvailable(snippets) {
    var _this = this;

    _classCallCheck(this, SnippetsAvailable);

    this.panel = null;
    this.snippets = snippets;
    this.selectListView = new _atomSelectList2['default']({
      items: [],
      filterKeyForItem: function filterKeyForItem(snippet) {
        return snippet.searchText;
      },
      elementForItem: function elementForItem(snippet) {
        var li = document.createElement('li');
        li.classList.add('two-lines');

        var primaryLine = document.createElement('div');
        primaryLine.classList.add('primary-line');
        primaryLine.textContent = snippet.prefix;
        li.appendChild(primaryLine);

        var secondaryLine = document.createElement('div');
        secondaryLine.classList.add('secondary-line');
        secondaryLine.textContent = snippet.name;
        li.appendChild(secondaryLine);

        return li;
      },
      didConfirmSelection: function didConfirmSelection(snippet) {
        for (var cursor of _this.editor.getCursors()) {
          _this.snippets.insert(snippet.bodyText, _this.editor, cursor);
        }
        _this.cancel();
      },
      didConfirmEmptySelection: function didConfirmEmptySelection() {
        _this.cancel();
      },
      didCancelSelection: function didCancelSelection() {
        _this.cancel();
      }
    });
    this.selectListView.element.classList.add('available-snippets');
    this.element = this.selectListView.element;
  }

  _createClass(SnippetsAvailable, [{
    key: 'toggle',
    value: _asyncToGenerator(function* (editor) {
      this.editor = editor;
      if (this.panel != null) {
        this.cancel();
      } else {
        this.selectListView.reset();
        yield this.populate();
        this.attach();
      }
    })
  }, {
    key: 'cancel',
    value: function cancel() {
      this.editor = null;

      if (this.panel != null) {
        this.panel.destroy();
        this.panel = null;
      }

      if (this.previouslyFocusedElement) {
        this.previouslyFocusedElement.focus();
        this.previouslyFocusedElement = null;
      }
    }
  }, {
    key: 'populate',
    value: function populate() {
      var snippets = _underscorePlus2['default'].values(this.snippets.getSnippets(this.editor));
      for (var snippet of snippets) {
        snippet.searchText = _underscorePlus2['default'].compact([snippet.prefix, snippet.name]).join(' ');
      }
      return this.selectListView.update({ items: snippets });
    }
  }, {
    key: 'attach',
    value: function attach() {
      this.previouslyFocusedElement = document.activeElement;
      this.panel = atom.workspace.addModalPanel({ item: this });
      this.selectListView.focus();
    }
  }]);

  return SnippetsAvailable;
})();

exports['default'] = SnippetsAvailable;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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