(function() {
  var Range, Snippet, _;

  _ = require('underscore-plus');

  Range = require('atom').Range;

  module.exports = Snippet = (function() {
    function Snippet(arg) {
      var bodyTree;
      this.name = arg.name, this.prefix = arg.prefix, this.bodyText = arg.bodyText, this.description = arg.description, this.descriptionMoreURL = arg.descriptionMoreURL, this.rightLabelHTML = arg.rightLabelHTML, this.leftLabel = arg.leftLabel, this.leftLabelHTML = arg.leftLabelHTML, bodyTree = arg.bodyTree;
      this.body = this.extractTabStops(bodyTree);
    }

    Snippet.prototype.extractTabStops = function(bodyTree) {
      var bodyText, column, extractTabStops, i, index, len, ref, ref1, row, tabStopsByIndex;
      tabStopsByIndex = {};
      bodyText = [];
      ref = [0, 0], row = ref[0], column = ref[1];
      extractTabStops = function(bodyTree) {
        var content, i, index, len, nextLine, results, segment, segmentLines, start;
        results = [];
        for (i = 0, len = bodyTree.length; i < len; i++) {
          segment = bodyTree[i];
          if (segment.index != null) {
            index = segment.index, content = segment.content;
            if (index === 0) {
              index = 2e308;
            }
            start = [row, column];
            extractTabStops(content);
            if (tabStopsByIndex[index] == null) {
              tabStopsByIndex[index] = [];
            }
            results.push(tabStopsByIndex[index].push(new Range(start, [row, column])));
          } else if (_.isString(segment)) {
            bodyText.push(segment);
            segmentLines = segment.split('\n');
            column += segmentLines.shift().length;
            results.push((function() {
              var results1;
              results1 = [];
              while ((nextLine = segmentLines.shift()) != null) {
                row += 1;
                results1.push(column = nextLine.length);
              }
              return results1;
            })());
          } else {
            results.push(void 0);
          }
        }
        return results;
      };
      extractTabStops(bodyTree);
      this.lineCount = row + 1;
      this.tabStops = [];
      ref1 = _.keys(tabStopsByIndex).sort((function(arg1, arg2) {
        return arg1 - arg2;
      }));
      for (i = 0, len = ref1.length; i < len; i++) {
        index = ref1[i];
        this.tabStops.push(tabStopsByIndex[index]);
      }
      return bodyText.join('');
    };

    return Snippet;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
