Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _errorView = require('./error-view');

var _errorView2 = _interopRequireDefault(_errorView);

var _packageCard = require('./package-card');

var _packageCard2 = _interopRequireDefault(_packageCard);

var UpdatesPanel = (function () {
  function UpdatesPanel(settingsView, packageManager) {
    var _this = this;

    _classCallCheck(this, UpdatesPanel);

    this.settingsView = settingsView;
    this.packageManager = packageManager;
    this.disposables = new _atom.CompositeDisposable();
    this.updatingPackages = [];
    this.packageCards = [];

    _etch2['default'].initialize(this);

    this.refs.updateAllButton.style.display = 'none';
    this.checkForUpdates();

    this.disposables.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));

    this.disposables.add(this.packageManager.on('package-updating theme-updating', function (_ref) {
      var pack = _ref.pack;
      var error = _ref.error;

      _this.refs.checkButton.disabled = true;
      _this.updatingPackages.push(pack);
    }));

    this.disposables.add(this.packageManager.on('package-updated theme-updated package-update-failed theme-update-failed', function (_ref2) {
      var pack = _ref2.pack;
      var error = _ref2.error;

      if (error != null) {
        _this.refs.updateErrors.appendChild(new _errorView2['default'](_this.packageManager, error).element);
      }

      for (var i = 0; i < _this.updatingPackages.length; i++) {
        var update = _this.updatingPackages[i];
        if (update.name === pack.name) {
          _this.updatingPackages.splice(i, 1);
        }
      }

      if (!_this.updatingPackages.length) {
        _this.refs.checkButton.disabled = false;
      }
    }));
  }

  _createClass(UpdatesPanel, [{
    key: 'destroy',
    value: function destroy() {
      this.clearPackageCards();
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      return _etch2['default'].dom(
        'div',
        { tabIndex: '0', className: 'panels-item' },
        _etch2['default'].dom(
          'section',
          { className: 'section packages' },
          _etch2['default'].dom(
            'div',
            { className: 'section-container updates-container' },
            _etch2['default'].dom(
              'div',
              { className: 'updates-heading-container' },
              _etch2['default'].dom(
                'h1',
                { className: 'section-heading icon icon-cloud-download' },
                'Available Updates'
              ),
              _etch2['default'].dom(
                'div',
                { className: 'section-heading updates-btn-group' },
                _etch2['default'].dom(
                  'button',
                  {
                    ref: 'updateAllButton',
                    className: 'pull-right update-all-button btn btn-primary',
                    onclick: function () {
                      _this2.updateAll();
                    } },
                  'Update All'
                ),
                _etch2['default'].dom(
                  'button',
                  {
                    ref: 'checkButton',
                    className: 'pull-right update-all-button btn btn',
                    onclick: function () {
                      _this2.checkForUpdates(true);
                    } },
                  'Check for Updates'
                )
              )
            ),
            _etch2['default'].dom(
              'div',
              { ref: 'versionPinnedPackagesMessage', className: 'alert alert-warning icon icon-alert' },
              'The following packages are pinned to their current version and are not being checked for updates: ',
              _etch2['default'].dom(
                'strong',
                null,
                this.packageManager.getVersionPinnedPackages().join(', ')
              )
            ),
            _etch2['default'].dom('div', { ref: 'updateErrors' }),
            _etch2['default'].dom(
              'div',
              { ref: 'checkingMessage', className: 'alert alert-info icon icon-hourglass' },
              'Checking for updates…'
            ),
            _etch2['default'].dom(
              'div',
              { ref: 'noUpdatesMessage', className: 'alert alert-info icon icon-heart' },
              'All of your installed packages are up to date!'
            ),
            _etch2['default'].dom('div', { ref: 'updatesContainer', className: 'container package-container' })
          )
        )
      );
    }
  }, {
    key: 'focus',
    value: function focus() {
      this.element.focus();
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'beforeShow',
    value: function beforeShow(opts) {
      var _this3 = this;

      if (opts && opts.back) {
        this.refs.breadcrumb.textContent = opts.back;
        this.refs.breadcrumb.onclick = function () {
          _this3.settingsView.showPanel(opts.back);
        };
      }

      if (opts && opts.updates) {
        this.availableUpdates = opts.updates;
        this.addUpdateViews();
      } else {
        this.availableUpdates = [];
        this.clearPackageCards();
        this.checkForUpdates();
      }

      if (this.packageManager.getVersionPinnedPackages().length === 0) {
        this.refs.versionPinnedPackagesMessage.style.display = 'none';
      }
    }

    // Check for updates and display them
  }, {
    key: 'checkForUpdates',
    value: _asyncToGenerator(function* (clearCache) {
      this.refs.noUpdatesMessage.style.display = 'none';
      this.refs.updateAllButton.disabled = true;
      this.refs.checkButton.disabled = true;
      this.refs.checkingMessage.style.display = '';

      try {
        this.availableUpdates = yield this.packageManager.getOutdated(clearCache);
        this.refs.checkButton.disabled = false;
        this.addUpdateViews();
      } catch (error) {
        this.refs.checkButton.disabled = false;
        this.refs.checkingMessage.style.display = 'none';
        this.refs.updateErrors.appendChild(new _errorView2['default'](this.packageManager, error).element);
      }
    })
  }, {
    key: 'addUpdateViews',
    value: function addUpdateViews() {
      if (this.availableUpdates.length > 0) {
        this.refs.updateAllButton.style.display = '';
        this.refs.updateAllButton.disabled = false;
      }
      this.refs.checkingMessage.style.display = 'none';
      this.clearPackageCards();
      if (this.availableUpdates.length === 0) {
        this.refs.noUpdatesMessage.style.display = '';
      }

      for (var pack of this.availableUpdates) {
        var packageCard = new _packageCard2['default'](pack, this.settingsView, this.packageManager, { back: 'Updates' });
        this.refs.updatesContainer.appendChild(packageCard.element);
        this.packageCards.push(packageCard);
      }
    }
  }, {
    key: 'updateAll',
    value: function updateAll() {
      var _this4 = this;

      this.refs.checkButton.disabled = true;
      this.refs.updateAllButton.disabled = true;

      var successfulUpdatesCount = 0;
      var remainingPackagesCount = this.packageCards.length;
      var totalUpdatesCount = this.packageCards.length; // This value doesn't change unlike remainingPackagesCount

      var notifyIfDone = function notifyIfDone() {
        if (remainingPackagesCount === 0) {
          if (successfulUpdatesCount > 0) {
            var pluralizedPackages = 'package';
            if (successfulUpdatesCount > 1) {
              pluralizedPackages += 's';
            }
            var message = 'Restart Atom to complete the update of ' + successfulUpdatesCount + ' ' + pluralizedPackages + '.';

            var buttons = [{
              text: 'Restart',
              onDidClick: function onDidClick() {
                return atom.restartApplication();
              }
            }];
            atom.notifications.addSuccess(message, { dismissable: true, buttons: buttons });
          }

          if (successfulUpdatesCount === totalUpdatesCount) {
            _this4.refs.checkButton.disabled = false;
            _this4.refs.updateAllButton.style.display = 'none';
          } else {
            // Some updates failed
            _this4.refs.checkButton.disabled = false;
            _this4.refs.updateAllButton.disabled = false;
          }
        }
      };

      var onUpdateResolved = function onUpdateResolved() {
        remainingPackagesCount--;
        successfulUpdatesCount++;
        notifyIfDone();
      };

      var onUpdateRejected = function onUpdateRejected() {
        remainingPackagesCount--;
        notifyIfDone();
      };

      for (var packageCard of this.packageCards) {
        if (!this.updatingPackages.includes(packageCard.pack)) {
          packageCard.update().then(onUpdateResolved, onUpdateRejected);
        } else {
          remainingPackagesCount--;
          totalUpdatesCount--;
        }
      }
    }
  }, {
    key: 'clearPackageCards',
    value: function clearPackageCards() {
      var packageCard = null;
      while (packageCard = this.packageCards.pop()) {
        packageCard.destroy();
      }
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return UpdatesPanel;
})();

exports['default'] = UpdatesPanel;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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