Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var PackageUpdatesStatusView = (function () {
  function PackageUpdatesStatusView() {
    _classCallCheck(this, PackageUpdatesStatusView);
  }

  _createClass(PackageUpdatesStatusView, [{
    key: 'initialize',
    value: function initialize(statusBar, packageManager, updates) {
      var _this = this;

      this.statusBar = statusBar;
      this.updates = updates;
      this.destroyed = true;
      this.updatingPackages = [];
      this.failedUpdates = [];
      this.disposables = new _atom.CompositeDisposable();

      this.element = document.createElement('div');
      this.element.classList.add('package-updates-status-view', 'inline-block', 'text', 'text-info');

      var iconPackage = document.createElement('span');
      iconPackage.classList.add('icon', 'icon-package');
      this.element.appendChild(iconPackage);

      this.countLabel = document.createElement('span');
      this.countLabel.classList.add('available-updates-status');
      this.element.appendChild(this.countLabel);

      this.disposables.add(packageManager.on('package-update-available theme-update-available', function (_ref) {
        var pack = _ref.pack;
        var error = _ref.error;
        _this.onPackageUpdateAvailable(pack);
      }));
      this.disposables.add(packageManager.on('package-updating theme-updating', function (_ref2) {
        var pack = _ref2.pack;
        var error = _ref2.error;
        _this.onPackageUpdating(pack);
      }));
      this.disposables.add(packageManager.on('package-updated theme-updated', function (_ref3) {
        var pack = _ref3.pack;
        var error = _ref3.error;
        _this.onPackageUpdated(pack);
      }));
      this.disposables.add(packageManager.on('package-update-failed theme-update-failed', function (_ref4) {
        var pack = _ref4.pack;
        var error = _ref4.error;
        _this.onPackageUpdateFailed(pack);
      }));

      var clickHandler = function clickHandler() {
        atom.commands.dispatch(atom.views.getView(atom.workspace), 'settings-view:check-for-package-updates');
      };
      this.element.addEventListener('click', clickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this.element.removeEventListener('click', clickHandler);
      }));

      this.updateTile();
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      this.element.remove();

      if (this.tile) {
        this.tile.destroy();
        this.tile = null;
      }

      if (this.tooltip) {
        this.tooltip.dispose();
        this.tooltip = null;
      }
    }
  }, {
    key: 'onPackageUpdateAvailable',
    value: function onPackageUpdateAvailable(pack) {
      for (var update of this.updates) {
        if (update.name === pack.name) {
          return;
        }
      }

      this.updates.push(pack);
      this.updateTile();
    }
  }, {
    key: 'onPackageUpdating',
    value: function onPackageUpdating(pack) {
      this.updatingPackages.push(pack);
      this.updateTile();
    }
  }, {
    key: 'onPackageUpdated',
    value: function onPackageUpdated(pack) {
      for (var index = 0; index < this.updates.length; index++) {
        var update = this.updates[index];
        if (update.name === pack.name) {
          this.updates.splice(index, 1);
        }
      }

      for (var index = 0; index < this.updatingPackages.length; index++) {
        var update = this.updatingPackages[index];
        if (update.name === pack.name) {
          this.updatingPackages.splice(index, 1);
        }
      }

      for (var index = 0; index < this.failedUpdates.length; index++) {
        var update = this.failedUpdates[index];
        if (update.name === pack.name) {
          this.failedUpdates.splice(index, 1);
        }
      }

      this.updateTile();
    }
  }, {
    key: 'onPackageUpdateFailed',
    value: function onPackageUpdateFailed(pack) {
      for (var update of this.failedUpdates) {
        if (update.name === pack.name) {
          return;
        }
      }

      for (var index = 0; index < this.updatingPackages.length; index++) {
        var update = this.updatingPackages[index];
        if (update.name === pack.name) {
          this.updatingPackages.splice(index, 1);
        }
      }

      this.failedUpdates.push(pack);
      this.updateTile();
    }
  }, {
    key: 'updateTile',
    value: function updateTile() {
      if (this.updates.length) {
        if (this.tooltip) {
          this.tooltip.dispose();
          this.tooltip = null;
        }

        if (this.destroyed) {
          // Priority of -99 should put us just to the left of the Squirrel icon, which displays when Atom has updates available
          this.tile = this.statusBar.addRightTile({ item: this, priority: -99 });
          this.destroyed = false;
        }

        var labelText = '' + _underscorePlus2['default'].pluralize(this.updates.length, 'update'); // 5 updates
        var tooltipText = _underscorePlus2['default'].pluralize(this.updates.length, 'package update') + ' available';

        if (this.updatingPackages.length) {
          labelText = this.updatingPackages.length + '/' + this.updates.length + ' updating'; // 3/5 updating
          tooltipText += ', ' + _underscorePlus2['default'].pluralize(this.updatingPackages.length, 'package') + ' currently updating';
        }

        if (this.failedUpdates.length) {
          labelText += ' (' + this.failedUpdates.length + ' failed)'; // 1 update (1 failed), or 3/5 updating (1 failed)
          tooltipText += ', ' + _underscorePlus2['default'].pluralize(this.failedUpdates.length, 'failed update');
        }

        this.countLabel.textContent = labelText;
        this.tooltip = atom.tooltips.add(this.element, { title: tooltipText });
      } else if (!this.destroyed) {
        this.tile.destroy();
        this.tile = null;
        this.destroyed = true;
      }
    }
  }]);

  return PackageUpdatesStatusView;
})();

exports['default'] = PackageUpdatesStatusView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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