Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _keybindingsPanel = require('./keybindings-panel');

var _keybindingsPanel2 = _interopRequireDefault(_keybindingsPanel);

// Displays the keybindings for a package namespace

var PackageKeymapView = (function () {
  function PackageKeymapView(pack) {
    var _this = this;

    _classCallCheck(this, PackageKeymapView);

    this.pack = pack;
    this.otherPlatformPattern = new RegExp('\\.platform-(?!' + _underscorePlus2['default'].escapeRegExp(process.platform) + '\\b)');
    this.namespace = this.pack.name;
    this.disposables = new _atom.CompositeDisposable();
    _etch2['default'].initialize(this);

    var packagesWithKeymapsDisabled = atom.config.get('core.packagesWithKeymapsDisabled') || [];
    this.refs.keybindingToggle.checked = !packagesWithKeymapsDisabled.includes(this.namespace);

    var changeHandler = function changeHandler(event) {
      event.stopPropagation();
      var value = _this.refs.keybindingToggle.checked;
      if (value) {
        atom.config.removeAtKeyPath('core.packagesWithKeymapsDisabled', _this.namespace);
      } else {
        atom.config.pushAtKeyPath('core.packagesWithKeymapsDisabled', _this.namespace);
      }

      _this.updateKeyBindingView();
    };
    this.refs.keybindingToggle.addEventListener('change', changeHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.keybindingToggle.removeEventListener('change', changeHandler);
    }));

    var copyIconClickHandler = function copyIconClickHandler(event) {
      var target = event.target.closest('.copy-icon');
      if (target) {
        event.preventDefault();
        event.stopPropagation();
        _this.writeKeyBindingToClipboard(target.closest('tr').dataset);
      }
    };
    this.element.addEventListener('click', copyIconClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.element.removeEventListener('click', copyIconClickHandler);
    }));

    this.updateKeyBindingView();

    var hasKeymaps = false;
    for (var _ref3 of atom.packages.getLoadedPackage(this.namespace).keymaps) {
      var _ref2 = _slicedToArray(_ref3, 2);

      var packageKeymapsPath = _ref2[0];
      var map = _ref2[1];

      if (map.length > 0) {
        hasKeymaps = true;
        break;
      }
    }

    if (this.refs.keybindingItems.children.length === 0 && !hasKeymaps) {
      this.element.style.display = 'none';
    }
  }

  _createClass(PackageKeymapView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'section',
        { className: 'section' },
        _etch2['default'].dom(
          'div',
          { className: 'section-heading icon icon-keyboard' },
          'Keybindings'
        ),
        _etch2['default'].dom(
          'div',
          { className: 'checkbox' },
          _etch2['default'].dom(
            'label',
            { 'for': 'toggleKeybindings' },
            _etch2['default'].dom('input', { id: 'toggleKeybindings', className: 'input-checkbox', type: 'checkbox', ref: 'keybindingToggle' }),
            _etch2['default'].dom(
              'div',
              { className: 'setting-title' },
              'Enable'
            )
          ),
          _etch2['default'].dom(
            'div',
            { className: 'setting-description' },
            'Disable this if you want to bind your own keystrokes for this package\\\'s commands in your keymap.'
          )
        ),
        _etch2['default'].dom(
          'table',
          { className: 'package-keymap-table table native-key-bindings text', tabIndex: '-1' },
          _etch2['default'].dom(
            'thead',
            null,
            _etch2['default'].dom(
              'tr',
              null,
              _etch2['default'].dom(
                'th',
                null,
                'Keystroke'
              ),
              _etch2['default'].dom(
                'th',
                null,
                'Command'
              ),
              _etch2['default'].dom(
                'th',
                null,
                'Selector'
              ),
              _etch2['default'].dom(
                'th',
                null,
                'Source'
              )
            )
          ),
          _etch2['default'].dom('tbody', { ref: 'keybindingItems' })
        )
      );
    }
  }, {
    key: 'updateKeyBindingView',
    value: function updateKeyBindingView() {
      this.refs.keybindingItems.innerHTML = '';

      for (var keyBinding of atom.keymaps.getKeyBindings()) {
        var command = keyBinding.command;
        var keystrokes = keyBinding.keystrokes;
        var selector = keyBinding.selector;
        var source = keyBinding.source;

        if (!command || !command.indexOf || command.indexOf(this.namespace + ':') !== 0) {
          continue;
        }

        if (this.otherPlatformPattern.test(selector)) {
          continue;
        }

        var keyBindingRow = document.createElement('tr');
        keyBindingRow.dataset.selector = selector;
        keyBindingRow.dataset.keystrokes = keystrokes;
        keyBindingRow.dataset.command = command;

        var keystrokesTd = document.createElement('td');

        var copyIconSpan = document.createElement('span');
        copyIconSpan.classList.add('icon', 'icon-clippy', 'copy-icon');
        keystrokesTd.appendChild(copyIconSpan);

        var keystrokesSpan = document.createElement('span');
        keystrokesSpan.textContent = keystrokes;
        keystrokesTd.appendChild(keystrokesSpan);

        keyBindingRow.appendChild(keystrokesTd);

        var commandTd = document.createElement('td');
        commandTd.textContent = command;
        keyBindingRow.appendChild(commandTd);

        var selectorTd = document.createElement('td');
        selectorTd.textContent = selector;
        keyBindingRow.appendChild(selectorTd);

        var sourceTd = document.createElement('td');
        sourceTd.textContent = _keybindingsPanel2['default'].determineSource(source);
        keyBindingRow.appendChild(sourceTd);

        this.refs.keybindingItems.appendChild(keyBindingRow);
      }
    }
  }, {
    key: 'writeKeyBindingToClipboard',
    value: function writeKeyBindingToClipboard(_ref4) {
      var selector = _ref4.selector;
      var keystrokes = _ref4.keystrokes;
      var command = _ref4.command;

      var content = undefined;
      var keymapExtension = _path2['default'].extname(atom.keymaps.getUserKeymapPath());
      if (keymapExtension === '.cson') {
        content = '\'' + selector + '\':\n  \'' + keystrokes + '\': \'' + command + '\'';
      } else {
        content = '"' + selector + '": {\n  "' + keystrokes + '": "' + command + '"\n}';
      }

      atom.clipboard.write(content);
    }
  }]);

  return PackageKeymapView;
})();

exports['default'] = PackageKeymapView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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