(function() {
  var Emitter, List, difference;

  Emitter = require('atom').Emitter;

  module.exports = List = (function() {
    function List(key1) {
      this.key = key1;
      this.items = [];
      this.emitter = new Emitter;
    }

    List.prototype.getItems = function() {
      return this.items;
    };

    List.prototype.filterItems = function(filterFn) {
      var i, item, len, ref, results;
      ref = this.items;
      results = [];
      for (i = 0, len = ref.length; i < len; i++) {
        item = ref[i];
        if (filterFn(item)) {
          results.push(item);
        }
      }
      return results;
    };

    List.prototype.keyForItem = function(item) {
      return item[this.key];
    };

    List.prototype.setItems = function(items) {
      var i, item, j, len, len1, results, setToAdd, setToRemove;
      items = items.slice(0);
      setToAdd = difference(items, this.items, this.key);
      setToRemove = difference(this.items, items, this.key);
      this.items = items;
      for (i = 0, len = setToAdd.length; i < len; i++) {
        item = setToAdd[i];
        this.emitter.emit('did-add-item', item);
      }
      results = [];
      for (j = 0, len1 = setToRemove.length; j < len1; j++) {
        item = setToRemove[j];
        results.push(this.emitter.emit('did-remove-item', item));
      }
      return results;
    };

    List.prototype.onDidAddItem = function(callback) {
      return this.emitter.on('did-add-item', callback);
    };

    List.prototype.onDidRemoveItem = function(callback) {
      return this.emitter.on('did-remove-item', callback);
    };

    return List;

  })();

  difference = function(array1, array2, key) {
    var diff, i, item, j, k, len, len1, obj1, obj2, v;
    obj1 = {};
    for (i = 0, len = array1.length; i < len; i++) {
      item = array1[i];
      obj1[item[key]] = item;
    }
    obj2 = {};
    for (j = 0, len1 = array2.length; j < len1; j++) {
      item = array2[j];
      obj2[item[key]] = item;
    }
    diff = [];
    for (k in obj1) {
      v = obj1[k];
      if (obj2[k] == null) {
        diff.push(v);
      }
    }
    return diff;
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
