(function() {
  var ListView;

  module.exports = ListView = (function() {
    function ListView(list, container, createView) {
      this.list = list;
      this.container = container;
      this.createView = createView;
      this.views = [];
      this.viewMap = {};
      this.list.onDidAddItem((function(_this) {
        return function(item) {
          return _this.addView(item);
        };
      })(this));
      this.list.onDidRemoveItem((function(_this) {
        return function(item) {
          return _this.removeView(item);
        };
      })(this));
      this.addViews();
    }

    ListView.prototype.getViews = function() {
      return this.views;
    };

    ListView.prototype.filterViews = function(filterFn) {
      var i, item, len, ref, results;
      ref = this.list.filterItems(filterFn);
      results = [];
      for (i = 0, len = ref.length; i < len; i++) {
        item = ref[i];
        results.push(this.viewMap[this.list.keyForItem(item)]);
      }
      return results;
    };

    ListView.prototype.addViews = function() {
      var i, item, len, ref;
      ref = this.list.getItems();
      for (i = 0, len = ref.length; i < len; i++) {
        item = ref[i];
        this.addView(item);
      }
    };

    ListView.prototype.addView = function(item) {
      var row, view;
      view = this.createView(item);
      this.views.push(view);
      this.viewMap[this.list.keyForItem(item)] = view;
      row = document.createElement('div');
      row.classList.add('row');
      row.appendChild(view.element);
      return this.container.insertBefore(row, this.container.children[0]);
    };

    ListView.prototype.removeView = function(item) {
      var index, key, view;
      key = this.list.keyForItem(item);
      view = this.viewMap[key];
      if (view != null) {
        index = this.views.indexOf(view);
        if (index > -1) {
          this.views.splice(index, 1);
        }
        delete this.viewMap[key];
        view.element.parentElement.remove();
        return view.destroy();
      }
    };

    return ListView;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiL2hvbWUvYW5kcmVpL2F0b20tMS4xOS4yL291dC9hcHAvbm9kZV9tb2R1bGVzL3NldHRpbmdzLXZpZXcvbGliL2xpc3Qtdmlldy5jb2ZmZWUiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQSxNQUFBOztFQUFBLE1BQU0sQ0FBQyxPQUFQLEdBQ007SUFLUyxrQkFBQyxJQUFELEVBQVEsU0FBUixFQUFvQixVQUFwQjtNQUFDLElBQUMsQ0FBQSxPQUFEO01BQU8sSUFBQyxDQUFBLFlBQUQ7TUFBWSxJQUFDLENBQUEsYUFBRDtNQUMvQixJQUFDLENBQUEsS0FBRCxHQUFTO01BQ1QsSUFBQyxDQUFBLE9BQUQsR0FBVztNQUNYLElBQUMsQ0FBQSxJQUFJLENBQUMsWUFBTixDQUFtQixDQUFBLFNBQUEsS0FBQTtlQUFBLFNBQUMsSUFBRDtpQkFBVSxLQUFDLENBQUEsT0FBRCxDQUFTLElBQVQ7UUFBVjtNQUFBLENBQUEsQ0FBQSxDQUFBLElBQUEsQ0FBbkI7TUFDQSxJQUFDLENBQUEsSUFBSSxDQUFDLGVBQU4sQ0FBc0IsQ0FBQSxTQUFBLEtBQUE7ZUFBQSxTQUFDLElBQUQ7aUJBQVUsS0FBQyxDQUFBLFVBQUQsQ0FBWSxJQUFaO1FBQVY7TUFBQSxDQUFBLENBQUEsQ0FBQSxJQUFBLENBQXRCO01BQ0EsSUFBQyxDQUFBLFFBQUQsQ0FBQTtJQUxXOzt1QkFPYixRQUFBLEdBQVUsU0FBQTthQUFHLElBQUMsQ0FBQTtJQUFKOzt1QkFFVixXQUFBLEdBQWEsU0FBQyxRQUFEO0FBQ1gsVUFBQTtBQUFDO0FBQUE7V0FBQSxxQ0FBQTs7cUJBQUEsSUFBQyxDQUFBLE9BQVEsQ0FBQSxJQUFDLENBQUEsSUFBSSxDQUFDLFVBQU4sQ0FBaUIsSUFBakIsQ0FBQTtBQUFUOztJQURVOzt1QkFHYixRQUFBLEdBQVUsU0FBQTtBQUNSLFVBQUE7QUFBQTtBQUFBLFdBQUEscUNBQUE7O1FBQ0UsSUFBQyxDQUFBLE9BQUQsQ0FBUyxJQUFUO0FBREY7SUFEUTs7dUJBS1YsT0FBQSxHQUFTLFNBQUMsSUFBRDtBQUNQLFVBQUE7TUFBQSxJQUFBLEdBQU8sSUFBQyxDQUFBLFVBQUQsQ0FBWSxJQUFaO01BQ1AsSUFBQyxDQUFBLEtBQUssQ0FBQyxJQUFQLENBQVksSUFBWjtNQUNBLElBQUMsQ0FBQSxPQUFRLENBQUEsSUFBQyxDQUFBLElBQUksQ0FBQyxVQUFOLENBQWlCLElBQWpCLENBQUEsQ0FBVCxHQUFtQztNQUNuQyxHQUFBLEdBQU0sUUFBUSxDQUFDLGFBQVQsQ0FBdUIsS0FBdkI7TUFDTixHQUFHLENBQUMsU0FBUyxDQUFDLEdBQWQsQ0FBa0IsS0FBbEI7TUFDQSxHQUFHLENBQUMsV0FBSixDQUFnQixJQUFJLENBQUMsT0FBckI7YUFDQSxJQUFDLENBQUEsU0FBUyxDQUFDLFlBQVgsQ0FBd0IsR0FBeEIsRUFBNkIsSUFBQyxDQUFBLFNBQVMsQ0FBQyxRQUFTLENBQUEsQ0FBQSxDQUFqRDtJQVBPOzt1QkFTVCxVQUFBLEdBQVksU0FBQyxJQUFEO0FBQ1YsVUFBQTtNQUFBLEdBQUEsR0FBTSxJQUFDLENBQUEsSUFBSSxDQUFDLFVBQU4sQ0FBaUIsSUFBakI7TUFDTixJQUFBLEdBQU8sSUFBQyxDQUFBLE9BQVEsQ0FBQSxHQUFBO01BQ2hCLElBQUcsWUFBSDtRQUNFLEtBQUEsR0FBUSxJQUFDLENBQUEsS0FBSyxDQUFDLE9BQVAsQ0FBZSxJQUFmO1FBQ1IsSUFBMkIsS0FBQSxHQUFRLENBQUMsQ0FBcEM7VUFBQSxJQUFDLENBQUEsS0FBSyxDQUFDLE1BQVAsQ0FBYyxLQUFkLEVBQXFCLENBQXJCLEVBQUE7O1FBQ0EsT0FBTyxJQUFDLENBQUEsT0FBUSxDQUFBLEdBQUE7UUFDaEIsSUFBSSxDQUFDLE9BQU8sQ0FBQyxhQUFhLENBQUMsTUFBM0IsQ0FBQTtlQUNBLElBQUksQ0FBQyxPQUFMLENBQUEsRUFMRjs7SUFIVTs7Ozs7QUFoQ2QiLCJzb3VyY2VzQ29udGVudCI6WyJtb2R1bGUuZXhwb3J0cyA9XG5jbGFzcyBMaXN0Vmlld1xuICAjICogYGxpc3RgIGEge0xpc3R9IG9iamVjdFxuICAjICogYGNvbnRhaW5lcmAgYSBqUXVlcnkgZWxlbWVudFxuICAjICogYGNyZWF0ZVZpZXdgIGEgRnVuY3Rpb24gdGhhdCByZXR1cm5zIGEgalF1ZXJ5IGVsZW1lbnQgLyBIVE1MRWxlbWVudFxuICAjICAgKiBgaXRlbWAgdGhlIGl0ZW0gdG8gY3JlYXRlIHRoZSB2aWV3IGZvclxuICBjb25zdHJ1Y3RvcjogKEBsaXN0LCBAY29udGFpbmVyLCBAY3JlYXRlVmlldykgLT5cbiAgICBAdmlld3MgPSBbXVxuICAgIEB2aWV3TWFwID0ge31cbiAgICBAbGlzdC5vbkRpZEFkZEl0ZW0gKGl0ZW0pID0+IEBhZGRWaWV3KGl0ZW0pXG4gICAgQGxpc3Qub25EaWRSZW1vdmVJdGVtIChpdGVtKSA9PiBAcmVtb3ZlVmlldyhpdGVtKVxuICAgIEBhZGRWaWV3cygpXG5cbiAgZ2V0Vmlld3M6IC0+IEB2aWV3c1xuXG4gIGZpbHRlclZpZXdzOiAoZmlsdGVyRm4pIC0+XG4gICAgKEB2aWV3TWFwW0BsaXN0LmtleUZvckl0ZW0oaXRlbSldIGZvciBpdGVtIGluIEBsaXN0LmZpbHRlckl0ZW1zKGZpbHRlckZuKSlcblxuICBhZGRWaWV3czogLT5cbiAgICBmb3IgaXRlbSBpbiBAbGlzdC5nZXRJdGVtcygpXG4gICAgICBAYWRkVmlldyhpdGVtKVxuICAgIHJldHVyblxuXG4gIGFkZFZpZXc6IChpdGVtKSAtPlxuICAgIHZpZXcgPSBAY3JlYXRlVmlldyhpdGVtKVxuICAgIEB2aWV3cy5wdXNoKHZpZXcpXG4gICAgQHZpZXdNYXBbQGxpc3Qua2V5Rm9ySXRlbShpdGVtKV0gPSB2aWV3XG4gICAgcm93ID0gZG9jdW1lbnQuY3JlYXRlRWxlbWVudCgnZGl2JylcbiAgICByb3cuY2xhc3NMaXN0LmFkZCgncm93JylcbiAgICByb3cuYXBwZW5kQ2hpbGQodmlldy5lbGVtZW50KVxuICAgIEBjb250YWluZXIuaW5zZXJ0QmVmb3JlKHJvdywgQGNvbnRhaW5lci5jaGlsZHJlblswXSlcblxuICByZW1vdmVWaWV3OiAoaXRlbSkgLT5cbiAgICBrZXkgPSBAbGlzdC5rZXlGb3JJdGVtKGl0ZW0pXG4gICAgdmlldyA9IEB2aWV3TWFwW2tleV1cbiAgICBpZiB2aWV3P1xuICAgICAgaW5kZXggPSBAdmlld3MuaW5kZXhPZih2aWV3KVxuICAgICAgQHZpZXdzLnNwbGljZShpbmRleCwgMSkgaWYgaW5kZXggPiAtMVxuICAgICAgZGVsZXRlIEB2aWV3TWFwW2tleV1cbiAgICAgIHZpZXcuZWxlbWVudC5wYXJlbnRFbGVtZW50LnJlbW92ZSgpXG4gICAgICB2aWV3LmRlc3Ryb3koKVxuIl19
