Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _electron = require('electron');

var _electron2 = _interopRequireDefault(_electron);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _packageCard = require('./package-card');

var _packageCard2 = _interopRequireDefault(_packageCard);

var _errorView = require('./error-view');

var _errorView2 = _interopRequireDefault(_errorView);

var _hostedGitInfo = require('hosted-git-info');

var _hostedGitInfo2 = _interopRequireDefault(_hostedGitInfo);

var PackageNameRegex = /config\/install\/(package|theme):([a-z0-9-_]+)/i;

var InstallPanel = (function () {
  function InstallPanel(settingsView, packageManager) {
    var _this = this;

    _classCallCheck(this, InstallPanel);

    this.settingsView = settingsView;
    this.packageManager = packageManager;
    this.disposables = new _atom.CompositeDisposable();
    this.client = this.packageManager.getClient();
    this.atomIoURL = 'https://atom.io/packages';

    _etch2['default'].initialize(this);

    this.refs.searchMessage.style.display = 'none';

    this.refs.searchEditor.setPlaceholderText('Search packages');
    this.searchType = 'packages';
    this.disposables.add(this.packageManager.on('package-install-failed', function (_ref) {
      var pack = _ref.pack;
      var error = _ref.error;

      _this.refs.searchErrors.appendChild(new _errorView2['default'](_this.packageManager, error).element);
    }));
    this.disposables.add(this.packageManager.on('package-installed theme-installed', function (_ref2) {
      var pack = _ref2.pack;

      var gitUrlInfo = _this.currentGitPackageCard && _this.currentGitPackageCard.pack && _this.currentGitPackageCard.pack.gitUrlInfo ? _this.currentGitPackageCard.pack.gitUrlInfo : null;

      if (gitUrlInfo && gitUrlInfo === pack.gitUrlInfo) {
        _this.updateGitPackageCard(pack);
      }
    }));

    this.disposables.add(atom.commands.add(this.refs.searchEditor.element, 'core:confirm', function () {
      _this.performSearch();
    }));
    this.disposables.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));

    this.loadFeaturedPackages();
  }

  _createClass(InstallPanel, [{
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'focus',
    value: function focus() {
      this.refs.searchEditor.element.focus();
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'panels-item', tabIndex: '-1' },
        _etch2['default'].dom(
          'div',
          { className: 'section packages' },
          _etch2['default'].dom(
            'div',
            { className: 'section-container' },
            _etch2['default'].dom(
              'h1',
              { ref: 'installHeading', className: 'section-heading icon icon-plus' },
              'Install Packages'
            ),
            _etch2['default'].dom(
              'div',
              { className: 'text native-key-bindings', tabIndex: '-1' },
              _etch2['default'].dom('span', { className: 'icon icon-question' }),
              _etch2['default'].dom(
                'span',
                { ref: 'publishedToText' },
                'Packages are published to '
              ),
              _etch2['default'].dom(
                'a',
                { className: 'link', onclick: this.didClickOpenAtomIo.bind(this) },
                'atom.io'
              ),
              _etch2['default'].dom(
                'span',
                null,
                ' and are installed to ',
                _path2['default'].join(process.env.ATOM_HOME, 'packages')
              )
            ),
            _etch2['default'].dom(
              'div',
              { className: 'search-container clearfix' },
              _etch2['default'].dom(
                'div',
                { className: 'editor-container' },
                _etch2['default'].dom(_atom.TextEditor, { mini: true, ref: 'searchEditor' })
              ),
              _etch2['default'].dom(
                'div',
                { className: 'btn-group' },
                _etch2['default'].dom(
                  'button',
                  { ref: 'searchPackagesButton', className: 'btn btn-default selected', onclick: this.didClickSearchPackagesButton.bind(this) },
                  'Packages'
                ),
                _etch2['default'].dom(
                  'button',
                  { ref: 'searchThemesButton', className: 'btn btn-default', onclick: this.didClickSearchThemesButton.bind(this) },
                  'Themes'
                )
              )
            ),
            _etch2['default'].dom('div', { ref: 'searchErrors' }),
            _etch2['default'].dom('div', { ref: 'searchMessage', className: 'alert alert-info search-message icon icon-search' }),
            _etch2['default'].dom('div', { ref: 'resultsContainer', className: 'container package-container' })
          )
        ),
        _etch2['default'].dom(
          'div',
          { className: 'section packages' },
          _etch2['default'].dom(
            'div',
            { className: 'section-container' },
            _etch2['default'].dom('div', { ref: 'featuredHeading', className: 'section-heading icon icon-star' }),
            _etch2['default'].dom('div', { ref: 'featuredErrors' }),
            _etch2['default'].dom('div', { ref: 'loadingMessage', className: 'alert alert-info icon icon-hourglass' }),
            _etch2['default'].dom('div', { ref: 'featuredContainer', className: 'container package-container' })
          )
        )
      );
    }
  }, {
    key: 'setSearchType',
    value: function setSearchType(searchType) {
      if (searchType === 'theme') {
        this.searchType = 'themes';
        this.refs.searchThemesButton.classList.add('selected');
        this.refs.searchPackagesButton.classList.remove('selected');
        this.refs.searchEditor.setPlaceholderText('Search themes');
        this.refs.publishedToText.textContent = 'Themes are published to ';
        this.atomIoURL = 'https://atom.io/themes';
        this.loadFeaturedPackages(true);
      } else if (searchType === 'package') {
        this.searchType = 'packages';
        this.refs.searchPackagesButton.classList.add('selected');
        this.refs.searchThemesButton.classList.remove('selected');
        this.refs.searchEditor.setPlaceholderText('Search packages');
        this.refs.publishedToText.textContent = 'Packages are published to ';
        this.atomIoURL = 'https://atom.io/packages';
        this.loadFeaturedPackages();
      }
    }
  }, {
    key: 'beforeShow',
    value: function beforeShow(options) {
      if (options && options.uri) {
        var query = this.extractQueryFromURI(options.uri);
        if (query != null) {
          var searchType = query.searchType;
          var packageName = query.packageName;

          this.setSearchType(searchType);
          this.refs.searchEditor.setText(packageName);
          this.performSearch();
        }
      }
    }
  }, {
    key: 'extractQueryFromURI',
    value: function extractQueryFromURI(uri) {
      var matches = PackageNameRegex.exec(uri);
      if (matches) {
        var _Array$from = Array.from(matches);

        var _Array$from2 = _slicedToArray(_Array$from, 3);

        var searchType = _Array$from2[1];
        var packageName = _Array$from2[2];

        return { searchType: searchType, packageName: packageName };
      } else {
        return null;
      }
    }
  }, {
    key: 'performSearch',
    value: function performSearch() {
      var query = this.refs.searchEditor.getText().trim().toLowerCase();
      if (query) {
        this.performSearchForQuery(query);
      }
    }
  }, {
    key: 'performSearchForQuery',
    value: function performSearchForQuery(query) {
      var gitUrlInfo = undefined;
      if (gitUrlInfo = _hostedGitInfo2['default'].fromUrl(query)) {
        var type = gitUrlInfo['default'];
        if (type === 'sshurl' || type === 'https' || type === 'shortcut') {
          this.showGitInstallPackageCard({ name: query, gitUrlInfo: gitUrlInfo });
        }
      } else {
        this.search(query);
      }
    }
  }, {
    key: 'showGitInstallPackageCard',
    value: function showGitInstallPackageCard(pack) {
      if (this.currentGitPackageCard) {
        this.currentGitPackageCard.destroy();
      }

      this.currentGitPackageCard = this.getPackageCardView(pack);
      this.currentGitPackageCard.displayGitPackageInstallInformation();
      this.replaceCurrentGitPackageCardView();
    }
  }, {
    key: 'updateGitPackageCard',
    value: function updateGitPackageCard(pack) {
      if (this.currentGitPackageCard) {
        this.currentGitPackageCard.destroy();
      }

      this.currentGitPackageCard = this.getPackageCardView(pack);
      this.replaceCurrentGitPackageCardView();
    }
  }, {
    key: 'replaceCurrentGitPackageCardView',
    value: function replaceCurrentGitPackageCardView() {
      this.refs.resultsContainer.innerHTML = '';
      this.addPackageCardView(this.refs.resultsContainer, this.currentGitPackageCard);
    }
  }, {
    key: 'search',
    value: _asyncToGenerator(function* (query) {
      this.refs.resultsContainer.innerHTML = '';
      this.refs.searchMessage.textContent = 'Searching ' + this.searchType + ' for “' + query + '”…';
      this.refs.searchMessage.style.display = '';

      var opts = {};
      opts[this.searchType] = true;
      opts['sortBy'] = 'downloads';

      try {
        var packages = (yield this.packageManager.search(query, opts)) || [];
        this.refs.resultsContainer.innerHTML = '';
        this.refs.searchMessage.style.display = 'none';
        if (packages.length === 0) {
          this.showNoResultMessage(query);
        }
        this.highlightExactMatch(this.refs.resultsContainer, query, packages);
        this.addCloseMatches(this.refs.resultsContainer, query, packages);
        this.addPackageViews(this.refs.resultsContainer, packages);
      } catch (error) {
        this.refs.searchMessage.style.display = 'none';
        this.refs.searchErrors.appendChild(new _errorView2['default'](this.packageManager, error).element);
      }
    })
  }, {
    key: 'showNoResultMessage',
    value: function showNoResultMessage(query) {
      this.refs.searchMessage.textContent = 'No ' + this.searchType.replace(/s$/, '') + ' results for “' + query + '”';
      this.refs.searchMessage.style.display = '';
    }
  }, {
    key: 'highlightExactMatch',
    value: function highlightExactMatch(container, query, packages) {
      var exactMatch = _underscorePlus2['default'].filter(packages, function (pkg) {
        return pkg.name === query;
      })[0];

      if (exactMatch) {
        this.addPackageCardView(container, this.getPackageCardView(exactMatch));
        packages.splice(packages.indexOf(exactMatch), 1);
      }
    }
  }, {
    key: 'addCloseMatches',
    value: function addCloseMatches(container, query, packages) {
      var matches = _underscorePlus2['default'].filter(packages, function (pkg) {
        return pkg.name.indexOf(query) >= 0;
      });

      for (var pack of matches) {
        this.addPackageCardView(container, this.getPackageCardView(pack));
        packages.splice(packages.indexOf(pack), 1);
      }
    }
  }, {
    key: 'addPackageViews',
    value: function addPackageViews(container, packages) {
      for (var pack of packages) {
        this.addPackageCardView(container, this.getPackageCardView(pack));
      }
    }
  }, {
    key: 'addPackageCardView',
    value: function addPackageCardView(container, packageCard) {
      var packageRow = document.createElement('div');
      packageRow.classList.add('row');
      packageRow.appendChild(packageCard.element);
      container.appendChild(packageRow);
    }
  }, {
    key: 'getPackageCardView',
    value: function getPackageCardView(pack) {
      return new _packageCard2['default'](pack, this.settingsView, this.packageManager, { back: 'Install' });
    }
  }, {
    key: 'filterPackages',
    value: function filterPackages(packages, themes) {
      return packages.filter(function (_ref3) {
        var theme = _ref3.theme;
        return themes ? theme : !theme;
      });
    }

    // Load and display the featured packages that are available to install.
  }, {
    key: 'loadFeaturedPackages',
    value: function loadFeaturedPackages(loadThemes) {
      var _this2 = this;

      if (loadThemes == null) {
        loadThemes = false;
      }
      this.refs.featuredContainer.innerHTML = '';

      if (loadThemes) {
        this.refs.installHeading.textContent = 'Install Themes';
        this.refs.featuredHeading.textContent = 'Featured Themes';
        this.refs.loadingMessage.textContent = 'Loading featured themes…';
      } else {
        this.refs.installHeading.textContent = 'Install Packages';
        this.refs.featuredHeading.textContent = 'Featured Packages';
        this.refs.loadingMessage.textContent = 'Loading featured packages…';
      }

      this.refs.loadingMessage.style.display = '';

      var handle = function handle(error) {
        _this2.refs.loadingMessage.style.display = 'none';
        _this2.refs.featuredErrors.appendChild(new _errorView2['default'](_this2.packageManager, error).element);
      };

      if (loadThemes) {
        this.client.featuredThemes(function (error, themes) {
          if (error) {
            handle(error);
          } else {
            _this2.refs.loadingMessage.style.display = 'none';
            _this2.refs.featuredHeading.textContent = 'Featured Themes';
            _this2.addPackageViews(_this2.refs.featuredContainer, themes);
          }
        });
      } else {
        this.client.featuredPackages(function (error, packages) {
          if (error) {
            handle(error);
          } else {
            _this2.refs.loadingMessage.style.display = 'none';
            _this2.refs.featuredHeading.textContent = 'Featured Packages';
            _this2.addPackageViews(_this2.refs.featuredContainer, packages);
          }
        });
      }
    }
  }, {
    key: 'didClickOpenAtomIo',
    value: function didClickOpenAtomIo(event) {
      event.preventDefault();
      _electron2['default'].shell.openExternal(this.atomIoURL);
    }
  }, {
    key: 'didClickSearchPackagesButton',
    value: function didClickSearchPackagesButton() {
      if (!this.refs.searchPackagesButton.classList.contains('selected')) {
        this.setSearchType('package');
      }

      this.performSearch();
    }
  }, {
    key: 'didClickSearchThemesButton',
    value: function didClickSearchThemesButton() {
      if (!this.refs.searchThemesButton.classList.contains('selected')) {
        this.setSearchType('theme');
      }

      this.performSearch();
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return InstallPanel;
})();

exports['default'] = InstallPanel;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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