(function() {
  var NotificationsPanelView;

  module.exports = NotificationsPanelView = (function() {
    function NotificationsPanelView() {
      var errorButton, fatalErrorButton, infoButton, successButton, toolbar, warningButton;
      this.element = document.createElement('div');
      this.element.classList.add('notifications');
      this.element.classList.add('padded');
      toolbar = document.createElement('div');
      toolbar.classList.add('btn-toolbar');
      this.element.appendChild(toolbar);
      fatalErrorButton = document.createElement('button');
      fatalErrorButton.classList.add('btn');
      fatalErrorButton.textContent = "Create Fatal Error";
      fatalErrorButton.addEventListener('click', this.createFatalError);
      toolbar.appendChild(fatalErrorButton);
      errorButton = document.createElement('button');
      errorButton.classList.add('btn');
      errorButton.textContent = "Create Error";
      errorButton.addEventListener('click', this.createError);
      toolbar.appendChild(errorButton);
      warningButton = document.createElement('button');
      warningButton.classList.add('btn');
      warningButton.textContent = "Create Warning";
      warningButton.addEventListener('click', this.createWarning);
      toolbar.appendChild(warningButton);
      infoButton = document.createElement('button');
      infoButton.classList.add('btn');
      infoButton.textContent = "Create Info Notification";
      infoButton.addEventListener('click', this.createInfo);
      toolbar.appendChild(infoButton);
      successButton = document.createElement('button');
      successButton.classList.add('btn');
      successButton.textContent = "Create Success Notification";
      successButton.addEventListener('click', this.createSuccess);
      toolbar.appendChild(successButton);
    }

    NotificationsPanelView.prototype.getElement = function() {
      return this.element;
    };

    NotificationsPanelView.prototype.createFatalError = function() {
      return atom.commands.dispatch(atom.views.getView(atom.workspace), 'notifications:trigger-error');
    };

    NotificationsPanelView.prototype.createError = function() {
      var message, options;
      message = 'Failed to load your user config';
      options = {
        dismissable: true,
        detail: "line 6: unexpected newline\n'metrics'::\n^"
      };
      return atom.notifications.addError(message, options);
    };

    NotificationsPanelView.prototype.createWarning = function() {
      return atom.notifications.addWarning('Oops warning');
    };

    NotificationsPanelView.prototype.createInfo = function() {
      return atom.notifications.addInfo('Some info for you', {
        icon: 'comment'
      });
    };

    NotificationsPanelView.prototype.createSuccess = function() {
      return atom.notifications.addSuccess('Yeah, success!');
    };

    return NotificationsPanelView;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
