(function() {
  var ButtonListTemplate, ButtonTemplate, FatalMetaNotificationTemplate, MetaNotificationTemplate, NotificationElement, NotificationIssue, NotificationTemplate, TemplateHelper, UserUtilities, addSplitLinesToContainer, fs, marked, path, shell;

  fs = require('fs-plus');

  path = require('path');

  marked = require('marked');

  shell = require('electron').shell;

  NotificationIssue = require('./notification-issue');

  TemplateHelper = require('./template-helper');

  UserUtilities = require('./user-utilities');

  NotificationTemplate = "<div class=\"content\">\n  <div class=\"message item\"></div>\n  <div class=\"detail item\">\n    <div class=\"detail-content\"></div>\n    <a href=\"#\" class=\"stack-toggle\"></a>\n    <div class=\"stack-container\"></div>\n  </div>\n  <div class=\"meta item\"></div>\n</div>\n<div class=\"close icon icon-x\"></div>\n<div class=\"close-all btn btn-error\">Close All</div>";

  FatalMetaNotificationTemplate = "<div class=\"description fatal-notification\"></div>\n<div class=\"btn-toolbar\">\n  <a href=\"#\" class=\"btn-issue btn btn-error\"></a>\n  <a href=\"#\" class=\"btn-copy-report icon icon-clippy\" title=\"Copy error report to clipboard\"></a>\n</div>";

  MetaNotificationTemplate = "<div class=\"description\"></div>";

  ButtonListTemplate = "<div class=\"btn-toolbar\"></div>";

  ButtonTemplate = "<a href=\"#\" class=\"btn\"></a>";

  module.exports = NotificationElement = (function() {
    NotificationElement.prototype.animationDuration = 360;

    NotificationElement.prototype.visibilityDuration = 5000;

    function NotificationElement(model) {
      this.model = model;
      this.fatalTemplate = TemplateHelper.create(FatalMetaNotificationTemplate);
      this.metaTemplate = TemplateHelper.create(MetaNotificationTemplate);
      this.buttonListTemplate = TemplateHelper.create(ButtonListTemplate);
      this.buttonTemplate = TemplateHelper.create(ButtonTemplate);
      this.element = document.createElement('atom-notification');
      if (this.model.getType() === 'fatal') {
        this.issue = new NotificationIssue(this.model);
      }
      this.renderPromise = this.render()["catch"](function(e) {
        console.error(e.message);
        return console.error(e.stack);
      });
      if (this.model.isDismissable()) {
        this.model.onDidDismiss((function(_this) {
          return function() {
            return _this.removeNotification();
          };
        })(this));
      } else {
        this.autohide();
      }
      this.element.issue = this.issue;
      this.element.getRenderPromise = this.getRenderPromise.bind(this);
    }

    NotificationElement.prototype.getModel = function() {
      return this.model;
    };

    NotificationElement.prototype.getRenderPromise = function() {
      return this.renderPromise;
    };

    NotificationElement.prototype.render = function() {
      var buttonClass, closeAllButton, closeButton, description, detail, metaContainer, metaContent, notificationContainer, options, stack, stackContainer, stackToggle, toolbar;
      this.element.classList.add("" + (this.model.getType()));
      this.element.classList.add("icon", "icon-" + (this.model.getIcon()), "native-key-bindings");
      if (detail = this.model.getDetail()) {
        this.element.classList.add('has-detail');
      }
      if (this.model.isDismissable()) {
        this.element.classList.add('has-close');
      }
      if (this.model.getOptions().stack != null) {
        this.element.classList.add('has-stack');
      }
      this.element.setAttribute('tabindex', '-1');
      this.element.innerHTML = NotificationTemplate;
      options = this.model.getOptions();
      notificationContainer = this.element.querySelector('.message');
      notificationContainer.innerHTML = marked(this.model.getMessage());
      if (detail = this.model.getDetail()) {
        addSplitLinesToContainer(this.element.querySelector('.detail-content'), detail);
        if (stack = options.stack) {
          stackToggle = this.element.querySelector('.stack-toggle');
          stackContainer = this.element.querySelector('.stack-container');
          addSplitLinesToContainer(stackContainer, stack);
          stackToggle.addEventListener('click', (function(_this) {
            return function(e) {
              return _this.handleStackTraceToggleClick(e, stackContainer);
            };
          })(this));
          this.handleStackTraceToggleClick({
            currentTarget: stackToggle
          }, stackContainer);
        }
      }
      if (metaContent = options.description) {
        this.element.classList.add('has-description');
        metaContainer = this.element.querySelector('.meta');
        metaContainer.appendChild(TemplateHelper.render(this.metaTemplate));
        description = this.element.querySelector('.description');
        description.innerHTML = marked(metaContent);
      }
      if (options.buttons && options.buttons.length > 0) {
        this.element.classList.add('has-buttons');
        metaContainer = this.element.querySelector('.meta');
        metaContainer.appendChild(TemplateHelper.render(this.buttonListTemplate));
        toolbar = this.element.querySelector('.btn-toolbar');
        buttonClass = this.model.getType();
        if (buttonClass === 'fatal') {
          buttonClass = 'error';
        }
        buttonClass = "btn-" + buttonClass;
        options.buttons.forEach((function(_this) {
          return function(button) {
            var buttonEl;
            toolbar.appendChild(TemplateHelper.render(_this.buttonTemplate));
            buttonEl = toolbar.childNodes[toolbar.childNodes.length - 1];
            buttonEl.textContent = button.text;
            buttonEl.classList.add(buttonClass);
            if (button.className != null) {
              buttonEl.classList.add.apply(buttonEl.classList, button.className.split(' '));
            }
            if (button.onDidClick != null) {
              return buttonEl.addEventListener('click', function(e) {
                return button.onDidClick.call(_this, e);
              });
            }
          };
        })(this));
      }
      if (this.model.isDismissable()) {
        closeButton = this.element.querySelector('.close');
        closeButton.addEventListener('click', (function(_this) {
          return function() {
            return _this.handleRemoveNotificationClick();
          };
        })(this));
        closeAllButton = this.element.querySelector('.close-all');
        closeAllButton.classList.add(this.getButtonClass());
        closeAllButton.addEventListener('click', (function(_this) {
          return function() {
            return _this.handleRemoveAllNotificationsClick();
          };
        })(this));
      }
      if (this.model.getType() === 'fatal') {
        return this.renderFatalError();
      } else {
        return Promise.resolve();
      }
    };

    NotificationElement.prototype.renderFatalError = function() {
      var copyReportButton, fatalContainer, fatalNotification, issueButton, packageName, promises, repoUrl;
      repoUrl = this.issue.getRepoUrl();
      packageName = this.issue.getPackageName();
      fatalContainer = this.element.querySelector('.meta');
      fatalContainer.appendChild(TemplateHelper.render(this.fatalTemplate));
      fatalNotification = this.element.querySelector('.fatal-notification');
      issueButton = fatalContainer.querySelector('.btn-issue');
      copyReportButton = fatalContainer.querySelector('.btn-copy-report');
      atom.tooltips.add(copyReportButton, {
        title: copyReportButton.getAttribute('title')
      });
      copyReportButton.addEventListener('click', (function(_this) {
        return function(e) {
          e.preventDefault();
          return _this.issue.getIssueBody().then(function(issueBody) {
            return atom.clipboard.write(issueBody);
          });
        };
      })(this));
      if ((packageName != null) && (repoUrl != null)) {
        fatalNotification.innerHTML = "The error was thrown from the <a href=\"" + repoUrl + "\">" + packageName + " package</a>. ";
      } else if (packageName != null) {
        issueButton.remove();
        fatalNotification.textContent = "The error was thrown from the " + packageName + " package. ";
      } else {
        fatalNotification.textContent = "This is likely a bug in Atom. ";
      }
      if (issueButton.parentNode != null) {
        if ((packageName != null) && (repoUrl != null)) {
          issueButton.textContent = "Create issue on the " + packageName + " package";
        } else {
          issueButton.textContent = "Create issue on atom/atom";
        }
        promises = [];
        promises.push(this.issue.findSimilarIssues());
        promises.push(UserUtilities.checkAtomUpToDate());
        if (packageName != null) {
          promises.push(UserUtilities.checkPackageUpToDate(packageName));
        }
        return Promise.all(promises).then((function(_this) {
          return function(allData) {
            var atomCheck, issue, issues, packageCheck, packagePath, ref;
            issues = allData[0], atomCheck = allData[1], packageCheck = allData[2];
            if ((issues != null ? issues.open : void 0) || (issues != null ? issues.closed : void 0)) {
              issue = issues.open || issues.closed;
              issueButton.setAttribute('href', issue.html_url);
              issueButton.textContent = "View Issue";
              fatalNotification.innerHTML += " This issue has already been reported.";
            } else if ((packageCheck != null) && !packageCheck.upToDate && !packageCheck.isCore) {
              issueButton.setAttribute('href', '#');
              issueButton.textContent = "Check for package updates";
              issueButton.addEventListener('click', function(e) {
                var command;
                e.preventDefault();
                command = 'settings-view:check-for-package-updates';
                return atom.commands.dispatch(atom.views.getView(atom.workspace), command);
              });
              fatalNotification.innerHTML += "<code>" + packageName + "</code> is out of date: " + packageCheck.installedVersion + " installed;\n" + packageCheck.latestVersion + " latest.\nUpgrading to the latest version may fix this issue.";
            } else if ((packageCheck != null) && !packageCheck.upToDate && packageCheck.isCore) {
              issueButton.remove();
              fatalNotification.innerHTML += "<br><br>\nLocally installed core Atom package <code>" + packageName + "</code> is out of date: " + packageCheck.installedVersion + " installed locally;\n" + packageCheck.versionShippedWithAtom + " included with the version of Atom you're running.\nRemoving the locally installed version may fix this issue.";
              packagePath = (ref = atom.packages.getLoadedPackage(packageName)) != null ? ref.path : void 0;
              if (fs.isSymbolicLinkSync(packagePath)) {
                fatalNotification.innerHTML += "<br><br>\nUse: <code>apm unlink " + packagePath + "</code>";
              }
            } else if ((atomCheck != null) && !atomCheck.upToDate) {
              issueButton.remove();
              fatalNotification.innerHTML += "Atom is out of date: " + atomCheck.installedVersion + " installed;\n" + atomCheck.latestVersion + " latest.\nUpgrading to the <a href='https://github.com/atom/atom/releases/tag/v" + atomCheck.latestVersion + "'>latest version</a> may fix this issue.";
            } else {
              fatalNotification.innerHTML += " You can help by creating an issue. Please explain what actions triggered this error.";
              issueButton.addEventListener('click', function(e) {
                e.preventDefault();
                issueButton.classList.add('opening');
                return _this.issue.getIssueUrlForSystem().then(function(issueUrl) {
                  shell.openExternal(issueUrl);
                  return issueButton.classList.remove('opening');
                });
              });
            }
          };
        })(this));
      } else {
        return Promise.resolve();
      }
    };

    NotificationElement.prototype.removeNotification = function() {
      this.element.classList.add('remove');
      return this.removeNotificationAfterTimeout();
    };

    NotificationElement.prototype.handleRemoveNotificationClick = function() {
      return this.model.dismiss();
    };

    NotificationElement.prototype.handleRemoveAllNotificationsClick = function() {
      var i, len, notification, notifications;
      notifications = atom.notifications.getNotifications();
      for (i = 0, len = notifications.length; i < len; i++) {
        notification = notifications[i];
        if (notification.isDismissable() && !notification.isDismissed()) {
          notification.dismiss();
        }
      }
    };

    NotificationElement.prototype.handleStackTraceToggleClick = function(e, container) {
      if (typeof e.preventDefault === "function") {
        e.preventDefault();
      }
      if (container.style.display === 'none') {
        e.currentTarget.innerHTML = '<span class="icon icon-dash"></span>Hide Stack Trace';
        return container.style.display = 'block';
      } else {
        e.currentTarget.innerHTML = '<span class="icon icon-plus"></span>Show Stack Trace';
        return container.style.display = 'none';
      }
    };

    NotificationElement.prototype.autohide = function() {
      return setTimeout((function(_this) {
        return function() {
          _this.element.classList.add('remove');
          return _this.removeNotificationAfterTimeout();
        };
      })(this), this.visibilityDuration);
    };

    NotificationElement.prototype.removeNotificationAfterTimeout = function() {
      if (this.element === document.activeElement) {
        atom.workspace.getActivePane().activate();
      }
      return setTimeout((function(_this) {
        return function() {
          return _this.element.remove();
        };
      })(this), this.animationDuration);
    };

    NotificationElement.prototype.getButtonClass = function() {
      var type;
      type = "btn-" + (this.model.getType());
      if (type === 'btn-fatal') {
        return 'btn-error';
      } else {
        return type;
      }
    };

    return NotificationElement;

  })();

  addSplitLinesToContainer = function(container, content) {
    var div, i, len, line, ref;
    if (typeof content !== 'string') {
      content = content.toString();
    }
    ref = content.split('\n');
    for (i = 0, len = ref.length; i < len; i++) {
      line = ref[i];
      div = document.createElement('div');
      div.classList.add('line');
      div.textContent = line;
      container.appendChild(div);
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
