Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

// View that renders the image of an {ImageEditor}.

var ImageEditorView = (function () {
  function ImageEditorView(editor) {
    var _this = this;

    _classCallCheck(this, ImageEditorView);

    this.editor = editor;
    this.emitter = new _atom.Emitter();
    this.disposables = new _atom.CompositeDisposable();
    this.imageSize = _fsPlus2['default'].statSync(this.editor.getPath()).size;
    this.loaded = false;
    this.mode = 'reset-zoom';
    _etch2['default'].initialize(this);

    this.refs.image.style.display = 'none';
    this.updateImageURI();

    this.disposables.add(this.editor.onDidChange(function () {
      return _this.updateImageURI();
    }));
    this.disposables.add(atom.commands.add(this.element, {
      'image-view:reload': function imageViewReload() {
        return _this.updateImageURI();
      },
      'image-view:zoom-in': function imageViewZoomIn() {
        return _this.zoomIn();
      },
      'image-view:zoom-out': function imageViewZoomOut() {
        return _this.zoomOut();
      },
      'image-view:zoom-to-fit': function imageViewZoomToFit() {
        return _this.zoomToFit();
      },
      'image-view:reset-zoom': function imageViewResetZoom() {
        return _this.resetZoom();
      },
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));

    this.refs.image.onload = function () {
      _this.refs.image.onload = null;
      _this.originalHeight = _this.refs.image.naturalHeight;
      _this.originalWidth = _this.refs.image.naturalWidth;
      _this.loaded = true;
      _this.refs.image.style.display = '';
      _this.emitter.emit('did-load');
    };

    this.disposables.add(atom.tooltips.add(this.refs.whiteTransparentBackgroundButton, { title: 'Use white transparent background' }));
    this.disposables.add(atom.tooltips.add(this.refs.blackTransparentBackgroundButton, { title: 'Use black transparent background' }));
    this.disposables.add(atom.tooltips.add(this.refs.transparentTransparentBackgroundButton, { title: 'Use transparent background' }));

    var clickHandler = function clickHandler(event) {
      event.preventDefault();
      event.stopPropagation();
      _this.changeBackground(event.target.value);
    };

    this.refs.whiteTransparentBackgroundButton.addEventListener('click', clickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.whiteTransparentBackgroundButton.removeEventListener('click', clickHandler);
    }));
    this.refs.blackTransparentBackgroundButton.addEventListener('click', clickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.blackTransparentBackgroundButton.removeEventListener('click', clickHandler);
    }));
    this.refs.transparentTransparentBackgroundButton.addEventListener('click', clickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.transparentTransparentBackgroundButton.removeEventListener('click', clickHandler);
    }));

    var zoomInClickHandler = function zoomInClickHandler() {
      _this.zoomIn();
    };
    this.refs.zoomInButton.addEventListener('click', zoomInClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.zoomInButton.removeEventListener('click', zoomInClickHandler);
    }));

    var zoomOutClickHandler = function zoomOutClickHandler() {
      _this.zoomOut();
    };
    this.refs.zoomOutButton.addEventListener('click', zoomOutClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.zoomOutButton.removeEventListener('click', zoomOutClickHandler);
    }));

    var resetZoomClickHandler = function resetZoomClickHandler() {
      _this.resetZoom();
    };
    this.refs.resetZoomButton.addEventListener('click', resetZoomClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.resetZoomButton.removeEventListener('click', resetZoomClickHandler);
    }));

    var zoomToFitClickHandler = function zoomToFitClickHandler() {
      _this.zoomToFit();
    };
    this.refs.zoomToFitButton.addEventListener('click', zoomToFitClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.zoomToFitButton.removeEventListener('click', zoomToFitClickHandler);
    }));
  }

  _createClass(ImageEditorView, [{
    key: 'onDidLoad',
    value: function onDidLoad(callback) {
      return this.emitter.on('did-load', callback);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      this.emitter.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'image-view', tabIndex: '-1' },
        _etch2['default'].dom(
          'div',
          { className: 'image-controls', ref: 'imageControls' },
          _etch2['default'].dom(
            'div',
            { className: 'image-controls-group' },
            _etch2['default'].dom(
              'a',
              { ref: 'whiteTransparentBackgroundButton', className: 'image-controls-color-white', value: 'white' },
              'white'
            ),
            _etch2['default'].dom(
              'a',
              { ref: 'blackTransparentBackgroundButton', className: 'image-controls-color-black', value: 'black' },
              'black'
            ),
            _etch2['default'].dom(
              'a',
              { ref: 'transparentTransparentBackgroundButton', className: 'image-controls-color-transparent', value: 'transparent' },
              'transparent'
            )
          ),
          _etch2['default'].dom(
            'div',
            { className: 'image-controls-group btn-group' },
            _etch2['default'].dom(
              'button',
              { className: 'btn', ref: 'zoomOutButton' },
              '-'
            ),
            _etch2['default'].dom(
              'button',
              { className: 'btn reset-zoom-button', ref: 'resetZoomButton' },
              '100%'
            ),
            _etch2['default'].dom(
              'button',
              { className: 'btn', ref: 'zoomInButton' },
              '+'
            )
          ),
          _etch2['default'].dom(
            'div',
            { className: 'image-controls-group btn-group' },
            _etch2['default'].dom(
              'button',
              { className: 'btn', ref: 'zoomToFitButton' },
              'Zoom to fit'
            )
          )
        ),
        _etch2['default'].dom(
          'div',
          { className: 'image-container', background: 'white', ref: 'imageContainer' },
          _etch2['default'].dom('img', { ref: 'image' })
        )
      );
    }
  }, {
    key: 'updateImageURI',
    value: function updateImageURI() {
      this.refs.image.src = this.editor.getEncodedURI() + '?time=' + Date.now();
    }

    // Zooms the image out by 25%.
  }, {
    key: 'zoomOut',
    value: function zoomOut() {
      this.adjustSize(0.75);
    }

    // Zooms the image in by 25%.
  }, {
    key: 'zoomIn',
    value: function zoomIn() {
      this.adjustSize(1.25);
    }

    // Zooms the image to its normal width and height.
  }, {
    key: 'resetZoom',
    value: function resetZoom() {
      if (!this.loaded || this.element.offsetHeight === 0) {
        return;
      }

      this.mode = 'reset-zoom';
      this.refs.imageContainer.classList.remove('zoom-to-fit');
      this.refs.zoomToFitButton.classList.remove('selected');
      this.refs.image.style.width = this.originalWidth + 'px';
      this.refs.image.style.height = this.originalHeight + 'px';
      this.refs.resetZoomButton.textContent = '100%';
    }

    // Zooms to fit the image, doesn't scale beyond actual size
  }, {
    key: 'zoomToFit',
    value: function zoomToFit() {
      if (!this.loaded || this.element.offsetHeight === 0) {
        return;
      }

      this.mode = 'zoom-to-fit';
      this.refs.imageContainer.classList.add('zoom-to-fit');
      this.refs.zoomToFitButton.classList.add('selected');
      this.refs.image.style.width = '';
      this.refs.image.style.height = '';
      this.refs.resetZoomButton.textContent = 'Auto';
    }

    // Adjust the size of the image by the given multiplying factor.
    //
    // factor - A {Number} to multiply against the current size.
  }, {
    key: 'adjustSize',
    value: function adjustSize(factor) {
      if (!this.loaded || this.element.offsetHeight === 0) {
        return;
      }

      if (this.mode === 'zoom-to-fit') {
        this.mode = 'zoom-manual';
        this.refs.imageContainer.classList.remove('zoom-to-fit');
        this.refs.zoomToFitButton.classList.remove('selected');
      } else if (this.mode === 'reset-zoom') {
        this.mode = 'zoom-manual';
      }

      var newWidth = this.refs.image.offsetWidth * factor;
      var newHeight = this.refs.image.offsetHeight * factor;
      var percent = Math.max(1, Math.round(newWidth / this.originalWidth * 100));

      // Switch to pixelated rendering when image is bigger than 200%
      if (newWidth > this.originalWidth * 2) {
        this.refs.image.style.imageRendering = 'pixelated';
      } else {
        this.refs.image.style.imageRendering = '';
      }

      this.refs.image.style.width = newWidth + 'px';
      this.refs.image.style.height = newHeight + 'px';
      this.refs.resetZoomButton.textContent = percent + '%';
    }

    // Changes the background color of the image view.
    //
    // color - A {String} that gets used as class name.
  }, {
    key: 'changeBackground',
    value: function changeBackground(color) {
      if (this.loaded && this.element.offsetHeight > 0 && color) {
        this.refs.imageContainer.setAttribute('background', color);
      }
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.refs.imageContainer.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.refs.imageContainer.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.refs.imageContainer.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.refs.imageContainer.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.refs.imageContainer.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.refs.imageContainer.scrollTop = this.refs.imageContainer.scrollHeight;
    }
  }]);

  return ImageEditorView;
})();

exports['default'] = ImageEditorView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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