Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atom = require('atom');

var _imageEditor = require('./image-editor');

var _imageEditor2 = _interopRequireDefault(_imageEditor);

var _bytes = require('bytes');

var _bytes2 = _interopRequireDefault(_bytes);

var ImageEditorStatusView = (function () {
  function ImageEditorStatusView(statusBar) {
    var _this = this;

    _classCallCheck(this, ImageEditorStatusView);

    this.statusBar = statusBar;
    this.disposables = new _atom.CompositeDisposable();

    this.element = document.createElement('div');
    this.element.classList.add('status-image', 'inline-block');

    this.imageSizeStatus = document.createElement('span');
    this.imageSizeStatus.classList.add('image-size');
    this.element.appendChild(this.imageSizeStatus);

    this.attach();

    this.disposables.add(atom.workspace.onDidChangeActivePaneItem(function () {
      _this.updateImageSize();
    }));
  }

  _createClass(ImageEditorStatusView, [{
    key: 'attach',
    value: function attach() {
      this.statusBarTile = this.statusBar.addLeftTile({ item: this });
      this.updateImageSize();
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.statusBarTile.destroy();
      this.disposables.dispose();
    }
  }, {
    key: 'getImageSize',
    value: function getImageSize(_ref) {
      var originalHeight = _ref.originalHeight;
      var originalWidth = _ref.originalWidth;
      var imageSize = _ref.imageSize;

      this.imageSizeStatus.textContent = originalWidth + 'x' + originalHeight + ' ' + (0, _bytes2['default'])(imageSize);
      this.imageSizeStatus.style.display = '';
    }
  }, {
    key: 'updateImageSize',
    value: function updateImageSize() {
      var _this2 = this;

      if (this.imageLoadDisposable) {
        this.imageLoadDisposable.dispose();
      }

      var editor = atom.workspace.getActivePaneItem();
      if (editor instanceof _imageEditor2['default']) {
        this.editorView = editor.view;
        if (this.editorView.loaded) {
          this.getImageSize(this.editorView);
        }

        this.imageLoadDisposable = this.editorView.onDidLoad(function () {
          if (editor === atom.workspace.getActivePaneItem()) {
            _this2.getImageSize(_this2.editorView);
          }
        });
      } else {
        this.imageSizeStatus.style.display = 'none';
      }
    }
  }]);

  return ImageEditorStatusView;
})();

exports['default'] = ImageEditorStatusView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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