'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _portal = require('./portal');

var _portal2 = _interopRequireDefault(_portal);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let Tooltip = (_temp = _class = class Tooltip extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.disposable = null;
  }

  componentWillReceiveProps(nextProps) {
    const propKeys = ['tooltips', 'title', 'html', 'className', 'placement', 'trigger', 'showDelay', 'hideDelay', 'keyBindingCommand', 'keyBindingTarget'];

    if (propKeys.some(key => this.props[key] !== nextProps[key])) {
      this.disposable && this.disposable.dispose();
      this.disposable = null;

      this.setupTooltip(nextProps);
    }
  }

  componentDidMount() {
    this.setupTooltip(this.props);
  }

  render() {
    if (this.props.children !== undefined) {
      return _react2.default.createElement(
        _portal2.default,
        { ref: c => {
            this.portal = c;
          } },
        this.props.children
      );
    } else {
      return null;
    }
  }

  componentWillUnmount() {
    this.disposable && this.disposable.dispose();
  }

  setupTooltip(props) {
    if (this.disposable) {
      return;
    }

    const options = {};
    ['title', 'html', 'placement', 'trigger', 'keyBindingCommand', 'keyBindingTarget'].forEach(key => {
      if (props[key] !== undefined) {
        options[key] = props[key];
      }
    });
    if (props.className !== undefined) {
      options.class = props.className;
    }
    if (props.showDelay !== undefined || props.hideDelay !== undefined) {
      const delayDefaults = (props.trigger === 'hover' || props.trigger === undefined) && { show: 1000, hide: 100 } || { show: 0, hide: 0 };

      options.delay = {
        show: props.showDelay !== undefined ? props.showDelay : delayDefaults.show,
        hide: props.hideDelay !== undefined ? props.hideDelay : delayDefaults.hide
      };
    }
    if (props.children !== undefined) {
      options.item = this.portal;
    }

    const target = this.getCurrentTarget(props);
    this.disposable = props.manager.add(target, options);
  }

  getCurrentTarget(props) {
    const target = props.target();
    if (target !== null && target.element !== undefined) {
      return target.element;
    } else {
      return target;
    }
  }
}, _class.propTypes = {
  manager: _propTypes2.default.object.isRequired,
  target: _propTypes2.default.func.isRequired,
  title: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.func]),
  html: _propTypes2.default.bool,
  className: _propTypes2.default.string,
  placement: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.func]),
  trigger: _propTypes2.default.oneOf(['hover', 'click', 'focus', 'manual']),
  showDelay: _propTypes2.default.number,
  hideDelay: _propTypes2.default.number,
  keyBindingCommand: _propTypes2.default.string,
  keyBindingTarget: _propTypes2.default.element,
  children: _propTypes2.default.element
}, _temp);
exports.default = Tooltip;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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