'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let SimpleTooltip = (_temp = _class = class SimpleTooltip extends _react2.default.Component {

  componentDidMount() {
    this.disposable = this.props.tooltips.add(_reactDom2.default.findDOMNode(this.child), { title: () => this.props.title });
  }

  componentWillUnmount() {
    this.disposable.dispose();
  }

  componentDidUpdate(prevProps) {
    if (prevProps.title !== this.props.title) {
      this.disposable.dispose();
      this.disposable = this.props.tooltips.add(_reactDom2.default.findDOMNode(this.child), { title: () => this.props.title });
    }
  }

  render() {
    const child = _react2.default.Children.only(this.props.children);
    return _react2.default.cloneElement(child, { ref: e => {
        this.child = e;
      } });
  }
}, _class.propTypes = {
  tooltips: _propTypes2.default.object.isRequired,
  children: _propTypes2.default.node.isRequired,
  title: _propTypes2.default.string.isRequired
}, _temp);
exports.default = SimpleTooltip;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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