'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _propTypes3 = require('../prop-types');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let PushPullMenuView = (_class = (_temp = _class2 = class PushPullMenuView extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.state = {
      errorMessage: ''
    };
  }

  render() {
    const errorMessage = this.getErrorMessage();
    const fetchDisabled = !this.props.currentRemote.isPresent() || this.props.inProgress;
    const pullDisabled = !this.props.currentRemote.isPresent() || this.props.currentBranch.isDetached() || this.props.inProgress;
    const pushDisabled = this.props.currentBranch.isDetached() || !this.props.currentRemote.isPresent() && !this.props.originExists || this.props.inProgress;

    return _react2.default.createElement(
      'div',
      { className: 'github-PushPullMenuView' + (this.props.inProgress ? ' in-progress' : '') },
      _react2.default.createElement(
        'div',
        { className: 'github-PushPullMenuView-selector' },
        _react2.default.createElement('span', { className: 'github-PushPullMenuView-item icon icon-mark-github', onClick: this.handleIconClick }),
        _react2.default.createElement(
          'button',
          { className: 'github-PushPullMenuView-item btn', onClick: this.fetch, disabled: fetchDisabled },
          'Fetch'
        ),
        _react2.default.createElement(
          'div',
          { className: 'github-PushPullMenuView-item is-flexible btn-group' },
          _react2.default.createElement(
            'button',
            { className: 'btn github-PushPullMenuView-pull', onClick: this.pull, disabled: pullDisabled },
            _react2.default.createElement('span', { className: 'icon icon-arrow-down' }),
            _react2.default.createElement(
              'span',
              null,
              'Pull ',
              this.props.behindCount ? `(${this.props.behindCount})` : ''
            )
          ),
          _react2.default.createElement(
            'button',
            { className: 'btn github-PushPullMenuView-push', onClick: this.push, disabled: pushDisabled },
            _react2.default.createElement('span', { className: 'icon icon-arrow-up' }),
            _react2.default.createElement(
              'span',
              null,
              'Push ',
              this.props.aheadCount ? `(${this.props.aheadCount})` : ''
            )
          )
        )
      ),
      _react2.default.createElement(
        'div',
        { className: 'github-PushPullMenuView-message' },
        errorMessage
      )
    );
  }

  getErrorMessage() {
    if (this.state.errorMessage !== '') {
      return this.state.errorMessage;
    }

    if (this.props.currentBranch.isDetached()) {
      return 'Note: you are not on a branch. Please create one if you wish to push your work anywhere.';
    }

    if (!this.props.currentRemote.isPresent()) {
      if (this.props.originExists) {
        return `Note: No remote detected for branch ${this.props.currentBranch.getName()}. ` + 'Pushing will set up a remote tracking branch on remote repo "origin"';
      } else {
        return `Note: No remote detected for branch ${this.props.currentBranch.getName()}. ` + 'Cannot push because there is no remote named "origin" for which to create a remote tracking branch.';
      }
    }

    return '';
  }

  handleIconClick(evt) {
    if (evt.shiftKey) {
      this.props.onMarkSpecialClick();
    }
  }

  fetch() {
    return this.props.fetch();
  }

  pull() {
    return this.props.pull();
  }

  push(e) {
    return this.props.push({ force: e.metaKey || e.ctrlKey, setUpstream: !this.props.currentRemote.isPresent() });
  }
}, _class2.propTypes = {
  currentBranch: _propTypes3.BranchPropType.isRequired,
  currentRemote: _propTypes3.RemotePropType.isRequired,
  inProgress: _propTypes2.default.bool,
  aheadCount: _propTypes2.default.number,
  behindCount: _propTypes2.default.number,
  onMarkSpecialClick: _propTypes2.default.func.isRequired,
  fetch: _propTypes2.default.func.isRequired,
  push: _propTypes2.default.func.isRequired,
  pull: _propTypes2.default.func.isRequired,
  originExists: _propTypes2.default.bool.isRequired
}, _class2.defaultProps = {
  inProgress: false,
  onMarkSpecialClick: () => {}
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'handleIconClick', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleIconClick'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'fetch', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'fetch'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'pull', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'pull'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'push', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'push'), _class.prototype)), _class);
exports.default = PushPullMenuView;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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