'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _portal = require('./portal');

var _portal2 = _interopRequireDefault(_portal);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * `Panel` renders a React component into an Atom panel. Specify the
 * location via the `location` prop, and any additional options to the
 * `addXPanel` method in the `options` prop.
 *
 * You may pass a `getItem` function that takes an object with `portal` and
 * `subtree` properties. `getItem` should return an item to be added to the
 * Panel. `portal` is an instance of the Portal component, and `subtree` is the
 * rendered subtree component built from the `children` prop. The default
 * implementation simply returns the Portal instance, which contains a
 * `getElement` method (to be compatible with Atom's view system).
 *
 * You can get the underlying Atom panel via `getPanel()`, but you should
 * consider controlling the panel via React and the Panel component instead.
 */
let Panel = (_temp = _class = class Panel extends _react2.default.Component {

  componentDidMount() {
    this.setupPanel();
  }

  componentWillReceiveProps(newProps) {
    if (this.didCloseItem) {
      // eslint-disable-next-line no-console
      console.error('Unexpected update in `Panel`: the contained panel has been destroyed');
    }

    if (this.panel && this.props.visible !== newProps.visible) {
      this.panel[newProps.visible ? 'show' : 'hide']();
    }
  }

  render() {
    return _react2.default.createElement(
      _portal2.default,
      { ref: c => {
          this.portal = c;
        } },
      this.props.children
    );
  }

  setupPanel() {
    if (this.panel) {
      return;
    }

    // "left" => "Left"
    const location = this.props.location.substr(0, 1).toUpperCase() + this.props.location.substr(1);
    const methodName = `add${location}Panel`;

    const item = this.props.getItem({ portal: this.portal, subtree: this.portal.getRenderedSubtree() });
    const options = _extends({}, this.props.options, { visible: this.props.visible, item });
    this.panel = this.props.workspace[methodName](options);
    this.subscriptions = this.panel.onDidDestroy(() => {
      this.didCloseItem = true;
      this.props.onDidClosePanel(this.panel);
    });
  }

  componentWillUnmount() {
    this.subscriptions && this.subscriptions.dispose();
    if (this.panel) {
      this.panel.destroy();
    }
  }

  getPanel() {
    return this.panel;
  }
}, _class.propTypes = {
  workspace: _propTypes2.default.object.isRequired,
  location: _propTypes2.default.oneOf(['top', 'bottom', 'left', 'right', 'header', 'footer', 'modal']).isRequired,
  children: _propTypes2.default.element.isRequired,
  getItem: _propTypes2.default.func,
  options: _propTypes2.default.object,
  onDidClosePanel: _propTypes2.default.func,
  visible: _propTypes2.default.bool
}, _class.defaultProps = {
  options: {},
  getItem: (_ref) => {
    let portal = _ref.portal,
        subtree = _ref.subtree;
    return portal;
  },
  onDidClosePanel: panel => {},
  visible: true
}, _temp);
exports.default = Panel;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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