'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _eventKit = require('event-kit');

var _commands = require('./commands');

var _commands2 = _interopRequireDefault(_commands);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

const ISSUEISH_URL_REGEX = /^(?:https?:\/\/)?github.com\/([^/]+)\/([^/]+)\/(?:issues|pull)\/(\d+)/;

let OpenIssueishDialog = (_class = (_temp = _class2 = class OpenIssueishDialog extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.state = {
      cloneDisabled: false
    };

    this.subs = new _eventKit.CompositeDisposable();
  }

  componentDidMount() {
    if (this.issueishUrlElement) {
      setTimeout(() => this.issueishUrlElement.focus());
    }
  }

  render() {
    return this.renderDialog();
  }

  renderDialog() {
    return _react2.default.createElement(
      'div',
      { className: 'github-Dialog github-OpenIssueish modal' },
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: '.github-OpenIssueish' },
        _react2.default.createElement(_commands.Command, { command: 'core:cancel', callback: this.cancel }),
        _react2.default.createElement(_commands.Command, { command: 'core:confirm', callback: this.accept })
      ),
      _react2.default.createElement(
        'main',
        { className: 'github-DialogInputs' },
        _react2.default.createElement(
          'label',
          { className: 'github-DialogLabel github-IssueishUrl' },
          'Issue or pull request URL:',
          _react2.default.createElement('atom-text-editor', { mini: true, ref: this.editorRefs('issueishUrl'), tabIndex: '1' })
        ),
        this.state.error && _react2.default.createElement(
          'span',
          { className: 'error' },
          this.state.error
        )
      ),
      _react2.default.createElement(
        'div',
        { className: 'github-DialogButtons' },
        _react2.default.createElement(
          'button',
          { className: 'btn github-CancelButton', onClick: this.cancel, tabIndex: '3' },
          'Cancel'
        ),
        _react2.default.createElement(
          'button',
          {
            className: 'btn btn-primary icon icon-git-pull-request',
            onClick: this.accept,
            disabled: this.getIssueishUrl().length === 0,
            tabIndex: '2' },
          'Open Issue or Pull Request'
        )
      )
    );
  }

  accept() {
    if (this.getIssueishUrl().length === 0) {
      return;
    }

    const parsed = this.parseUrl();
    if (!parsed) {
      this.setState({
        error: 'That is not a valid issue or pull request URL.'
      });
      return;
    }
    const repoOwner = parsed.repoOwner,
          repoName = parsed.repoName,
          issueishNumber = parsed.issueishNumber;


    this.props.didAccept({ repoOwner, repoName, issueishNumber });
  }

  cancel() {
    this.props.didCancel();
  }

  editorRefs(baseName) {
    const elementName = `${baseName}Element`;
    const modelName = `${baseName}Editor`;
    const subName = `${baseName}Subs`;
    const changeMethodName = `didChange${baseName[0].toUpperCase()}${baseName.substring(1)}`;

    return element => {
      if (!element) {
        return;
      }

      this[elementName] = element;
      const editor = element.getModel();
      if (this[modelName] !== editor) {
        this[modelName] = editor;

        if (this[subName]) {
          this[subName].dispose();
          this.subs.remove(this[subName]);
        }

        this[subName] = editor.onDidChange(this[changeMethodName]);
        this.subs.add(this[subName]);
      }
    };
  }

  didChangeIssueishUrl() {
    this.setState({ error: null });
  }

  parseUrl() {
    const url = this.getIssueishUrl();
    const matches = url.match(ISSUEISH_URL_REGEX);
    if (!matches) {
      return false;
    }

    var _matches = _slicedToArray(matches, 4);

    const _full = _matches[0],
          repoOwner = _matches[1],
          repoName = _matches[2],
          issueishNumber = _matches[3]; // eslint-disable-line no-unused-vars

    return { repoOwner, repoName, issueishNumber };
  }

  getIssueishUrl() {
    return this.issueishUrlEditor ? this.issueishUrlEditor.getText() : '';
  }
}, _class2.propTypes = {
  commandRegistry: _propTypes2.default.object.isRequired,
  didAccept: _propTypes2.default.func,
  didCancel: _propTypes2.default.func
}, _class2.defaultProps = {
  didAccept: () => {},
  didCancel: () => {}
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'accept', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'accept'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'cancel', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'cancel'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'editorRefs', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'editorRefs'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'didChangeIssueishUrl', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'didChangeIssueishUrl'), _class.prototype)), _class);
exports.default = OpenIssueishDialog;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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