'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; } /** @jsx etch.dom */
/* eslint react/no-unknown-property: "off" */

let ListView = class ListView {
  constructor(props) {
    this.props = props;
    _etch2.default.initialize(this);
  }

  didClickItem(e, item) {
    if (e.detail === 1) {
      if (this.props.didSelectItem) {
        this.props.didSelectItem(item);
        return _etch2.default.update(this);
      }
    } else if (e.detail === 2) {
      if (this.props.didConfirmItem) {
        this.props.didConfirmItem(item);
      }
    }
    return null;
  }

  update(props) {
    this.props = props;
    return _etch2.default.update(this);
  }

  render() {
    // eslint-disable-next-line no-unused-vars
    var _props = this.props;

    const ref = _props.ref,
          didSelectItem = _props.didSelectItem,
          didConfirmItem = _props.didConfirmItem,
          items = _props.items,
          selectedItems = _props.selectedItems,
          renderItem = _props.renderItem,
          others = _objectWithoutProperties(_props, ['ref', 'didSelectItem', 'didConfirmItem', 'items', 'selectedItems', 'renderItem']);

    return _etch2.default.dom(
      'div',
      others,
      items.map((item, index) => renderItem(item, selectedItems.has(item), e => this.didClickItem(e, item)))
    );
  }

  destroy() {
    _etch2.default.destroy(this);
  }
};
exports.default = ListView;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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