'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let GithubLoginView = (_class = (_temp = _class2 = class GithubLoginView extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);
    this.state = {
      loggingIn: false,
      token: ''
    };
  }

  render() {
    let subview;
    if (this.state.loggingIn) {
      subview = this.renderTokenInput();
    } else {
      subview = this.renderLogin();
    }

    return _react2.default.createElement(
      'div',
      { className: 'github-GithubLoginView' },
      subview
    );
  }

  renderLogin() {
    return _react2.default.createElement(
      'div',
      { className: 'github-GithubLoginView-Subview' },
      this.props.children,
      _react2.default.createElement(
        'button',
        { onClick: this.handleLoginClick, className: 'btn btn-primary btn-lg icon icon-octoface' },
        'Login'
      )
    );
  }

  renderTokenInput() {
    return _react2.default.createElement(
      'form',
      { className: 'github-GithubLoginView-Subview', onSubmit: this.handleSubmitToken },
      _react2.default.createElement(
        'p',
        null,
        'Step 1: Visit ',
        _react2.default.createElement(
          'a',
          { href: 'https://github.atom.io/login' },
          'github.atom.io/login'
        ),
        ' to generate an authentication token.'
      ),
      _react2.default.createElement(
        'p',
        null,
        'Step 2: Enter the token below:'
      ),
      _react2.default.createElement('input', {
        type: 'text',
        className: 'input-text native-key-bindings',
        placeholder: 'Enter your token...',
        value: this.state.token,
        onChange: this.handleTokenChange
      }),
      _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
          'button',
          { type: 'button', onClick: this.handleCancelTokenClick, className: 'btn icon inline-block-tight' },
          'Cancel'
        ),
        _react2.default.createElement('input', {
          type: 'submit',
          value: 'Login',
          onClick: this.handleSubmitTokenClick, className: 'btn btn-primary icon icon-check inline-block-tight'
        })
      )
    );
  }

  handleLoginClick() {
    this.setState({ loggingIn: true });
  }

  handleCancelTokenClick(e) {
    e.preventDefault();
    this.setState({ loggingIn: false });
  }

  handleSubmitTokenClick(e) {
    e.preventDefault();
    this.handleSubmitToken();
  }

  handleSubmitToken() {
    this.props.onLogin(this.state.token);
  }

  handleTokenChange(e) {
    this.setState({ token: e.target.value });
  }
}, _class2.propTypes = {
  children: _propTypes2.default.node,
  onLogin: _propTypes2.default.func
}, _class2.defaultProps = {
  children: _react2.default.createElement(
    'p',
    null,
    'Log in to GitHub to access PR information and more!'
  ),
  onLogin: token => {}
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'handleLoginClick', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleLoginClick'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'handleCancelTokenClick', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleCancelTokenClick'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'handleSubmitTokenClick', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleSubmitTokenClick'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'handleSubmitToken', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleSubmitToken'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'handleTokenChange', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleTokenChange'), _class.prototype)), _class);
exports.default = GithubLoginView;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImdpdGh1Yi1sb2dpbi12aWV3LmpzIl0sIm5hbWVzIjpbIkdpdGh1YkxvZ2luVmlldyIsIkNvbXBvbmVudCIsImNvbnN0cnVjdG9yIiwicHJvcHMiLCJjb250ZXh0Iiwic3RhdGUiLCJsb2dnaW5nSW4iLCJ0b2tlbiIsInJlbmRlciIsInN1YnZpZXciLCJyZW5kZXJUb2tlbklucHV0IiwicmVuZGVyTG9naW4iLCJjaGlsZHJlbiIsImhhbmRsZUxvZ2luQ2xpY2siLCJoYW5kbGVTdWJtaXRUb2tlbiIsImhhbmRsZVRva2VuQ2hhbmdlIiwiaGFuZGxlQ2FuY2VsVG9rZW5DbGljayIsImhhbmRsZVN1Ym1pdFRva2VuQ2xpY2siLCJzZXRTdGF0ZSIsImUiLCJwcmV2ZW50RGVmYXVsdCIsIm9uTG9naW4iLCJ0YXJnZXQiLCJ2YWx1ZSIsInByb3BUeXBlcyIsIm5vZGUiLCJmdW5jIiwiZGVmYXVsdFByb3BzIl0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7QUFBQTs7OztBQUNBOzs7O0FBQ0E7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztJQUVxQkEsZSxnQ0FBTixNQUFNQSxlQUFOLFNBQThCLGdCQUFNQyxTQUFwQyxDQUE4Qzs7QUFXM0RDLGNBQVlDLEtBQVosRUFBbUJDLE9BQW5CLEVBQTRCO0FBQzFCLFVBQU1ELEtBQU4sRUFBYUMsT0FBYjtBQUNBLFNBQUtDLEtBQUwsR0FBYTtBQUNYQyxpQkFBVyxLQURBO0FBRVhDLGFBQU87QUFGSSxLQUFiO0FBSUQ7O0FBRURDLFdBQVM7QUFDUCxRQUFJQyxPQUFKO0FBQ0EsUUFBSSxLQUFLSixLQUFMLENBQVdDLFNBQWYsRUFBMEI7QUFDeEJHLGdCQUFVLEtBQUtDLGdCQUFMLEVBQVY7QUFDRCxLQUZELE1BRU87QUFDTEQsZ0JBQVUsS0FBS0UsV0FBTCxFQUFWO0FBQ0Q7O0FBRUQsV0FDRTtBQUFBO0FBQUEsUUFBSyxXQUFVLHdCQUFmO0FBQ0dGO0FBREgsS0FERjtBQUtEOztBQUVERSxnQkFBYztBQUNaLFdBQ0U7QUFBQTtBQUFBLFFBQUssV0FBVSxnQ0FBZjtBQUNHLFdBQUtSLEtBQUwsQ0FBV1MsUUFEZDtBQUVFO0FBQUE7QUFBQSxVQUFRLFNBQVMsS0FBS0MsZ0JBQXRCLEVBQXdDLFdBQVUsMkNBQWxEO0FBQUE7QUFBQTtBQUZGLEtBREY7QUFRRDs7QUFFREgscUJBQW1CO0FBQ2pCLFdBQ0U7QUFBQTtBQUFBLFFBQU0sV0FBVSxnQ0FBaEIsRUFBaUQsVUFBVSxLQUFLSSxpQkFBaEU7QUFDRTtBQUFBO0FBQUE7QUFBQTtBQUNnQjtBQUFBO0FBQUEsWUFBRyxNQUFLLDhCQUFSO0FBQUE7QUFBQSxTQURoQjtBQUFBO0FBQUEsT0FERjtBQUtFO0FBQUE7QUFBQTtBQUFBO0FBQUEsT0FMRjtBQVFFO0FBQ0UsY0FBSyxNQURQO0FBRUUsbUJBQVUsZ0NBRlo7QUFHRSxxQkFBWSxxQkFIZDtBQUlFLGVBQU8sS0FBS1QsS0FBTCxDQUFXRSxLQUpwQjtBQUtFLGtCQUFVLEtBQUtRO0FBTGpCLFFBUkY7QUFlRTtBQUFBO0FBQUE7QUFDRTtBQUFBO0FBQUEsWUFBUSxNQUFLLFFBQWIsRUFBc0IsU0FBUyxLQUFLQyxzQkFBcEMsRUFBNEQsV0FBVSw2QkFBdEU7QUFBQTtBQUFBLFNBREY7QUFJRTtBQUNFLGdCQUFLLFFBRFA7QUFFRSxpQkFBTSxPQUZSO0FBR0UsbUJBQVMsS0FBS0Msc0JBSGhCLEVBR3dDLFdBQVU7QUFIbEQ7QUFKRjtBQWZGLEtBREY7QUE0QkQ7O0FBR0RKLHFCQUFtQjtBQUNqQixTQUFLSyxRQUFMLENBQWMsRUFBQ1osV0FBVyxJQUFaLEVBQWQ7QUFDRDs7QUFHRFUseUJBQXVCRyxDQUF2QixFQUEwQjtBQUN4QkEsTUFBRUMsY0FBRjtBQUNBLFNBQUtGLFFBQUwsQ0FBYyxFQUFDWixXQUFXLEtBQVosRUFBZDtBQUNEOztBQUdEVyx5QkFBdUJFLENBQXZCLEVBQTBCO0FBQ3hCQSxNQUFFQyxjQUFGO0FBQ0EsU0FBS04saUJBQUw7QUFDRDs7QUFHREEsc0JBQW9CO0FBQ2xCLFNBQUtYLEtBQUwsQ0FBV2tCLE9BQVgsQ0FBbUIsS0FBS2hCLEtBQUwsQ0FBV0UsS0FBOUI7QUFDRDs7QUFHRFEsb0JBQWtCSSxDQUFsQixFQUFxQjtBQUNuQixTQUFLRCxRQUFMLENBQWMsRUFBQ1gsT0FBT1ksRUFBRUcsTUFBRixDQUFTQyxLQUFqQixFQUFkO0FBQ0Q7QUFyRzBELEMsVUFDcERDLFMsR0FBWTtBQUNqQlosWUFBVSxvQkFBVWEsSUFESDtBQUVqQkosV0FBUyxvQkFBVUs7QUFGRixDLFVBS1pDLFksR0FBZTtBQUNwQmYsWUFBVTtBQUFBO0FBQUE7QUFBQTtBQUFBLEdBRFU7QUFFcEJTLFdBQVNkLFNBQVMsQ0FBRTtBQUZBLEM7a0JBTkhQLGUiLCJmaWxlIjoiZ2l0aHViLWxvZ2luLXZpZXcuanMiLCJzb3VyY2VSb290IjoiL2hvbWUvYW5kcmVpL2F0b20tMS4xOS4yL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWFjdCBmcm9tICdyZWFjdCc7XG5pbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0IHthdXRvYmluZH0gZnJvbSAnY29yZS1kZWNvcmF0b3JzJztcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgR2l0aHViTG9naW5WaWV3IGV4dGVuZHMgUmVhY3QuQ29tcG9uZW50IHtcbiAgc3RhdGljIHByb3BUeXBlcyA9IHtcbiAgICBjaGlsZHJlbjogUHJvcFR5cGVzLm5vZGUsXG4gICAgb25Mb2dpbjogUHJvcFR5cGVzLmZ1bmMsXG4gIH1cblxuICBzdGF0aWMgZGVmYXVsdFByb3BzID0ge1xuICAgIGNoaWxkcmVuOiA8cD5Mb2cgaW4gdG8gR2l0SHViIHRvIGFjY2VzcyBQUiBpbmZvcm1hdGlvbiBhbmQgbW9yZSE8L3A+LFxuICAgIG9uTG9naW46IHRva2VuID0+IHt9LFxuICB9XG5cbiAgY29uc3RydWN0b3IocHJvcHMsIGNvbnRleHQpIHtcbiAgICBzdXBlcihwcm9wcywgY29udGV4dCk7XG4gICAgdGhpcy5zdGF0ZSA9IHtcbiAgICAgIGxvZ2dpbmdJbjogZmFsc2UsXG4gICAgICB0b2tlbjogJycsXG4gICAgfTtcbiAgfVxuXG4gIHJlbmRlcigpIHtcbiAgICBsZXQgc3VidmlldztcbiAgICBpZiAodGhpcy5zdGF0ZS5sb2dnaW5nSW4pIHtcbiAgICAgIHN1YnZpZXcgPSB0aGlzLnJlbmRlclRva2VuSW5wdXQoKTtcbiAgICB9IGVsc2Uge1xuICAgICAgc3VidmlldyA9IHRoaXMucmVuZGVyTG9naW4oKTtcbiAgICB9XG5cbiAgICByZXR1cm4gKFxuICAgICAgPGRpdiBjbGFzc05hbWU9XCJnaXRodWItR2l0aHViTG9naW5WaWV3XCI+XG4gICAgICAgIHtzdWJ2aWV3fVxuICAgICAgPC9kaXY+XG4gICAgKTtcbiAgfVxuXG4gIHJlbmRlckxvZ2luKCkge1xuICAgIHJldHVybiAoXG4gICAgICA8ZGl2IGNsYXNzTmFtZT1cImdpdGh1Yi1HaXRodWJMb2dpblZpZXctU3Vidmlld1wiPlxuICAgICAgICB7dGhpcy5wcm9wcy5jaGlsZHJlbn1cbiAgICAgICAgPGJ1dHRvbiBvbkNsaWNrPXt0aGlzLmhhbmRsZUxvZ2luQ2xpY2t9IGNsYXNzTmFtZT1cImJ0biBidG4tcHJpbWFyeSBidG4tbGcgaWNvbiBpY29uLW9jdG9mYWNlXCI+XG4gICAgICAgICAgTG9naW5cbiAgICAgICAgPC9idXR0b24+XG4gICAgICA8L2Rpdj5cbiAgICApO1xuICB9XG5cbiAgcmVuZGVyVG9rZW5JbnB1dCgpIHtcbiAgICByZXR1cm4gKFxuICAgICAgPGZvcm0gY2xhc3NOYW1lPVwiZ2l0aHViLUdpdGh1YkxvZ2luVmlldy1TdWJ2aWV3XCIgb25TdWJtaXQ9e3RoaXMuaGFuZGxlU3VibWl0VG9rZW59PlxuICAgICAgICA8cD5cbiAgICAgICAgICBTdGVwIDE6IFZpc2l0IDxhIGhyZWY9XCJodHRwczovL2dpdGh1Yi5hdG9tLmlvL2xvZ2luXCI+Z2l0aHViLmF0b20uaW8vbG9naW48L2E+IHRvIGdlbmVyYXRlXG4gICAgICAgICAgYW4gYXV0aGVudGljYXRpb24gdG9rZW4uXG4gICAgICAgIDwvcD5cbiAgICAgICAgPHA+XG4gICAgICAgICAgU3RlcCAyOiBFbnRlciB0aGUgdG9rZW4gYmVsb3c6XG4gICAgICAgIDwvcD5cbiAgICAgICAgPGlucHV0XG4gICAgICAgICAgdHlwZT1cInRleHRcIlxuICAgICAgICAgIGNsYXNzTmFtZT1cImlucHV0LXRleHQgbmF0aXZlLWtleS1iaW5kaW5nc1wiXG4gICAgICAgICAgcGxhY2Vob2xkZXI9XCJFbnRlciB5b3VyIHRva2VuLi4uXCJcbiAgICAgICAgICB2YWx1ZT17dGhpcy5zdGF0ZS50b2tlbn1cbiAgICAgICAgICBvbkNoYW5nZT17dGhpcy5oYW5kbGVUb2tlbkNoYW5nZX1cbiAgICAgICAgLz5cbiAgICAgICAgPGRpdj5cbiAgICAgICAgICA8YnV0dG9uIHR5cGU9XCJidXR0b25cIiBvbkNsaWNrPXt0aGlzLmhhbmRsZUNhbmNlbFRva2VuQ2xpY2t9IGNsYXNzTmFtZT1cImJ0biBpY29uIGlubGluZS1ibG9jay10aWdodFwiPlxuICAgICAgICAgICAgQ2FuY2VsXG4gICAgICAgICAgPC9idXR0b24+XG4gICAgICAgICAgPGlucHV0XG4gICAgICAgICAgICB0eXBlPVwic3VibWl0XCJcbiAgICAgICAgICAgIHZhbHVlPVwiTG9naW5cIlxuICAgICAgICAgICAgb25DbGljaz17dGhpcy5oYW5kbGVTdWJtaXRUb2tlbkNsaWNrfSBjbGFzc05hbWU9XCJidG4gYnRuLXByaW1hcnkgaWNvbiBpY29uLWNoZWNrIGlubGluZS1ibG9jay10aWdodFwiXG4gICAgICAgICAgLz5cbiAgICAgICAgPC9kaXY+XG4gICAgICA8L2Zvcm0+XG4gICAgKTtcbiAgfVxuXG4gIEBhdXRvYmluZFxuICBoYW5kbGVMb2dpbkNsaWNrKCkge1xuICAgIHRoaXMuc2V0U3RhdGUoe2xvZ2dpbmdJbjogdHJ1ZX0pO1xuICB9XG5cbiAgQGF1dG9iaW5kXG4gIGhhbmRsZUNhbmNlbFRva2VuQ2xpY2soZSkge1xuICAgIGUucHJldmVudERlZmF1bHQoKTtcbiAgICB0aGlzLnNldFN0YXRlKHtsb2dnaW5nSW46IGZhbHNlfSk7XG4gIH1cblxuICBAYXV0b2JpbmRcbiAgaGFuZGxlU3VibWl0VG9rZW5DbGljayhlKSB7XG4gICAgZS5wcmV2ZW50RGVmYXVsdCgpO1xuICAgIHRoaXMuaGFuZGxlU3VibWl0VG9rZW4oKTtcbiAgfVxuXG4gIEBhdXRvYmluZFxuICBoYW5kbGVTdWJtaXRUb2tlbigpIHtcbiAgICB0aGlzLnByb3BzLm9uTG9naW4odGhpcy5zdGF0ZS50b2tlbik7XG4gIH1cblxuICBAYXV0b2JpbmRcbiAgaGFuZGxlVG9rZW5DaGFuZ2UoZSkge1xuICAgIHRoaXMuc2V0U3RhdGUoe3Rva2VuOiBlLnRhcmdldC52YWx1ZX0pO1xuICB9XG59XG4iXX0=