'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _desc, _value, _class, _class2, _temp;

var _eventKit = require('event-kit');

var _electron = require('electron');

var _url = require('url');

var _url2 = _interopRequireDefault(_url);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _issueishPaneItem = require('../atom-items/issueish-pane-item');

var _issueishPaneItem2 = _interopRequireDefault(_issueishPaneItem);

var _userMentionTooltipItem = require('../atom-items/user-mention-tooltip-item');

var _userMentionTooltipItem2 = _interopRequireDefault(_userMentionTooltipItem);

var _issueishTooltipItem = require('../atom-items/issueish-tooltip-item');

var _issueishTooltipItem2 = _interopRequireDefault(_issueishTooltipItem);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let GithubDotcomMarkdown = (_class = (_temp = _class2 = class GithubDotcomMarkdown extends _react2.default.Component {

  componentDidMount() {
    this.commandSubscriptions = atom.commands.add(_reactDom2.default.findDOMNode(this), {
      'github:open-link-in-new-tab': this.openLinkInNewTab,
      'github:open-link-in-browser': this.openLinkInBrowser,
      'github:open-link-in-this-tab': this.openLinkInThisTab
    });
    this.checkPropValidity();
    this.setupComponentHandlers();
    this.setupTooltipHandlers();
  }

  componentDidUpdate() {
    this.checkPropValidity();
    this.setupTooltipHandlers();
  }

  checkPropValidity() {
    if (this.props.html !== undefined && this.props.markdown !== undefined) {
      // eslint-disable-next-line no-console
      console.error('Only one of `html` or `markdown` may be provided to `GithubDotcomMarkdown`');
    }
  }

  setupComponentHandlers() {
    this.component.addEventListener('click', this.handleClick);
    this.componentHandlers = new _eventKit.Disposable(() => {
      this.component.removeEventListener('click', this.handleClick);
    });
  }

  setupTooltipHandlers() {
    if (this.tooltipSubscriptions) {
      this.tooltipSubscriptions.dispose();
    }

    this.tooltipSubscriptions = new _eventKit.CompositeDisposable();
    this.component.querySelectorAll('.user-mention').forEach(node => {
      const item = new _userMentionTooltipItem2.default(node.textContent, this.context.relayEnvironment);
      this.tooltipSubscriptions.add(atom.tooltips.add(node, {
        trigger: 'hover',
        delay: 0,
        item
      }));
      this.tooltipSubscriptions.add(new _eventKit.Disposable(() => item.destroy()));
    });
    this.component.querySelectorAll('.issue-link').forEach(node => {
      const item = new _issueishTooltipItem2.default(node.getAttribute('href'), this.context.relayEnvironment);
      this.tooltipSubscriptions.add(atom.tooltips.add(node, {
        trigger: 'hover',
        delay: 0,
        item
      }));
      this.tooltipSubscriptions.add(new _eventKit.Disposable(() => item.destroy()));
    });
  }

  componentWillUnmount() {
    this.commandSubscriptions.dispose();
    this.componentHandlers.dispose();
    this.tooltipSubscriptions && this.tooltipSubscriptions.dispose();
  }

  render() {
    var _props = this.props;
    const html = _props.html,
          markdown = _props.markdown;

    const renderedHtml = html !== undefined ? html : this.markdownToHtml(markdown);
    return _react2.default.createElement('div', {
      className: 'github-DotComMarkdownHtml',
      ref: c => {
        this.component = c;
      },
      dangerouslySetInnerHTML: { __html: renderedHtml }
    });
  }

  markdownToHtml() {
    let markdown = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';

    return 'WARNING: cannot yet convert markdown to HTML 😅';
  }

  handleClick(event) {
    if (event.target.classList.contains('issue-link')) {
      const uri = this.getAtomUriForGithubUrl(event.target.dataset.url);
      if (uri && !event.shiftKey) {
        // Open in browser if shift key held
        this.openInNewTab(uri, { activate: !(event.metaKey || event.ctrlKey) });
        event.preventDefault();
        event.stopPropagation();
      }
    }
  }

  openLinkInNewTab(event) {
    const uri = this.getAtomUriForGithubUrl(event.target.dataset.url);
    if (uri) {
      this.openInNewTab(uri);
    }
  }

  openLinkInThisTab(event) {
    var _getDataFromGithubUrl = this.getDataFromGithubUrl(event.target.dataset.url);

    const repoOwner = _getDataFromGithubUrl.repoOwner,
          repoName = _getDataFromGithubUrl.repoName,
          issueishNumber = _getDataFromGithubUrl.issueishNumber;

    this.props.switchToIssueish(repoOwner, repoName, issueishNumber);
  }

  openLinkInBrowser(event) {
    const href = event.target.getAttribute('href');
    _electron.shell.openExternal(href);
  }

  getDataFromGithubUrl(githubUrl) {
    var _url$parse = _url2.default.parse(githubUrl);

    const hostname = _url$parse.hostname,
          pathname = _url$parse.pathname;

    var _pathname$split$filte = pathname.split('/').filter(s => s),
        _pathname$split$filte2 = _slicedToArray(_pathname$split$filte, 4);

    const repoOwner = _pathname$split$filte2[0],
          repoName = _pathname$split$filte2[1],
          type = _pathname$split$filte2[2],
          issueishNumber = _pathname$split$filte2[3];

    return { hostname, repoOwner, repoName, type, issueishNumber: parseInt(issueishNumber, 10) };
  }

  getUriForData(_ref) {
    let hostname = _ref.hostname,
        repoOwner = _ref.repoOwner,
        repoName = _ref.repoName,
        type = _ref.type,
        issueishNumber = _ref.issueishNumber;

    if (hostname !== 'github.com' || !['pull', 'issues'].includes(type) || !issueishNumber || isNaN(issueishNumber)) {
      return null;
    } else {
      return _url2.default.format({
        slashes: true,
        protocol: 'atom-github:',
        hostname: 'issueish',
        pathname: `/https://api.github.com/${repoOwner}/${repoName}/${issueishNumber}`
      });
    }
  }

  getAtomUriForGithubUrl(githubUrl) {
    return this.getUriForData(this.getDataFromGithubUrl(githubUrl));
  }

  openInNewTab(uri) {
    var _ref2 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : { activate: true };

    let activate = _ref2.activate;

    if (activate) {
      atom.workspace.open(uri, { activateItem: activate });
    } else {
      // TODO: use workspace.open once https://github.com/atom/atom/issues/14005 is fixed
      const item = _issueishPaneItem2.default.opener(uri);
      atom.workspace.getActivePane().addItem(item);
    }
  }
}, _class2.propTypes = {
  html: _propTypes2.default.string,
  markdown: _propTypes2.default.string,
  switchToIssueish: _propTypes2.default.func.isRequired
}, _class2.contextTypes = {
  relayEnvironment: _propTypes2.default.object.isRequired
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'handleClick', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleClick'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'openLinkInNewTab', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'openLinkInNewTab'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'openLinkInThisTab', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'openLinkInThisTab'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'openLinkInBrowser', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'openLinkInBrowser'), _class.prototype)), _class);
exports.default = GithubDotcomMarkdown;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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