'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _desc, _value, _class, _class2, _temp; /** @jsx etch.dom */
/* eslint react/no-unknown-property: "off" */

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _coreDecorators = require('core-decorators');

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _stagingView = require('./staging-view');

var _stagingView2 = _interopRequireDefault(_stagingView);

var _gitLogo = require('./git-logo');

var _gitLogo2 = _interopRequireDefault(_gitLogo);

var _commitViewController = require('../controllers/commit-view-controller');

var _commitViewController2 = _interopRequireDefault(_commitViewController);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let GitTabView = (_class = (_temp = _class2 = class GitTabView {

  constructor(props) {
    this.props = props;
    _etch2.default.initialize(this);

    this.subscriptions = this.props.commandRegistry.add(this.element, {
      'tool-panel:unfocus': this.blur,
      'core:focus-next': this.advanceFocus,
      'core:focus-previous': this.retreatFocus
    });
  }

  update(props) {
    this.props = props;
    return _etch2.default.update(this);
  }

  render() {
    if (this.props.repository.showGitTabInit()) {
      const inProgress = this.props.repository.showGitTabInitInProgress();
      const message = this.props.repository.hasDirectory() ? 'Initialize this project directory with a git repository' : 'Initialize a new project directory with a git repository';

      return _etch2.default.dom(
        'div',
        { className: 'github-Panel is-empty', tabIndex: '-1' },
        _etch2.default.dom(
          'div',
          { ref: 'noRepoMessage', className: 'github-Panel no-repository' },
          _etch2.default.dom(
            'div',
            { className: 'large-icon' },
            _etch2.default.dom(_gitLogo2.default, null)
          ),
          _etch2.default.dom(
            'div',
            { className: 'initialize-repo-description' },
            message
          ),
          _etch2.default.dom(
            'button',
            { onclick: this.initializeRepo, disabled: inProgress, className: 'btn btn-primary' },
            inProgress ? 'Creating repository...' : 'Create repository'
          )
        )
      );
    } else {
      const isLoading = this.props.fetchInProgress || this.props.repository.showGitTabLoading();

      return _etch2.default.dom(
        'div',
        { className: (0, _classnames2.default)('github-Panel', { 'is-loading': isLoading }), tabIndex: '-1' },
        _etch2.default.dom(_stagingView2.default, {
          ref: 'stagingView',
          commandRegistry: this.props.commandRegistry,
          stagedChanges: this.props.stagedChanges,
          unstagedChanges: this.props.unstagedChanges,
          mergeConflicts: this.props.mergeConflicts,
          workingDirectoryPath: this.props.workingDirectoryPath,
          resolutionProgress: this.props.resolutionProgress,
          didSelectFilePath: this.props.didSelectFilePath,
          didSelectMergeConflictFile: this.props.didSelectMergeConflictFile,
          didDiveIntoFilePath: this.props.didDiveIntoFilePath,
          didDiveIntoMergeConflictPath: this.props.didDiveIntoMergeConflictPath,
          openFiles: this.props.openFiles,
          discardWorkDirChangesForPaths: this.props.discardWorkDirChangesForPaths,
          focusFilePatchView: this.props.focusFilePatchView,
          attemptFileStageOperation: this.props.attemptFileStageOperation,
          undoLastDiscard: this.props.undoLastDiscard,
          abortMerge: this.props.abortMerge,
          resolveAsOurs: this.props.resolveAsOurs,
          resolveAsTheirs: this.props.resolveAsTheirs,
          lastCommit: this.props.lastCommit,
          isLoading: this.props.isLoading,
          isAmending: this.props.isAmending,
          hasUndoHistory: this.props.hasUndoHistory,
          isMerging: this.props.isMerging
        }),
        _etch2.default.dom(_commitViewController2.default, {
          ref: 'commitViewController',
          stagedChangesExist: this.props.stagedChanges.length > 0,
          mergeConflictsExist: this.props.mergeConflicts.length > 0,
          prepareToCommit: this.props.prepareToCommit,
          commit: this.props.commit,
          amending: this.props.amending,
          setAmending: this.props.setAmending,
          abortMerge: this.props.abortMerge,
          branchName: this.props.branchName,
          commandRegistry: this.props.commandRegistry,
          notificationManager: this.props.notificationManager,
          mergeMessage: this.props.mergeMessage,
          isMerging: this.props.isMerging,
          isAmending: this.props.isAmending,
          isLoading: this.props.isLoading,
          lastCommit: this.props.lastCommit,
          repository: this.props.repository
        })
      );
    }
  }

  destroy() {
    this.subscriptions.dispose();
    return _etch2.default.destroy(this);
  }

  initializeRepo(event) {
    var _this = this;

    return _asyncToGenerator(function* () {
      event.preventDefault();
      yield _this.props.initializeRepo();
    })();
  }

  rememberFocus(event) {
    let currentFocus = null;

    if (this.refs.stagingView) {
      currentFocus = this.refs.stagingView.rememberFocus(event);
    }

    if (!currentFocus && this.refs.commitViewController) {
      currentFocus = this.refs.commitViewController.rememberFocus(event);
    }

    return currentFocus;
  }

  setFocus(focus) {
    if (this.refs.stagingView) {
      if (this.refs.stagingView.setFocus(focus)) {
        return true;
      }
    }

    if (this.refs.commitViewController) {
      if (this.refs.commitViewController.setFocus(focus)) {
        return true;
      }
    }

    return false;
  }

  blur() {
    this.props.workspace.getActivePane().activate();
  }

  advanceFocus() {
    if (!this.refs.stagingView.activateNextList()) {
      this.refs.commitViewController.setFocus(GitTabView.focus.EDITOR);
    }
  }

  retreatFocus() {
    var _refs = this.refs;
    const stagingView = _refs.stagingView,
          commitViewController = _refs.commitViewController;


    if (commitViewController.hasFocus()) {
      if (stagingView.activateLastList()) {
        this.setFocus(GitTabView.focus.STAGING);
      }
    } else {
      stagingView.activatePreviousList();
    }
  }

  focusAndSelectStagingItem(filePath, stagingStatus) {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      yield _this2.refs.stagingView.quietlySelectItem(filePath, stagingStatus);
      _this2.setFocus(GitTabView.focus.STAGING);
    })();
  }

  hasFocus() {
    return this.element.contains(document.activeElement);
  }

  quietlySelectItem(filePath, stagingStatus) {
    return this.refs.stagingView.quietlySelectItem(filePath, stagingStatus);
  }
}, _class2.focus = _extends({}, _stagingView2.default.focus, _commitViewController2.default.focus), _temp), (_applyDecoratedDescriptor(_class.prototype, 'initializeRepo', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'initializeRepo'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'blur', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'blur'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'advanceFocus', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'advanceFocus'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'retreatFocus', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'retreatFocus'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'quietlySelectItem', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'quietlySelectItem'), _class.prototype)), _class);
exports.default = GitTabView;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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