'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _eventKit = require('event-kit');

var _portal = require('./portal');

var _portal2 = _interopRequireDefault(_portal);

var _stubItem = require('../atom-items/stub-item');

var _stubItem2 = _interopRequireDefault(_stubItem);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

/**
 * `DockItem` adds its child to an Atom dock when rendered.
 * When the item is closed, the component's `onDidCloseItem` is called.
 * You should use this callback to set state so that the `DockItem` is no
 * longer rendered; you will get an error in your console if you forget.
 *
 * You may pass a `getItem` function that takes an object with `portal` and
 * `subtree` properties. `getItem` should return an item to be added to the
 * Dock. `portal` is an instance of th Portal component, and `subtree` is the
 * rendered subtree component built from the `children` prop. The default
 * implementation simply returns the Portal instance, which contains a
 * `getElement` method (to be compatible with Atom's view system).
 *
 * Unmounting the component when the item is open will close the item.
 */
let DockItem = (_temp = _class = class DockItem extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.dockItemPromise = new Promise(resolve => {
      this.resolveDockItemPromise = resolve;
    });
  }

  componentDidMount() {
    this.setupDockItem();
  }

  componentWillReceiveProps() {
    if (this.didCloseItem) {
      // eslint-disable-next-line no-console
      console.error('Unexpected update in `DockItem`: the contained item has been closed');
    }
  }

  render() {
    let getDOMNode;
    if (this.props.stubItemSelector) {
      getDOMNode = () => _stubItem2.default.getElementBySelector(this.props.stubItemSelector);
    }

    return _react2.default.createElement(
      _portal2.default,
      { ref: c => {
          this.portal = c;
        }, getDOMNode: getDOMNode },
      this.props.children
    );
  }

  setupDockItem() {
    if (this.dockItem) {
      return;
    }

    const itemToAdd = this.props.getItem({ portal: this.portal, subtree: this.portal.getRenderedSubtree() });

    this.subscriptions = new _eventKit.CompositeDisposable();
    if (itemToAdd.wasActivated) {
      this.subscriptions.add(this.props.workspace.onDidChangeActivePaneItem(activeItem => {
        if (activeItem === this.dockItem) {
          itemToAdd.wasActivated();
        }
      }));
    }

    let stub;
    if (this.props.stubItemSelector) {
      stub = _stubItem2.default.getBySelector(this.props.stubItemSelector);
    }

    if (stub) {
      stub.setRealItem(itemToAdd);
      this.dockItem = stub;
      this.resolveDockItemPromise(this.dockItem);
      if (this.props.activate) {
        this.activate();
      }
    } else {
      Promise.resolve(this.props.workspace.open(itemToAdd, { activatePane: false })).then(item => {
        this.dockItem = item;
        this.resolveDockItemPromise(this.dockItem);
        if (this.props.activate) {
          this.activate();
        }
      });
    }

    this.subscriptions.add(this.props.workspace.onDidDestroyPaneItem((_ref) => {
      let item = _ref.item;

      if (item === this.dockItem) {
        this.didCloseItem = true;
        this.props.onDidCloseItem(this.dockItem);
      }
    }));
  }

  componentWillUnmount() {
    this.subscriptions && this.subscriptions.dispose();
    if (this.dockItem && !this.didCloseItem) {
      const pane = this.props.workspace.paneForItem(this.dockItem);
      if (this.dockItem.destroy) {
        this.dockItem.destroy();
      }
      pane.destroyItem(this.dockItem);
    }
  }

  getDockItem() {
    return this.dockItem;
  }

  getDockItemPromise() {
    return this.dockItemPromise;
  }

  reveal() {
    var _this = this;

    return _asyncToGenerator(function* () {
      const dockItem = yield _this.getDockItemPromise();
      return _this.props.workspace.open(dockItem, {
        searchAllPanes: true
      });
    })();
  }

  hide() {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      const dockItem = yield _this2.getDockItemPromise();
      return _this2.props.workspace.hide(dockItem);
    })();
  }

  activate() {
    setTimeout(() => {
      if (!this.dockItem || this.didCloseItem || this.props.workspace.isDestroyed()) {
        return;
      }

      const pane = this.props.workspace.paneForItem(this.dockItem);
      if (pane) {
        pane.activateItem(this.dockItem);
        const dock = this.props.workspace.getPaneContainers().find(container => container.getPanes().find(p => p.getItems().includes(this.dockItem)));
        if (dock && dock.show) {
          dock.show();
        }
      } else {
        throw new Error('Cannot find pane for item in `DockItem#activate`');
      }
    });
  }
}, _class.propTypes = {
  workspace: _propTypes2.default.object.isRequired,
  children: _propTypes2.default.element.isRequired,
  getItem: _propTypes2.default.func,
  onDidCloseItem: _propTypes2.default.func,
  stubItemSelector: _propTypes2.default.string,
  activate: _propTypes2.default.bool
}, _class.defaultProps = {
  getItem: (_ref2) => {
    let portal = _ref2.portal,
        subtree = _ref2.subtree;
    return portal.getView();
  },
  onDidCloseItem: dockItem => {}
}, _temp);
exports.default = DockItem;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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