'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _eventKit = require('event-kit');

var _portal = require('./portal');

var _portal2 = _interopRequireDefault(_portal);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let Decoration = (_temp = _class = class Decoration extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.decoration = null;
    this.subscriptions = new _eventKit.CompositeDisposable();
  }

  usesItem() {
    return this.props.type === 'gutter' || this.props.type === 'overlay' || this.props.type === 'block';
  }

  componentWillReceiveProps(nextProps) {
    let recreationRequired = this.props.editor !== nextProps.editor || this.props.marker !== nextProps.marker || this.props.type !== nextProps.type || this.props.position !== nextProps.position || this.props.className !== nextProps.className || this.props.getItem !== nextProps.getItem || this.props.children !== nextProps.children;

    if (!recreationRequired) {
      // Compare additional options.
      const optionKeys = Object.keys(this.props.options);
      const nextOptionKeys = Object.keys(nextProps.options);

      if (optionKeys.length !== nextOptionKeys.length) {
        recreationRequired = true;
      } else {
        for (let i = 0; i < optionKeys.length; i++) {
          const key = optionKeys[i];
          if (this.props.options[key] !== nextProps.options[key]) {
            recreationRequired = true;
            break;
          }
        }
      }
    }

    if (recreationRequired) {
      this.decoration && this.decoration.destroy();
      this.setupDecoration(nextProps);
    }
  }

  componentDidMount() {
    this.setupDecoration(this.props);
  }

  render() {
    if (this.usesItem()) {
      return _react2.default.createElement(
        _portal2.default,
        { ref: c => {
            this.portal = c;
          } },
        this.props.children
      );
    } else {
      return null;
    }
  }

  setupDecoration(props) {
    if (this.decoration) {
      return;
    }

    let item = null;
    if (this.usesItem()) {
      item = props.getItem({ portal: this.portal, subtree: this.portal.getRenderedSubtree() });
    }

    const options = _extends({}, props.options, {
      type: props.type,
      position: props.position,
      class: props.className,
      item
    });

    this.decoration = props.editor.decorateMarker(props.marker, options);
    this.subscriptions.add(this.decoration.onDidDestroy(() => {
      this.decoration = null;
      this.subscriptions.dispose();
    }));
  }

  componentWillUnmount() {
    this.decoration && this.decoration.destroy();
    this.subscriptions.dispose();
  }
}, _class.propTypes = {
  editor: _propTypes2.default.object.isRequired,
  marker: _propTypes2.default.object.isRequired,
  type: _propTypes2.default.oneOf(['line', 'line-number', 'highlight', 'overlay', 'gutter', 'block']).isRequired,
  position: _propTypes2.default.oneOf(['head', 'tail', 'before', 'after']),
  className: _propTypes2.default.string,
  children: _propTypes2.default.element,
  getItem: _propTypes2.default.func,
  options: _propTypes2.default.object
}, _class.defaultProps = {
  options: {},
  position: 'head',
  getItem: (_ref) => {
    let portal = _ref.portal,
        subtree = _ref.subtree;
    return portal;
  }
}, _temp);
exports.default = Decoration;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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