'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _commands = require('./commands');

var _commands2 = _interopRequireDefault(_commands);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let CredentialDialog = (_class = (_temp = _class2 = class CredentialDialog extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.state = {
      username: '',
      password: ''
    };
  }

  componentDidMount() {
    setTimeout(this.focusFirstInput);
  }

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'github-Dialog github-Credentials modal native-key-bindings' },
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: '.github-Credentials' },
        _react2.default.createElement(_commands.Command, { command: 'core:cancel', callback: this.cancel }),
        _react2.default.createElement(_commands.Command, { command: 'core:confirm', callback: this.confirm })
      ),
      _react2.default.createElement(
        'header',
        { className: 'github-DialogPrompt' },
        this.props.prompt
      ),
      _react2.default.createElement(
        'main',
        { className: 'github-DialogInputs' },
        this.props.includeUsername ? _react2.default.createElement(
          'label',
          { className: 'github-DialogLabel' },
          'Username:',
          _react2.default.createElement('input', {
            type: 'text',
            ref: e => this.usernameInput = e,
            className: 'input-text github-CredentialDialog-Username',
            value: this.state.username,
            onChange: this.onUsernameChange,
            tabIndex: '1'
          })
        ) : null,
        _react2.default.createElement(
          'label',
          { className: 'github-DialogLabel' },
          'Password:',
          _react2.default.createElement('input', {
            type: 'password',
            ref: e => this.passwordInput = e,
            className: 'input-text github-CredentialDialog-Password',
            value: this.state.password,
            onChange: this.onPasswordChange,
            tabIndex: '2'
          })
        )
      ),
      _react2.default.createElement(
        'footer',
        { className: 'github-DialogButtons' },
        _react2.default.createElement(
          'button',
          { className: 'btn github-CancelButton', tabIndex: '3', onClick: this.cancel },
          'Cancel'
        ),
        _react2.default.createElement(
          'button',
          { className: 'btn btn-primary', tabIndex: '4', onClick: this.confirm },
          'Sign in'
        )
      )
    );
  }

  confirm() {
    const payload = { password: this.state.password };

    if (this.props.includeUsername) {
      payload.username = this.state.username;
    }

    this.props.onSubmit(payload);
  }

  cancel() {
    this.props.onCancel();
  }

  onUsernameChange(e) {
    this.setState({ username: e.target.value });
  }

  onPasswordChange(e) {
    this.setState({ password: e.target.value });
  }

  focusFirstInput() {
    (this.usernameInput || this.passwordInput).focus();
  }
}, _class2.propTypes = {
  commandRegistry: _propTypes2.default.object.isRequired,
  prompt: _propTypes2.default.string.isRequired,
  includeUsername: _propTypes2.default.bool,
  onSubmit: _propTypes2.default.func,
  onCancel: _propTypes2.default.func
}, _class2.defaultProps = {
  includeUsername: false,
  onSubmit: () => {},
  onCancel: () => {}
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'confirm', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'confirm'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'cancel', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'cancel'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'onUsernameChange', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'onUsernameChange'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'onPasswordChange', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'onPasswordChange'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'focusFirstInput', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'focusFirstInput'), _class.prototype)), _class);
exports.default = CredentialDialog;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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