'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _desc, _value, _class, _class2, _temp; /** @jsx etch.dom */
/* eslint react/no-unknown-property: "off" */

var _atom = require('atom');

var _eventKit = require('event-kit');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _coreDecorators = require('core-decorators');

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let CommitView = (_class = (_temp = _class2 = class CommitView {

  constructor(props) {
    this.props = props;

    _etch2.default.initialize(this);

    this.editor = this.refs.editor;
    // FIXME Use props-injected view registry instead of the Atom global
    this.editorElement = atom.views.getView(this.editor);
    this.editor.setText(this.props.message || '');
    this.subscriptions = new _eventKit.CompositeDisposable(this.editor.onDidChange(() => this.props.onChangeMessage && this.props.onChangeMessage(this.editor.getText())), this.editor.onDidChangeCursorPosition(() => {
      _etch2.default.update(this);
    }), props.commandRegistry.add('atom-workspace', { 'github:commit': this.commit }));
  }

  destroy() {
    this.subscriptions.dispose();
    _etch2.default.destroy(this);
  }

  update(props) {
    const previousMessage = this.props.message;
    this.props = _extends({}, this.props, props);
    const newMessage = this.props.message;
    if (this.editor && previousMessage !== newMessage && this.editor.getText() !== newMessage) {
      this.editor.setText(newMessage);
    }
    return _etch2.default.update(this);
  }

  render() {
    let remainingCharsClassName = '';
    if (this.getRemainingCharacters() < 0) {
      remainingCharsClassName = 'is-error';
    } else if (this.getRemainingCharacters() < this.props.maximumCharacterLimit / 4) {
      remainingCharsClassName = 'is-warning';
    }

    const showAbortMergeButton = this.props.isMerging || null;
    const showAmendBox = !this.props.isMerging && this.props.lastCommit.isPresent() && !this.props.lastCommit.isUnbornRef() || null;

    return _etch2.default.dom(
      'div',
      { className: 'github-CommitView', ref: 'CommitView' },
      _etch2.default.dom(
        'div',
        { className: 'github-CommitView-editor' },
        _etch2.default.dom(_atom.TextEditor, {
          ref: 'editor',
          softWrapped: true,
          placeholderText: 'Commit message',
          lineNumberGutterVisible: false,
          showInvisibles: false,
          autoHeight: false,
          scrollPastEnd: false
        })
      ),
      _etch2.default.dom(
        'footer',
        { className: 'github-CommitView-bar' },
        showAbortMergeButton && _etch2.default.dom(
          'button',
          { ref: 'abortMergeButton', className: 'btn github-CommitView-button is-secondary',
            onclick: this.abortMerge },
          'Abort Merge'
        ),
        showAmendBox && _etch2.default.dom(
          'label',
          { className: 'github-CommitView-label input-label' },
          _etch2.default.dom('input', {
            ref: 'amend',
            className: 'input-checkbox',
            type: 'checkbox',
            onclick: this.handleAmendBoxClick,
            checked: this.props.isAmending
          }),
          ' Amend'
        ),
        _etch2.default.dom(
          'button',
          { ref: 'commitButton', className: 'btn github-CommitView-button',
            onclick: this.commit,
            disabled: !this.isCommitButtonEnabled() },
          this.commitButtonText()
        ),
        _etch2.default.dom(
          'div',
          { ref: 'remainingCharacters',
            className: `github-CommitView-remaining-characters ${remainingCharsClassName}` },
          this.getRemainingCharacters()
        )
      )
    );
  }

  abortMerge() {
    this.props.abortMerge();
  }

  handleAmendBoxClick() {
    this.props.setAmending(this.refs.amend.checked);
  }

  commit() {
    var _this = this;

    return _asyncToGenerator(function* () {
      if ((yield _this.props.prepareToCommit()) && _this.isCommitButtonEnabled()) {
        yield _this.props.commit(_this.editor.getText());
      } else {
        _this.setFocus(CommitView.focus.EDITOR);
      }
    })();
  }

  getRemainingCharacters() {
    if (this.editor != null) {
      if (this.editor.getCursorBufferPosition().row === 0) {
        return (this.props.maximumCharacterLimit - this.editor.lineTextForBufferRow(0).length).toString();
      } else {
        return '∞';
      }
    } else {
      return this.props.maximumCharacterLimit || '';
    }
  }

  isCommitButtonEnabled() {
    return this.props.stagedChangesExist && !this.props.mergeConflictsExist && this.props.lastCommit.isPresent() && this.editor && this.editor.getText().length !== 0;
  }

  commitButtonText() {
    if (this.props.isAmending) {
      return `Amend commit (${(0, _helpers.shortenSha)(this.props.lastCommit.getSha())})`;
    } else {
      if (this.props.branchName) {
        return `Commit to ${this.props.branchName}`;
      } else {
        return 'Commit';
      }
    }
  }

  rememberFocus(event) {
    if (this.editorElement.contains(event.target)) {
      return CommitView.focus.EDITOR;
    }

    if (this.refs.abortMergeButton && this.refs.abortMergeButton.contains(event.target)) {
      return CommitView.focus.ABORT_MERGE_BUTTON;
    }

    if (this.refs.amend && this.refs.amend.contains(event.target)) {
      return CommitView.focus.AMEND_BOX;
    }

    if (this.refs.commitButton && this.refs.commitButton.contains(event.target)) {
      return CommitView.focus.COMMIT_BUTTON;
    }

    return null;
  }

  setFocus(focus) {
    let fallback = false;

    if (focus === CommitView.focus.EDITOR) {
      this.editorElement.focus();
      return true;
    }

    if (focus === CommitView.focus.ABORT_MERGE_BUTTON) {
      if (this.refs.abortMergeButton) {
        this.refs.abortMergeButton.focus();
        return true;
      } else {
        fallback = true;
      }
    }

    if (focus === CommitView.focus.AMEND_BOX) {
      if (this.refs.amend) {
        this.refs.amend.focus();
        return true;
      } else {
        fallback = true;
      }
    }

    if (focus === CommitView.focus.COMMIT_BUTTON) {
      if (this.refs.commitButton) {
        this.refs.commitButton.focus();
        return true;
      } else {
        fallback = true;
      }
    }

    if (fallback) {
      this.editorElement.focus();
      return true;
    }

    return false;
  }
}, _class2.focus = {
  EDITOR: Symbol('commit-editor'),
  ABORT_MERGE_BUTTON: Symbol('commit-abort-merge-button'),
  AMEND_BOX: Symbol('commit-amend-box'),
  COMMIT_BUTTON: Symbol('commit-button')
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'abortMerge', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'abortMerge'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'handleAmendBoxClick', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleAmendBoxClick'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'commit', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'commit'), _class.prototype)), _class);
exports.default = CommitView;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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