'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Command = exports.default = undefined;

var _class, _temp, _class2, _temp2;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _propTypes3 = require('../prop-types');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let Commands = (_temp = _class = class Commands extends _react2.default.Component {

  render() {
    var _props = this.props;
    const registry = _props.registry,
          target = _props.target;

    return _react2.default.createElement(
      'div',
      null,
      _react2.default.Children.map(this.props.children, child => {
        return _react2.default.cloneElement(child, { registry, target });
      })
    );
  }
}, _class.propTypes = {
  registry: _propTypes2.default.object.isRequired,
  target: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes3.DOMNodePropType]).isRequired,
  children: _propTypes2.default.oneOfType([_propTypes2.default.element, _propTypes2.default.arrayOf(_propTypes2.default.element)]).isRequired
}, _temp);
exports.default = Commands;
let Command = exports.Command = (_temp2 = _class2 = class Command extends _react2.default.Component {

  componentDidMount() {
    this.registerCommand(this.props);
  }

  componentWillReceiveProps(newProps) {
    for (const prop of ['registry', 'target', 'command', 'callback']) {
      if (newProps[prop] !== this.props[prop]) {
        this.disposable.dispose();
        this.registerCommand(newProps);
      }
    }
  }

  componentWillUnmount() {
    this.disposable.dispose();
  }

  registerCommand(_ref) {
    let registry = _ref.registry,
        target = _ref.target,
        command = _ref.command,
        callback = _ref.callback;

    this.disposable = registry.add(target, command, callback);
  }

  render() {
    return null;
  }
}, _class2.propTypes = {
  registry: _propTypes2.default.object,
  target: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes3.DOMNodePropType]),
  command: _propTypes2.default.string.isRequired,
  callback: _propTypes2.default.func.isRequired
}, _temp2);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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