'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _eventKit = require('event-kit');

var _url = require('url');

var _url2 = _interopRequireDefault(_url);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _commands = require('./commands');

var _commands2 = _interopRequireDefault(_commands);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let CloneDialog = (_class = (_temp = _class2 = class CloneDialog extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.state = {
      cloneDisabled: false
    };

    this.projectHome = this.props.config.get('core.projectHome');
    this.subs = new _eventKit.CompositeDisposable();
  }

  componentDidMount() {
    if (this.projectPathEditor) {
      this.projectPathEditor.setText(this.props.config.get('core.projectHome'));
      this.projectPathModified = false;
    }

    if (this.remoteUrlElement) {
      setTimeout(() => this.remoteUrlElement.focus());
    }
  }

  render() {
    if (!this.props.inProgress) {
      return this.renderDialog();
    } else {
      return this.renderSpinner();
    }
  }

  renderDialog() {
    return _react2.default.createElement(
      'div',
      { className: 'github-Dialog github-Clone modal' },
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: '.github-Clone' },
        _react2.default.createElement(_commands.Command, { command: 'core:cancel', callback: this.cancel }),
        _react2.default.createElement(_commands.Command, { command: 'core:confirm', callback: this.clone })
      ),
      _react2.default.createElement(
        'main',
        { className: 'github-DialogInputs' },
        _react2.default.createElement(
          'label',
          { className: 'github-DialogLabel github-CloneUrl' },
          'Clone from',
          _react2.default.createElement('atom-text-editor', { mini: true, ref: this.editorRefs('remoteUrl'), tabIndex: '1' })
        ),
        _react2.default.createElement(
          'label',
          { className: 'github-DialogLabel github-ProjectPath' },
          'To directory',
          _react2.default.createElement('atom-text-editor', { mini: true, ref: this.editorRefs('projectPath'), tabIndex: '2' })
        )
      ),
      _react2.default.createElement(
        'div',
        { className: 'github-DialogButtons' },
        _react2.default.createElement(
          'button',
          { className: 'btn github-CancelButton', onClick: this.cancel, tabIndex: '3' },
          'Cancel'
        ),
        _react2.default.createElement(
          'button',
          {
            className: 'btn btn-primary icon icon-repo-clone',
            onClick: this.clone,
            disabled: this.state.cloneDisabled,
            tabIndex: '4' },
          'Clone'
        )
      )
    );
  }

  renderSpinner() {
    return _react2.default.createElement(
      'div',
      { className: 'github-Dialog github-Clone modal' },
      _react2.default.createElement(
        'main',
        { className: 'github-DialogSpinner' },
        _react2.default.createElement('span', { className: 'loading loading-spinner-small inline-block' }),
        _react2.default.createElement(
          'span',
          { className: 'github-DialogMessage inline-block' },
          'Cloning ',
          _react2.default.createElement(
            'strong',
            null,
            this.getRemoteUrl()
          )
        )
      )
    );
  }

  clone() {
    if (this.getRemoteUrl().length === 0 || this.getProjectPath().length === 0) {
      return;
    }

    this.props.didAccept(this.getRemoteUrl(), this.getProjectPath());
  }

  cancel() {
    this.props.didCancel();
  }

  didChangeRemoteUrl() {
    if (!this.projectPathModified) {
      const name = _path2.default.basename(_url2.default.parse(this.getRemoteUrl()).pathname, '.git') || '';

      if (name.length > 0) {
        const proposedPath = _path2.default.join(this.projectHome, name);
        this.projectPathEditor.setText(proposedPath);
        this.projectPathModified = false;
      }
    }

    this.setCloneEnablement();
  }

  didChangeProjectPath() {
    this.projectPathModified = true;
    this.setCloneEnablement();
  }

  editorRefs(baseName) {
    const elementName = `${baseName}Element`;
    const modelName = `${baseName}Editor`;
    const subName = `${baseName}Subs`;
    const changeMethodName = `didChange${baseName[0].toUpperCase()}${baseName.substring(1)}`;

    return element => {
      if (!element) {
        return;
      }

      this[elementName] = element;
      const editor = element.getModel();
      if (this[modelName] !== editor) {
        this[modelName] = editor;

        if (this[subName]) {
          this[subName].dispose();
          this.subs.remove(this[subName]);
        }

        this[subName] = editor.onDidChange(this[changeMethodName]);
        this.subs.add(this[subName]);
      }
    };
  }

  getProjectPath() {
    return this.projectPathEditor ? this.projectPathEditor.getText() : '';
  }

  getRemoteUrl() {
    return this.remoteUrlEditor ? this.remoteUrlEditor.getText() : '';
  }

  setCloneEnablement() {
    const disabled = this.getRemoteUrl().length === 0 || this.getProjectPath().length === 0;
    this.setState({ cloneDisabled: disabled });
  }
}, _class2.propTypes = {
  config: _propTypes2.default.object.isRequired,
  commandRegistry: _propTypes2.default.object.isRequired,
  inProgress: _propTypes2.default.bool,
  didAccept: _propTypes2.default.func,
  didCancel: _propTypes2.default.func
}, _class2.defaultProps = {
  inProgress: false,
  didAccept: () => {},
  didCancel: () => {}
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'clone', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'clone'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'cancel', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'cancel'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'didChangeRemoteUrl', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'didChangeRemoteUrl'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'didChangeProjectPath', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'didChangeProjectPath'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'editorRefs', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'editorRefs'), _class.prototype)), _class);
exports.default = CloneDialog;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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