'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _octicon = require('./octicon');

var _octicon2 = _interopRequireDefault(_octicon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let ChangedFilesCountView = (_temp = _class = class ChangedFilesCountView extends _react2.default.Component {

  render() {
    const label = this.props.changedFilesCount === 1 ? '1 file' : `${this.props.changedFilesCount} files`;
    return _react2.default.createElement(
      'a',
      {
        ref: 'changedFiles',
        className: 'github-ChangedFilesCount inline-block icon icon-diff',
        onClick: this.props.didClick },
      label,
      this.props.mergeConflictsPresent && _react2.default.createElement(_octicon2.default, { icon: 'alert' })
    );
  }
}, _class.propTypes = {
  changedFilesCount: _propTypes2.default.number.isRequired,
  didClick: _propTypes2.default.func.isRequired,
  mergeConflictsPresent: _propTypes2.default.bool
}, _class.defaultProps = {
  changedFilesCount: 0,
  mergeConflictsPresent: false,
  didClick: () => {}
}, _temp);
exports.default = ChangedFilesCountView;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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